/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.string;

import org.apache.commons.lang.StringUtils;
import water.MRTask;
import water.fvec.C0DChunk;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstStrList;
import water.rapids.vals.ValFrame;

public class AstCountMatches
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "pattern"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "countmatches";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        String[] stringArray;
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (asts[2] instanceof AstStrList) {
            stringArray = ((AstStrList)asts[2])._strs;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = asts[2].exec(env).getStr();
        }
        String[] pattern = stringArray;
        for (Vec v2 : fr.vecs()) {
            if (v2.isCategorical() || v2.isString()) continue;
            throw new IllegalArgumentException("countmatches() requires a string or categorical column. Received " + fr.anyVec().get_type_str() + ". Please convert column to a string or categorical first.");
        }
        Vec[] nvs = new Vec[fr.numCols()];
        int i2 = 0;
        for (Vec v3 : fr.vecs()) {
            nvs[i2] = v3.isCategorical() ? this.countMatchesCategoricalCol(v3, pattern) : this.countMatchesStringCol(v3, pattern);
            ++i2;
        }
        return new ValFrame(new Frame(nvs));
    }

    private Vec countMatchesCategoricalCol(Vec vec, String[] pattern) {
        final int[] matchCounts = this.countDomainMatches(vec.domain(), pattern);
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk[] ncs) {
                Chunk c2 = cs[0];
                for (int i2 = 0; i2 < c2._len; ++i2) {
                    if (!c2.isNA(i2)) {
                        int idx = (int)c2.at8(i2);
                        ncs[0].addNum(matchCounts[idx]);
                        continue;
                    }
                    ncs[0].addNA();
                }
            }
        }.doAll(1, (byte)3, new Frame(vec))).outputFrame().anyVec();
    }

    int[] countDomainMatches(String[] domain, String[] pattern) {
        int[] res = new int[domain.length];
        for (int i2 = 0; i2 < domain.length; ++i2) {
            for (String aPattern : pattern) {
                int n2 = i2;
                res[n2] = res[n2] + StringUtils.countMatches((String)domain[i2], (String)aPattern);
            }
        }
        return res;
    }

    private Vec countMatchesStringCol(Vec vec, String[] pat) {
        final String[] pattern = pat;
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk chk, NewChunk newChk) {
                if (chk instanceof C0DChunk) {
                    for (int i2 = 0; i2 < chk.len(); ++i2) {
                        newChk.addNA();
                    }
                } else {
                    BufferedString tmpStr = new BufferedString();
                    for (int i3 = 0; i3 < chk._len; ++i3) {
                        if (chk.isNA(i3)) {
                            newChk.addNA();
                            continue;
                        }
                        int cnt = 0;
                        for (String aPattern : pattern) {
                            cnt += StringUtils.countMatches((String)chk.atStr(tmpStr, i3).toString(), (String)aPattern);
                        }
                        newChk.addNum(cnt, 0);
                    }
                }
            }
        }.doAll((byte)3, new Frame(vec))).outputFrame().anyVec();
    }
}

