/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.search;

import water.Futures;
import water.MRTask;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstWhich
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public String str() {
        return "which";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame f2 = stk.track(asts[1].exec(env)).getFrame();
        if (f2.numRows() == 1L && f2.numCols() > 1) {
            AppendableVec v2 = new AppendableVec(Vec.VectorGroup.VG_LEN1.addVec(), 3);
            NewChunk chunk = new NewChunk(v2, 0);
            for (int i2 = 0; i2 < f2.numCols(); ++i2) {
                if (f2.vecs()[i2].at8(0L) == 0L) continue;
                chunk.addNum(i2);
            }
            Futures fs = chunk.close(0, new Futures());
            Vec vec = v2.layout_and_close(fs);
            fs.blockForPending();
            return new ValFrame(new Frame(vec));
        }
        Vec vec = f2.anyVec();
        if (f2.numCols() > 1 || !vec.isInt()) {
            throw new IllegalArgumentException("which requires a single integer column");
        }
        Frame f22 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c2, NewChunk nc) {
                long start = c2.start();
                for (int i2 = 0; i2 < c2._len; ++i2) {
                    if (c2.at8(i2) == 0L) continue;
                    nc.addNum(start + (long)i2);
                }
            }
        }.doAll(new byte[]{3}, vec)).outputFrame();
        return new ValFrame(f22);
    }
}

