/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.reducers;

import hex.quantile.QuantileModel;
import water.DKV;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.prims.reducers.AstMedian;
import water.rapids.vals.ValNum;

public class AstMad
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "combineMethod", "const"};
    }

    @Override
    public int nargs() {
        return 4;
    }

    @Override
    public String str() {
        return "h2o.mad";
    }

    @Override
    public ValNum apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        Vec[] vecs = fr.vecs();
        if (vecs.length == 0 || vecs[0].naCnt() > 0L) {
            return new ValNum(Double.NaN);
        }
        if (vecs.length > 1) {
            throw new IllegalArgumentException("MAD expects a single numeric column");
        }
        QuantileModel.CombineMethod cm = QuantileModel.CombineMethod.valueOf(asts[2].exec(env).getStr().toUpperCase());
        double constant = asts[3].exec(env).getNum();
        return new ValNum(AstMad.mad(fr, cm, constant));
    }

    public static double mad(Frame f2, QuantileModel.CombineMethod cm, double constant) {
        Key<Frame> tk = null;
        if (f2._key == null) {
            tk = Key.make();
            f2 = new Frame(tk, f2.names(), f2.vecs());
            DKV.put(tk, f2);
        }
        final double median = AstMedian.median(f2, cm);
        Frame abs_dev = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c2, NewChunk nc) {
                for (int i2 = 0; i2 < c2._len; ++i2) {
                    nc.addNum(Math.abs((double)c2.at8(i2) - median));
                }
            }
        }.doAll(1, (byte)3, f2)).outputFrame();
        if (abs_dev._key == null) {
            tk = Key.make();
            abs_dev = new Frame(tk, abs_dev.names(), abs_dev.vecs());
            DKV.put(tk, abs_dev);
        }
        double mad = AstMedian.median(abs_dev, cm);
        DKV.remove(f2._key);
        DKV.remove(abs_dev._key);
        return constant * mad;
    }
}

