/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.operators;

import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.parser.BufferedString;
import water.rapids.ast.prims.operators.AstBinOp;
import water.rapids.vals.ValFrame;
import water.util.MathUtils;
import water.util.StringUtils;

public class AstEq
extends AstBinOp {
    @Override
    public String str() {
        return "==";
    }

    @Override
    public double op(double l2, double r2) {
        return MathUtils.equalsWithinOneSmallUlp(l2, r2) ? 1.0 : 0.0;
    }

    @Override
    public ValFrame frame_op_scalar(Frame fr, final double d2) {
        return new ValFrame(((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] cress) {
                for (int c2 = 0; c2 < chks.length; ++c2) {
                    int i2;
                    Chunk chk = chks[c2];
                    NewChunk cres = cress[c2];
                    BufferedString bStr = new BufferedString();
                    if (chk.vec().isString()) {
                        for (i2 = 0; i2 < chk._len; ++i2) {
                            cres.addNum(AstEq.this.str_op(chk.atStr(bStr, i2), Double.isNaN(d2) ? null : new BufferedString(String.valueOf(d2))));
                        }
                        continue;
                    }
                    if (!chk.vec().isNumeric()) {
                        cres.addZeros(chk._len);
                        continue;
                    }
                    for (i2 = 0; i2 < chk._len; ++i2) {
                        cres.addNum(AstEq.this.op(chk.atd(i2), d2));
                    }
                }
            }
        }.doAll(fr.numCols(), (byte)3, fr)).outputFrame());
    }

    @Override
    public boolean categoricalOK() {
        return true;
    }

    @Override
    public double str_op(BufferedString l2, BufferedString r2) {
        if (StringUtils.isNullOrEmpty(l2)) {
            return StringUtils.isNullOrEmpty(r2) ? 1.0 : 0.0;
        }
        return l2.equals(r2) ? 1.0 : 0.0;
    }
}

