/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.mungers;

import water.H2O;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.rapids.Val;
import water.rapids.ast.AstBuiltin;
import water.rapids.vals.ValFrame;
import water.rapids.vals.ValNum;

public class AstIsNa
extends AstBuiltin<AstIsNa> {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public String str() {
        return "is.na";
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public Val exec(Val ... args) {
        Val val = args[1];
        switch (val.type()) {
            case 1: {
                return new ValNum(this.op(val.getNum()));
            }
            case 5: {
                Frame fr = val.getFrame();
                String[] newNames = new String[fr.numCols()];
                for (int i2 = 0; i2 < newNames.length; ++i2) {
                    newNames[i2] = "isNA(" + fr.name(i2) + ")";
                }
                return new ValFrame(((MRTask)new MRTask(){

                    @Override
                    public void map(Chunk[] cs, NewChunk[] ncs) {
                        for (int col = 0; col < cs.length; ++col) {
                            Chunk c2 = cs[col];
                            NewChunk nc = ncs[col];
                            for (int i2 = 0; i2 < c2._len; ++i2) {
                                nc.addNum(c2.isNA(i2) ? 1.0 : 0.0);
                            }
                        }
                    }
                }.doAll(fr.numCols(), (byte)3, fr)).outputFrame(newNames, null));
            }
            case 3: {
                return new ValNum(val.getStr() == null ? 1.0 : 0.0);
            }
        }
        throw H2O.unimpl("is.na unimpl: " + val.getClass());
    }

    double op(double d2) {
        return Double.isNaN(d2) ? 1.0 : 0.0;
    }
}

