/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.math;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import water.rapids.ast.prims.operators.AstBinOp;

public class AstSignif
extends AstBinOp {
    @Override
    public String str() {
        return "signif";
    }

    @Override
    public double op(double x2, double digits) {
        if (Double.isNaN(x2)) {
            return x2;
        }
        if (digits < 1.0) {
            digits = 1.0;
        }
        if ((double)((int)digits) != digits) {
            digits = Math.round(digits);
        }
        BigDecimal bd = new BigDecimal(x2);
        bd = bd.round(new MathContext((int)digits, RoundingMode.HALF_EVEN));
        return bd.doubleValue();
    }
}

