/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.advmath;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValNum;
import water.util.ArrayUtils;
import water.util.MRUtils;

public class AstMode
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary"};
    }

    @Override
    public String str() {
        return "mode";
    }

    @Override
    public int nargs() {
        return 2;
    }

    @Override
    public ValNum apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        if (fr.numCols() != 1 || !fr.anyVec().isCategorical()) {
            throw new IllegalArgumentException("mode only works on a single categorical column");
        }
        return new ValNum(AstMode.mode(fr.anyVec()));
    }

    public static int mode(Vec v2) {
        if (v2.isNumeric()) {
            MRUtils.Dist t2 = (MRUtils.Dist)new MRUtils.Dist().doAll(v2);
            int mode = ArrayUtils.maxIndex(t2.dist());
            return (int)t2.keys()[mode];
        }
        double[] dist = ((MRUtils.ClassDist)new MRUtils.ClassDist(v2).doAll(v2)).dist();
        return ArrayUtils.maxIndex(dist);
    }
}

