/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.advmath;

import sun.misc.Unsafe;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.nbhm.UtilUnsafe;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNum;
import water.rapids.ast.params.AstNumList;
import water.rapids.ast.params.AstStr;
import water.rapids.ast.prims.advmath.AstVariance;
import water.rapids.ast.prims.reducers.AstMad;
import water.rapids.vals.ValFrame;
import water.util.ArrayUtils;

public class AstHist
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "breaks"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "hist";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        double h2;
        HistTask t2;
        Frame f2 = stk.track(asts[1].exec(env)).getFrame();
        if (f2.numCols() != 1) {
            throw new IllegalArgumentException("Hist only applies to single numeric columns.");
        }
        Vec vec = f2.anyVec();
        if (!vec.isNumeric()) {
            throw new IllegalArgumentException("Hist only applies to single numeric columns.");
        }
        if (vec.isConst()) {
            throw new IllegalArgumentException("Hist does not apply to constant numeric columns.");
        }
        AstRoot a2 = asts[2];
        String algo = null;
        int numBreaks = -1;
        double[] breaks = null;
        if (a2 instanceof AstStr) {
            algo = a2.str().toLowerCase();
        } else if (a2 instanceof AstNumList) {
            breaks = ((AstNumList)a2).expand();
        } else if (a2 instanceof AstNum) {
            numBreaks = (int)a2.exec(env).getNum();
        }
        double x1 = vec.max();
        double x0 = vec.min();
        if (breaks != null) {
            t2 = (HistTask)new HistTask(breaks, -1.0, -1.0).doAll(vec);
        } else if (algo != null) {
            switch (algo) {
                case "sturges": {
                    numBreaks = AstHist.sturges(vec);
                    h2 = (x1 - x0) / (double)numBreaks;
                    break;
                }
                case "rice": {
                    numBreaks = AstHist.rice(vec);
                    h2 = (x1 - x0) / (double)numBreaks;
                    break;
                }
                case "sqrt": {
                    numBreaks = AstHist.sqrt(vec);
                    h2 = (x1 - x0) / (double)numBreaks;
                    break;
                }
                case "doane": {
                    numBreaks = AstHist.doane(vec);
                    h2 = (x1 - x0) / (double)numBreaks;
                    break;
                }
                case "scott": {
                    h2 = AstHist.scotts_h(vec);
                    numBreaks = AstHist.scott(vec, h2);
                    break;
                }
                case "fd": {
                    h2 = AstHist.fds_h(vec);
                    numBreaks = AstHist.fd(vec, h2);
                    break;
                }
                default: {
                    numBreaks = AstHist.sturges(vec);
                    h2 = (x1 - x0) / (double)numBreaks;
                }
            }
            t2 = (HistTask)new HistTask(this.computeCuts(vec, numBreaks), h2, x0).doAll(vec);
        } else {
            h2 = (x1 - x0) / (double)numBreaks;
            t2 = (HistTask)new HistTask(this.computeCuts(vec, numBreaks), h2, x0).doAll(vec);
        }
        final double[] brks = t2._breaks;
        final long[] cnts = t2._counts;
        final double[] mids_true = t2._mids;
        final double[] mids = new double[t2._breaks.length - 1];
        for (int i2 = 1; i2 < brks.length; ++i2) {
            mids[i2 - 1] = 0.5 * (t2._breaks[i2 - 1] + t2._breaks[i2]);
        }
        Vec layoutVec = Vec.makeZero(brks.length);
        Frame fr2 = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] c2, NewChunk[] nc) {
                int start = (int)c2[0].start();
                for (int i2 = 0; i2 < c2[0]._len; ++i2) {
                    nc[0].addNum(brks[i2 + start]);
                    if (i2 == 0) {
                        nc[1].addNA();
                        nc[2].addNA();
                        nc[3].addNA();
                        continue;
                    }
                    nc[1].addNum(cnts[i2 - 1 + start]);
                    nc[2].addNum(mids_true[i2 - 1 + start]);
                    nc[3].addNum(mids[i2 - 1 + start]);
                }
            }
        }.doAll(4, (byte)3, new Frame(layoutVec))).outputFrame(null, new String[]{"breaks", "counts", "mids_true", "mids"}, null);
        layoutVec.remove();
        return new ValFrame(fr2);
    }

    public static int sturges(Vec v2) {
        return (int)Math.ceil(1.0 + AstHist.log2(v2.length()));
    }

    public static int rice(Vec v2) {
        return (int)Math.ceil(2.0 * Math.pow(v2.length(), 0.3333333333333333));
    }

    public static int sqrt(Vec v2) {
        return (int)Math.sqrt(v2.length());
    }

    public static int doane(Vec v2) {
        return (int)(1.0 + AstHist.log2(v2.length()) + AstHist.log2(1.0 + Math.abs(AstHist.third_moment(v2)) / AstHist.sigma_g1(v2)));
    }

    public static int scott(Vec v2, double h2) {
        return (int)Math.ceil((v2.max() - v2.min()) / h2);
    }

    public static int fd(Vec v2, double h2) {
        return (int)Math.ceil((v2.max() - v2.min()) / h2);
    }

    public static double fds_h(Vec v2) {
        return 2.0 * AstMad.mad(new Frame(v2), null, 1.4826) * Math.pow(v2.length(), -0.3333333333333333);
    }

    public static double scotts_h(Vec v2) {
        return 3.5 * Math.sqrt(AstVariance.getVar(v2)) / Math.pow(v2.length(), 0.3333333333333333);
    }

    public static double log2(double numerator) {
        return Math.log(numerator) / Math.log(2.0) + 1.0E-10;
    }

    public static double sigma_g1(Vec v2) {
        return Math.sqrt(6L * (v2.length() - 2L) / ((v2.length() + 1L) * (v2.length() + 3L)));
    }

    public static double third_moment(Vec v2) {
        double mean = v2.mean();
        ThirdMomTask t2 = (ThirdMomTask)new ThirdMomTask(mean).doAll(v2);
        double m22 = t2._ss / (double)v2.length();
        double m32 = t2._sc / (double)v2.length();
        return m32 / Math.pow(m22, 1.5);
    }

    public static double fourth_moment(Vec v2) {
        double mean = v2.mean();
        FourthMomTask t2 = (FourthMomTask)new FourthMomTask(mean).doAll(v2);
        double m22 = t2._ss / (double)v2.length();
        double m4 = t2._sc / (double)v2.length();
        return m4 / Math.pow(m22, 2.0);
    }

    public double[] computeCuts(Vec v2, int numBreaks) {
        if (numBreaks <= 0) {
            throw new IllegalArgumentException("breaks must be a positive number");
        }
        double min2 = v2.min();
        double w2 = (v2.max() - min2) / (double)numBreaks;
        double[] res = new double[numBreaks];
        for (int i2 = 0; i2 < numBreaks; ++i2) {
            res[i2] = min2 + w2 * (double)(i2 + 1);
        }
        return res;
    }

    public static class HistTask
    extends MRTask<HistTask> {
        private final double _h;
        private final double _x0;
        private final double[] _min;
        private final double[] _max;
        private static final Unsafe U = UtilUnsafe.getUnsafe();
        private static final int _dB = U.arrayBaseOffset(double[].class);
        private static final int _dS = U.arrayIndexScale(double[].class);
        private static final int _8B = U.arrayBaseOffset(long[].class);
        private static final int _8S = U.arrayIndexScale(long[].class);
        private final double[] _breaks;
        private final long[] _counts;
        private final double[] _mids;

        private static long doubleRawIdx(int i2) {
            return _dB + _dS * i2;
        }

        private static long longRawIdx(int i2) {
            return _8B + _8S * i2;
        }

        HistTask(double[] cuts, double h2, double x0) {
            this._breaks = cuts;
            this._min = new double[this._breaks.length - 1];
            this._max = new double[this._breaks.length - 1];
            this._counts = new long[this._breaks.length - 1];
            this._mids = new double[this._breaks.length - 1];
            this._h = h2;
            this._x0 = x0;
        }

        @Override
        public void map(Chunk c2) {
            for (int i2 = 0; i2 < c2._len; ++i2) {
                int x2;
                if (c2.isNA(i2)) continue;
                double r2 = c2.atd(i2);
                if (this._h == -1.0) {
                    for (x2 = 1; x2 < this._counts.length && !(r2 <= this._breaks[x2]); ++x2) {
                    }
                    --x2;
                } else {
                    x2 = Math.min(this._counts.length - 1, (int)Math.floor((r2 - this._x0) / this._h));
                }
                this.bumpCount(x2);
                this.setMinMax(Double.doubleToRawLongBits(r2), x2);
            }
        }

        @Override
        public void reduce(HistTask t2) {
            if (this._counts != t2._counts) {
                ArrayUtils.add(this._counts, t2._counts);
            }
            for (int i2 = 0; i2 < this._mids.length; ++i2) {
                this._min[i2] = t2._min[i2] < this._min[i2] ? t2._min[i2] : this._min[i2];
                this._max[i2] = t2._max[i2] > this._max[i2] ? t2._max[i2] : this._max[i2];
            }
        }

        @Override
        public void postGlobal() {
            for (int i2 = 0; i2 < this._mids.length; ++i2) {
                this._mids[i2] = 0.5 * (this._max[i2] + this._min[i2]);
            }
        }

        private void bumpCount(int x2) {
            long o2 = this._counts[x2];
            while (!U.compareAndSwapLong(this._counts, HistTask.longRawIdx(x2), o2, o2 + 1L)) {
                o2 = this._counts[x2];
            }
        }

        private void setMinMax(long v2, int x2) {
            double o2 = this._min[x2];
            double vv = Double.longBitsToDouble(v2);
            while (vv < o2 && U.compareAndSwapLong(this._min, HistTask.doubleRawIdx(x2), Double.doubleToRawLongBits(o2), v2)) {
                o2 = this._min[x2];
            }
            this.setMax(v2, x2);
        }

        private void setMax(long v2, int x2) {
            double o2 = this._max[x2];
            double vv = Double.longBitsToDouble(v2);
            while (vv > o2 && U.compareAndSwapLong(this._min, HistTask.doubleRawIdx(x2), Double.doubleToRawLongBits(o2), v2)) {
                o2 = this._max[x2];
            }
        }
    }

    public static class FourthMomTask
    extends MRTask<FourthMomTask> {
        double _ss;
        double _sc;
        final double _mean;

        FourthMomTask(double mean) {
            this._mean = mean;
        }

        @Override
        public void setupLocal() {
            this._ss = 0.0;
            this._sc = 0.0;
        }

        @Override
        public void map(Chunk c2) {
            for (int i2 = 0; i2 < c2._len; ++i2) {
                if (c2.isNA(i2)) continue;
                double d2 = c2.atd(i2) - this._mean;
                double d22 = d2 * d2;
                this._ss += d22;
                this._sc += d22 * d2 * d2;
            }
        }

        @Override
        public void reduce(FourthMomTask t2) {
            this._ss += t2._ss;
            this._sc += t2._sc;
        }
    }

    public static class ThirdMomTask
    extends MRTask<ThirdMomTask> {
        double _ss;
        double _sc;
        final double _mean;

        ThirdMomTask(double mean) {
            this._mean = mean;
        }

        @Override
        public void setupLocal() {
            this._ss = 0.0;
            this._sc = 0.0;
        }

        @Override
        public void map(Chunk c2) {
            for (int i2 = 0; i2 < c2._len; ++i2) {
                if (c2.isNA(i2)) continue;
                double d2 = c2.atd(i2) - this._mean;
                double d22 = d2 * d2;
                this._ss += d22;
                this._sc += d22 * d2;
            }
        }

        @Override
        public void reduce(ThirdMomTask t2) {
            this._ss += t2._ss;
            this._sc += t2._sc;
        }
    }
}

