/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.params;

import java.util.ArrayList;
import java.util.Arrays;
import water.rapids.Env;
import water.rapids.Val;
import water.rapids.ast.AstParameter;
import water.rapids.vals.ValStrs;
import water.util.ArrayUtils;

public class AstStrList
extends AstParameter {
    public String[] _strs;

    public AstStrList() {
        this._strs = null;
    }

    public AstStrList(ArrayList<String> strs) {
        this._strs = strs.toArray(new String[strs.size()]);
    }

    @Override
    public Val exec(Env env) {
        return new ValStrs(this._strs);
    }

    @Override
    public String str() {
        return Arrays.toString(this._strs);
    }

    @Override
    public int[] columns(String[] names) {
        int[] idxs = new int[this._strs.length];
        for (int i2 = 0; i2 < this._strs.length; ++i2) {
            idxs[i2] = ArrayUtils.find(names, this._strs[i2]);
            int idx = idxs[i2];
            if (idx != -1) continue;
            throw new IllegalArgumentException("Column " + this._strs[i2] + " not found");
        }
        return idxs;
    }
}

