/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.util.Arrays;
import water.DKV;
import water.DTask;
import water.Freezable;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Key;
import water.MemoryManager;
import water.Value;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.SplitByMSBLocal;
import water.util.ArrayUtils;

class SingleThreadRadixOrder
extends DTask<SingleThreadRadixOrder> {
    private final Frame _fr;
    private final int _MSBvalue;
    private final int _keySize;
    private final int _batchSize;
    private final boolean _isLeft;
    private transient long[][] _o;
    private transient byte[][] _x;
    private transient long[][] _otmp;
    private transient byte[][] _xtmp;
    private transient long[][] counts;
    private transient byte[] keytmp;

    SingleThreadRadixOrder(Frame fr, boolean isLeft, int batchSize, int keySize, int MSBvalue) {
        this._fr = fr;
        this._isLeft = isLeft;
        this._batchSize = batchSize;
        this._keySize = keySize;
        this._MSBvalue = MSBvalue;
    }

    @Override
    public void compute2() {
        int b2;
        Key k2;
        this.keytmp = MemoryManager.malloc1(this._keySize);
        this.counts = new long[this._keySize][256];
        SplitByMSBLocal.MSBNodeHeader[] MSBnodeHeader = new SplitByMSBLocal.MSBNodeHeader[H2O.CLOUD.size()];
        long numRows = 0L;
        for (int n2 = 0; n2 < H2O.CLOUD.size(); ++n2) {
            k2 = SplitByMSBLocal.getMSBNodeHeaderKey(this._isLeft, this._MSBvalue, n2);
            MSBnodeHeader[n2] = (SplitByMSBLocal.MSBNodeHeader)DKV.getGet(k2);
            if (MSBnodeHeader[n2] == null) continue;
            DKV.remove(k2);
            numRows += (long)ArrayUtils.sum(MSBnodeHeader[n2]._MSBnodeChunkCounts);
        }
        if (numRows == 0L) {
            this.tryComplete();
            return;
        }
        int nbatch = (int)((numRows - 1L) / (long)this._batchSize + 1L);
        int lastSize = (int)(numRows - (long)((nbatch - 1) * this._batchSize));
        this._o = new long[nbatch][];
        this._x = new byte[nbatch][];
        for (b2 = 0; b2 < nbatch - 1; ++b2) {
            this._o[b2] = MemoryManager.malloc8(this._batchSize);
            this._x[b2] = MemoryManager.malloc1(this._batchSize * this._keySize);
        }
        this._o[b2] = MemoryManager.malloc8(lastSize);
        this._x[b2] = MemoryManager.malloc1(lastSize * this._keySize);
        SplitByMSBLocal.OXbatch[] ox = new SplitByMSBLocal.OXbatch[H2O.CLOUD.size()];
        int[] oxBatchNum = new int[H2O.CLOUD.size()];
        for (int node = 0; node < H2O.CLOUD.size(); ++node) {
            k2 = SplitByMSBLocal.getNodeOXbatchKey(this._isLeft, this._MSBvalue, node, 0);
            ox[node] = (SplitByMSBLocal.OXbatch)DKV.getGet(k2);
            DKV.remove(k2);
        }
        int[] oxOffset = MemoryManager.malloc4(H2O.CLOUD.size());
        int[] oxChunkIdx = MemoryManager.malloc4(H2O.CLOUD.size());
        int targetBatch = 0;
        int targetOffset = 0;
        int targetBatchRemaining = this._batchSize;
        Vec vec = this._fr.anyVec();
        assert (vec != null);
        for (int c2 = 0; c2 < vec.nChunks(); ++c2) {
            int fromNode = vec.chunkKey(c2).home_node().index();
            if (MSBnodeHeader[fromNode] == null) continue;
            int n3 = fromNode;
            int n4 = oxChunkIdx[n3];
            oxChunkIdx[n3] = n4 + 1;
            int numRowsToCopy = MSBnodeHeader[fromNode]._MSBnodeChunkCounts[n4];
            int sourceBatchRemaining = this._batchSize - oxOffset[fromNode];
            while (numRowsToCopy > 0) {
                int thisCopy = Math.min(numRowsToCopy, Math.min(sourceBatchRemaining, targetBatchRemaining));
                System.arraycopy(ox[fromNode]._o, oxOffset[fromNode], this._o[targetBatch], targetOffset, thisCopy);
                System.arraycopy(ox[fromNode]._x, oxOffset[fromNode] * this._keySize, this._x[targetBatch], targetOffset * this._keySize, thisCopy * this._keySize);
                numRowsToCopy -= thisCopy;
                int n5 = fromNode;
                oxOffset[n5] = oxOffset[n5] + thisCopy;
                targetOffset += thisCopy;
                targetBatchRemaining -= thisCopy;
                if ((sourceBatchRemaining -= thisCopy) == 0) {
                    int n6 = fromNode;
                    int n7 = oxBatchNum[n6] + 1;
                    oxBatchNum[n6] = n7;
                    k2 = SplitByMSBLocal.getNodeOXbatchKey(this._isLeft, this._MSBvalue, fromNode, n7);
                    assert (k2.home());
                    ox[fromNode] = (SplitByMSBLocal.OXbatch)DKV.getGet(k2);
                    DKV.remove(k2);
                    if (ox[fromNode] == null) {
                        int numNonZero = 0;
                        for (int tmp : MSBnodeHeader[fromNode]._MSBnodeChunkCounts) {
                            if (tmp <= 0) continue;
                            ++numNonZero;
                        }
                        assert (oxBatchNum[fromNode] == numNonZero);
                        assert (ArrayUtils.sum(MSBnodeHeader[fromNode]._MSBnodeChunkCounts) % this._batchSize == 0);
                    }
                    oxOffset[fromNode] = 0;
                    sourceBatchRemaining = this._batchSize;
                }
                if (targetBatchRemaining != 0) continue;
                ++targetBatch;
                targetOffset = 0;
                targetBatchRemaining = this._batchSize;
            }
        }
        this._xtmp = new byte[this._x.length][];
        this._otmp = new long[this._o.length][];
        assert (this._x.length == this._o.length);
        for (int i2 = 0; i2 < this._x.length; ++i2) {
            this._xtmp[i2] = Arrays.copyOf(this._x[i2], this._x[i2].length);
            this._otmp[i2] = Arrays.copyOf(this._o[i2], this._o[i2].length);
        }
        assert (this._o != null);
        assert (numRows > 0L);
        this.run(0L, numRows, this._keySize - 1);
        OXHeader msbh = new OXHeader(this._o.length, numRows, this._batchSize);
        Futures fs = new Futures();
        DKV.put(SingleThreadRadixOrder.getSortedOXHeaderKey(this._isLeft, this._MSBvalue), msbh, fs, true);
        assert (this._o.length == this._x.length);
        for (b2 = 0; b2 < this._o.length; ++b2) {
            SplitByMSBLocal.OXbatch tmp = new SplitByMSBLocal.OXbatch(this._o[b2], this._x[b2]);
            Value v2 = new Value(SplitByMSBLocal.getSortedOXbatchKey(this._isLeft, this._MSBvalue, b2), (Freezable)tmp);
            DKV.put(v2._key, v2, fs, true);
            v2.freeMem();
        }
        fs.blockForPending();
        this.tryComplete();
    }

    static Key getSortedOXHeaderKey(boolean isLeft, int MSBvalue) {
        return Key.make("__radix_order__SortedOXHeader_MSB" + MSBvalue + (isLeft ? "_LEFT" : "_RIGHT"));
    }

    private int keycmp(byte[] x2, int xi, byte[] y2, int yi) {
        xi *= this._keySize;
        yi *= this._keySize;
        for (int len = this._keySize; len > 1 && x2[xi] == y2[yi]; --len) {
            ++xi;
            ++yi;
        }
        return (x2[xi] & 0xFF) - (y2[yi] & 0xFF);
    }

    public void insert(long start, int len) {
        long[] _obatch;
        byte[] _xbatch;
        int batch0 = (int)(start / (long)this._batchSize);
        int batch1 = (int)((start + (long)len - 1L) / (long)this._batchSize);
        long origstart = start;
        int len0 = 0;
        if (batch1 != batch0) {
            assert (batch0 == batch1 - 1);
            len0 = this._batchSize - (int)(start % (long)this._batchSize);
            _xbatch = new byte[len * this._keySize];
            System.arraycopy(this._x[batch0], (int)(start % (long)this._batchSize * (long)this._keySize), _xbatch, 0, len0 * this._keySize);
            System.arraycopy(this._x[batch1], 0, _xbatch, len0 * this._keySize, (len - len0) * this._keySize);
            _obatch = new long[len];
            System.arraycopy(this._o[batch0], (int)(start % (long)this._batchSize), _obatch, 0, len0);
            System.arraycopy(this._o[batch1], 0, _obatch, len0, len - len0);
            start = 0L;
        } else {
            _xbatch = this._x[batch0];
            _obatch = this._o[batch0];
        }
        int offset = (int)(start % (long)this._batchSize);
        for (int i2 = 1; i2 < len; ++i2) {
            int cmp = this.keycmp(_xbatch, offset + i2, _xbatch, offset + i2 - 1);
            if (cmp >= 0) continue;
            System.arraycopy(_xbatch, (offset + i2) * this._keySize, this.keytmp, 0, this._keySize);
            int j2 = i2 - 1;
            long otmp = _obatch[offset + i2];
            do {
                System.arraycopy(_xbatch, (offset + j2) * this._keySize, _xbatch, (offset + j2 + 1) * this._keySize, this._keySize);
                _obatch[offset + j2 + 1] = _obatch[offset + j2];
            } while (--j2 >= 0 && this.keycmp(this.keytmp, 0, _xbatch, offset + j2) < 0);
            System.arraycopy(this.keytmp, 0, _xbatch, (offset + j2 + 1) * this._keySize, this._keySize);
            _obatch[offset + j2 + 1] = otmp;
        }
        if (batch1 != batch0) {
            System.arraycopy(_xbatch, 0, this._x[batch0], (int)(origstart % (long)this._batchSize) * this._keySize, len0 * this._keySize);
            System.arraycopy(_xbatch, len0 * this._keySize, this._x[batch1], 0, (len - len0) * this._keySize);
            System.arraycopy(_obatch, 0, this._o[batch0], (int)(origstart % (long)this._batchSize), len0);
            System.arraycopy(_obatch, len0, this._o[batch1], 0, len - len0);
        }
    }

    public void run(long start, long len, int Byte2) {
        if (len < 200L) {
            this.insert(start, (int)len);
            return;
        }
        int batch0 = (int)(start / (long)this._batchSize);
        int batch1 = (int)((start + len - 1L) / (long)this._batchSize);
        long[] thisHist = this.counts[Byte2];
        int idx = (int)(start % (long)this._batchSize) * this._keySize + this._keySize - Byte2 - 1;
        int bin = -1;
        int thisLen = (int)Math.min(len, (long)this._batchSize - start % (long)this._batchSize);
        int nbatch = batch1 - batch0 + 1;
        for (int b2 = 0; b2 < nbatch; ++b2) {
            byte[] _xbatch = this._x[batch0 + b2];
            for (int i2 = 0; i2 < thisLen; ++i2) {
                int n2 = bin = 0xFF & _xbatch[idx];
                thisHist[n2] = thisHist[n2] + 1L;
                idx += this._keySize;
            }
            idx = this._keySize - Byte2 - 1;
            thisLen = b2 == nbatch - 2 ? (int)((start + len) % (long)this._batchSize) : this._batchSize;
        }
        if (thisHist[bin] == len) {
            thisHist[bin] = 0L;
            if (Byte2 != 0) {
                this.run(start, len, Byte2 - 1);
            }
            return;
        }
        long rollSum = 0L;
        for (int c2 = 0; c2 < 256 && rollSum != len; ++c2) {
            long tmp = thisHist[c2];
            if (tmp == 0L) continue;
            thisHist[c2] = rollSum;
            rollSum += tmp;
        }
        int oidx = (int)(start % (long)this._batchSize);
        int xidx = oidx * this._keySize + this._keySize - Byte2 - 1;
        thisLen = (int)Math.min(len, (long)this._batchSize - start % (long)this._batchSize);
        for (int b3 = 0; b3 < nbatch; ++b3) {
            long[] _obatch = this._o[batch0 + b3];
            byte[] _xbatch = this._x[batch0 + b3];
            for (int i3 = 0; i3 < thisLen; ++i3) {
                long target;
                int n3 = 0xFF & _xbatch[xidx];
                thisHist[n3] = thisHist[n3] + 1L;
                this._otmp[(int)(target / (long)this._batchSize)][(int)(target % (long)this._batchSize)] = _obatch[oidx + i3];
                System.arraycopy(_xbatch, (oidx + i3) * this._keySize, this._xtmp[(int)(target / (long)this._batchSize)], (int)(target % (long)this._batchSize) * this._keySize, this._keySize);
                xidx += this._keySize;
            }
            xidx = this._keySize - Byte2 - 1;
            oidx = 0;
            thisLen = b3 == nbatch - 2 ? (int)((start + len) % (long)this._batchSize) : this._batchSize;
        }
        SingleThreadRadixOrder.runCopy(start, len, this._keySize, this._batchSize, this._otmp, this._xtmp, this._o, this._x);
        long itmp = 0L;
        for (int i4 = 0; i4 < 256; ++i4) {
            if (thisHist[i4] == 0L) continue;
            long thisgrpn = thisHist[i4] - itmp;
            if (thisgrpn != 1L && Byte2 != 0) {
                this.run(start + itmp, thisgrpn, Byte2 - 1);
            }
            itmp = thisHist[i4];
            thisHist[i4] = 0L;
        }
    }

    private static void runCopy(long start, long len, int keySize, int batchSize, long[][] otmp, byte[][] xtmp, long[][] o2, byte[][] x2) {
        long numRowsToCopy = len;
        int sourceBatch = 0;
        int sourceOffset = 0;
        int targetBatch = (int)(start / (long)batchSize);
        int targetOffset = (int)(start % (long)batchSize);
        int targetBatchRemaining = batchSize - targetOffset;
        int sourceBatchRemaining = batchSize - sourceOffset;
        while (numRowsToCopy > 0L) {
            int thisCopy = (int)Math.min(numRowsToCopy, (long)Math.min(sourceBatchRemaining, targetBatchRemaining));
            System.arraycopy(otmp[sourceBatch], sourceOffset, o2[targetBatch], targetOffset, thisCopy);
            System.arraycopy(xtmp[sourceBatch], sourceOffset * keySize, x2[targetBatch], targetOffset * keySize, thisCopy * keySize);
            numRowsToCopy -= (long)thisCopy;
            sourceOffset += thisCopy;
            targetOffset += thisCopy;
            targetBatchRemaining -= thisCopy;
            if ((sourceBatchRemaining -= thisCopy) == 0) {
                ++sourceBatch;
                sourceOffset = 0;
                sourceBatchRemaining = batchSize;
            }
            if (targetBatchRemaining != 0) continue;
            ++targetBatch;
            targetOffset = 0;
            targetBatchRemaining = batchSize;
        }
    }

    static class OXHeader
    extends Iced<OXHeader> {
        final int _nBatch;
        final long _numRows;
        final int _batchSize;

        OXHeader(int batches, long numRows, int batchSize) {
            this._nBatch = batches;
            this._numRows = numRows;
            this._batchSize = batchSize;
        }
    }
}

