/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import water.H2O;
import water.Paxos;
import water.persist.security.HdfsDelegationTokenRefresher;
import water.util.Log;

public class S3ATokenRefresherFactory {
    private static final String H2O_DYNAMIC_AUTH_S3A_TOKEN_REFRESHER_ENABLED = "h2o.auth.dynamicS3ATokenRefresher.enabled";
    private final Configuration conf;
    private final String tmpDir;
    private final Set<String> bucketsWithDelegationToken = Collections.synchronizedSet(new HashSet());
    private final Object GENERATION_LOCK = new Object();

    S3ATokenRefresherFactory(Configuration conf, String tmpDir) {
        this.conf = conf;
        this.tmpDir = tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startDelegationTokenRefresher(Path p2) throws IOException {
        if (Paxos._cloudLocked && H2O.CLOUD.leader() != H2O.SELF) {
            return false;
        }
        URI uri = p2.toUri();
        if (!"s3a".equalsIgnoreCase(uri.getScheme())) {
            if (Log.isLoggingFor(4)) {
                Log.debug("Delegation token refresh is only needed for s3a, requested URI: " + uri);
            }
            return false;
        }
        Paxos.lockCloud("S3A Token Refresh");
        if (H2O.CLOUD.leader() != H2O.SELF) {
            return true;
        }
        Object object = this.GENERATION_LOCK;
        synchronized (object) {
            if (this.isInBucketWithAlreadyExistingToken(uri)) {
                return true;
            }
            String bucketIdentifier = p2.toUri().getHost();
            HdfsDelegationTokenRefresher.setup(this.conf, this.tmpDir, p2.toString());
            Log.debug("Bucket added to bucketsWithDelegationToken: '" + bucketIdentifier + "'");
            this.bucketsWithDelegationToken.add(bucketIdentifier);
        }
        return true;
    }

    private boolean isInBucketWithAlreadyExistingToken(URI uri) {
        return this.bucketsWithDelegationToken.contains(uri.getHost());
    }

    public static S3ATokenRefresherFactory make(Configuration conf, String tmpDir) {
        if (conf == null || !conf.getBoolean(H2O_DYNAMIC_AUTH_S3A_TOKEN_REFRESHER_ENABLED, false)) {
            return null;
        }
        return new S3ATokenRefresherFactory(conf, tmpDir);
    }
}

