/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import ai.h2o.com.amazonaws.AmazonClientException;
import ai.h2o.com.amazonaws.AmazonServiceException;
import ai.h2o.com.amazonaws.ClientConfiguration;
import ai.h2o.com.amazonaws.HttpMethod;
import ai.h2o.com.amazonaws.Protocol;
import ai.h2o.com.amazonaws.auth.AWSCredentials;
import ai.h2o.com.amazonaws.auth.AWSCredentialsProvider;
import ai.h2o.com.amazonaws.auth.AWSCredentialsProviderChain;
import ai.h2o.com.amazonaws.auth.BasicAWSCredentials;
import ai.h2o.com.amazonaws.auth.BasicSessionCredentials;
import ai.h2o.com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import ai.h2o.com.amazonaws.auth.PropertiesCredentials;
import ai.h2o.com.amazonaws.regions.RegionUtils;
import ai.h2o.com.amazonaws.services.s3.AmazonS3;
import ai.h2o.com.amazonaws.services.s3.AmazonS3Client;
import ai.h2o.com.amazonaws.services.s3.S3ClientOptions;
import ai.h2o.com.amazonaws.services.s3.model.Bucket;
import ai.h2o.com.amazonaws.services.s3.model.GetObjectRequest;
import ai.h2o.com.amazonaws.services.s3.model.ObjectListing;
import ai.h2o.com.amazonaws.services.s3.model.ObjectMetadata;
import ai.h2o.com.amazonaws.services.s3.model.PutObjectRequest;
import ai.h2o.com.amazonaws.services.s3.model.PutObjectResult;
import ai.h2o.com.amazonaws.services.s3.model.S3Object;
import ai.h2o.com.amazonaws.services.s3.model.S3ObjectInputStream;
import ai.h2o.com.amazonaws.services.s3.model.S3ObjectSummary;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import water.DKV;
import water.H2O;
import water.Key;
import water.MemoryManager;
import water.Value;
import water.fvec.FileVec;
import water.fvec.S3FileVec;
import water.persist.IcedS3Credentials;
import water.persist.Persist;
import water.persist.S3ClientFactory;
import water.util.ArrayUtils;
import water.util.ByteStreams;
import water.util.Log;
import water.util.ReflectionUtils;
import water.util.StringUtils;

public final class PersistS3
extends Persist {
    private static final Logger LOG = Logger.getLogger(PersistS3.class);
    private static final String KEY_PREFIX = "s3://";
    private static final int KEY_PREFIX_LEN = "s3://".length();
    private static final Object _lock = new Object();
    private static volatile AmazonS3 _s3;
    public static final String S3_SOCKET_TIMEOUT_PROP = "sys.ai.h2o.persist.s3.socketTimeout";
    public static final String S3_CONNECTION_TIMEOUT_PROP = "sys.ai.h2o.persist.s3.connectionTimeout";
    public static final String S3_MAX_ERROR_RETRY_PROP = "sys.ai.h2o.persist.s3.maxErrorRetry";
    public static final String S3_MAX_HTTP_CONNECTIONS_PROP = "sys.ai.h2o.persist.s3.maxHttpConnections";
    public static final String S3_FORCE_HTTP = "sys.ai.h2o.persist.s3.force.http";
    public static final String S3_END_POINT = "sys.ai.h2o.persist.s3.endPoint";
    public static final String S3_REGION = "sys.ai.h2o.persist.s3.region";
    public static final String S3_ENABLE_PATH_STYLE = "sys.ai.h2o.persist.s3.enable.path.style";
    public static final String S3_CUSTOM_CREDENTIALS_PROVIDER_CLASS = "sys.ai.h2o.persist.s3.customCredentialsProviderClass";
    public static final String S3_CLIENT_FACTORY_CLASS = "sys.ai.h2o.persist.s3.clientFactoryClass";
    public static final String S3_CLIENT_FACTORY_CLASS_DEFAULT = "water.persist.S3AClientFactory";
    static volatile Cache _bucketCache;
    static volatile HashMap<String, KeyCache> _keyCaches;

    static void setClient(AmazonS3 s3) {
        _s3 = s3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AmazonS3 getClient() {
        if (_s3 == null) {
            String factoryClassName = System.getProperty(S3_CLIENT_FACTORY_CLASS);
            if (H2O.ARGS.configure_s3_using_s3a) {
                if (factoryClassName == null) {
                    factoryClassName = S3_CLIENT_FACTORY_CLASS_DEFAULT;
                } else {
                    Log.warn("Option configure_s3_using_s3a was given alongside System property S3_CLIENT_FACTORY_CLASS=" + factoryClassName + ". The system property will take precedence.");
                }
            }
            Object object = _lock;
            synchronized (object) {
                if (_s3 == null) {
                    if (StringUtils.isNullOrEmpty(factoryClassName)) {
                        _s3 = PersistS3.makeDefaultClient();
                    } else {
                        try {
                            S3ClientFactory factory = ReflectionUtils.newInstance(factoryClassName, S3ClientFactory.class);
                            _s3 = (AmazonS3)factory.newClientInstance();
                        }
                        catch (Exception e2) {
                            throw new RuntimeException("Unable to instantiate S3 client factory for class " + factoryClassName + ".", e2);
                        }
                    }
                    assert (_s3 != null);
                }
            }
        }
        return _s3;
    }

    static AmazonS3 makeDefaultClient() {
        try {
            H2OAWSCredentialsProviderChain c2 = new H2OAWSCredentialsProviderChain();
            c2.setReuseLastProvider(false);
            ClientConfiguration cc = PersistS3.s3ClientCfg();
            return PersistS3.configureClient(new AmazonS3Client(c2, cc));
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            String msg = e2.getMessage() + "\nUnable to load S3 credentials.";
            throw new RuntimeException(msg, e2);
        }
    }

    URL generatePresignedUrl(String path, Date expiration) {
        String[] bk = PersistS3.decodePath(path);
        return PersistS3.getClient().generatePresignedUrl(bk[0], bk[1], expiration, HttpMethod.GET);
    }

    @Override
    public boolean exists(String path) {
        String[] bk = PersistS3.decodePath(path);
        ObjectListing objects = PersistS3.getClient().listObjects(bk[0], bk[1]);
        return !objects.getObjectSummaries().isEmpty();
    }

    @Override
    public InputStream open(String path) {
        String[] bk = PersistS3.decodePath(path);
        GetObjectRequest r2 = new GetObjectRequest(bk[0], bk[1]);
        S3Object s3obj = PersistS3.getClient().getObject(r2);
        return s3obj.getObjectContent();
    }

    @Override
    public OutputStream create(String path, boolean overwrite) {
        File tmpFile;
        String[] bk = PersistS3.decodePath(path);
        try {
            tmpFile = File.createTempFile("h2o-export", ".bin");
            tmpFile.deleteOnExit();
        }
        catch (IOException e2) {
            throw new RuntimeException("Failed to create temporary file for S3 object upload", e2);
        }
        PutObjectCallback callback = new PutObjectCallback(PersistS3.getClient(), tmpFile, true, bk[0], bk[1]);
        try {
            return new CallbackFileOutputStream(tmpFile, callback);
        }
        catch (FileNotFoundException e3) {
            throw new RuntimeException(e3);
        }
    }

    public static Key loadKey(ObjectListing listing, S3ObjectSummary obj) throws IOException {
        String bucketName = obj.getBucketName() == null ? listing.getBucketName() : obj.getBucketName();
        return S3FileVec.make(PersistS3.encodePath(bucketName, obj.getKey()), obj.getSize());
    }

    private static void processListing(ObjectListing listing, String pattern, ArrayList<String> succ, ArrayList<String> fail, boolean doImport) {
        if (pattern != null && pattern.isEmpty()) {
            pattern = null;
        }
        for (S3ObjectSummary obj : listing.getObjectSummaries()) {
            if (obj.getKey().endsWith("/") || pattern != null && !obj.getKey().matches(pattern)) continue;
            try {
                if (doImport) {
                    Key k2 = PersistS3.loadKey(listing, obj);
                    succ.add(k2.toString());
                    continue;
                }
                succ.add(obj.getKey());
            }
            catch (IOException e2) {
                fail.add(obj.getKey());
            }
        }
    }

    @Override
    public void importFiles(String path, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        LOG.info((Object)("ImportS3 processing (" + path + ")"));
        AmazonS3 s3 = PersistS3.getClient();
        String[] parts = PersistS3.decodePath(path);
        ObjectListing currentList = s3.listObjects(parts[0], parts[1]);
        PersistS3.processListing(currentList, pattern, files, fails, true);
        while (currentList.isTruncated()) {
            currentList = s3.listNextBatchOfObjects(currentList);
            PersistS3.processListing(currentList, pattern, files, fails, true);
        }
        keys.addAll(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] load(Value v2) {
        long start_io_ms = System.currentTimeMillis();
        byte[] b2 = MemoryManager.malloc1(v2._max);
        Key k2 = v2._key;
        long skip = 0L;
        if (k2._kb[0] == 5) {
            skip = FileVec.chunkOffset(k2);
        }
        S3ObjectInputStream s2 = null;
        while (true) {
            try {
                long start_ns = System.nanoTime();
                s2 = PersistS3.getObjectForKey(k2, skip, v2._max).getObjectContent();
                ByteStreams.readFully(s2, b2);
                assert (v2.isPersisted());
                byte[] byArray = b2;
                return byArray;
            }
            catch (IOException e2) {
                PersistS3.ignoreAndWait(e2);
                continue;
            }
            finally {
                try {
                    if (s2 == null) continue;
                    s2.close();
                }
                catch (IOException iOException) {}
                continue;
            }
            break;
        }
    }

    private static void ignoreAndWait(Exception e2) {
        LOG.debug((Object)"Hit the S3 reset problem, waiting and retrying...", (Throwable)e2);
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void store(Value v2) {
        if (!v2._key.home()) {
            return;
        }
        throw H2O.unimpl();
    }

    public static Key encodeKey(String bucket, String key) {
        Key res = PersistS3.encodeKeyImpl(bucket, key);
        return res;
    }

    public static String[] decodeKey(Key k2) {
        return PersistS3.decodeKeyImpl(k2);
    }

    private static String encodePath(String bucket, String key) {
        return KEY_PREFIX + bucket + '/' + key;
    }

    private static Key encodeKeyImpl(String bucket, String key) {
        return Key.make(KEY_PREFIX + bucket + '/' + key);
    }

    private static String[] decodePath(String s2) {
        assert (s2.startsWith(KEY_PREFIX) && s2.indexOf(47) >= 0) : "Attempting to decode non s3 key: " + s2;
        int dlm = (s2 = s2.substring(KEY_PREFIX_LEN)).indexOf(47);
        if (dlm < 0) {
            return new String[]{s2, null};
        }
        String bucket = s2.substring(0, dlm);
        String key = s2.substring(dlm + 1);
        return new String[]{bucket, key};
    }

    private static String[] decodeKeyImpl(Key k2) {
        String s2 = new String(k2._kb[0] == 5 ? Arrays.copyOfRange(k2._kb, 10, k2._kb.length) : k2._kb);
        return PersistS3.decodePath(s2);
    }

    private static S3Object getObjectForKey(Key k2, long offset, long length) throws IOException {
        String[] bk = PersistS3.decodeKey(k2);
        GetObjectRequest r2 = new GetObjectRequest(bk[0], bk[1]);
        r2.setRange(offset, offset + length - 1L);
        return PersistS3.getClient().getObject(r2);
    }

    private static ObjectMetadata getObjectMetadataForKey(Key k2) {
        String[] bk = PersistS3.decodeKey(k2);
        assert (bk.length == 2);
        return PersistS3.getClient().getObjectMetadata(bk[0], bk[1]);
    }

    static ClientConfiguration s3ClientCfg() {
        ClientConfiguration cfg = new ClientConfiguration();
        Properties prop = System.getProperties();
        if (prop.containsKey(S3_SOCKET_TIMEOUT_PROP)) {
            cfg.setSocketTimeout(Integer.getInteger(S3_SOCKET_TIMEOUT_PROP));
        }
        if (prop.containsKey(S3_CONNECTION_TIMEOUT_PROP)) {
            cfg.setConnectionTimeout(Integer.getInteger(S3_CONNECTION_TIMEOUT_PROP));
        }
        if (prop.containsKey(S3_MAX_ERROR_RETRY_PROP)) {
            cfg.setMaxErrorRetry(Integer.getInteger(S3_MAX_ERROR_RETRY_PROP));
        }
        if (prop.containsKey(S3_MAX_HTTP_CONNECTIONS_PROP)) {
            cfg.setMaxConnections(Integer.getInteger(S3_MAX_HTTP_CONNECTIONS_PROP));
        }
        if (prop.containsKey(S3_FORCE_HTTP)) {
            cfg.setProtocol(Protocol.HTTP);
        }
        return cfg;
    }

    static AmazonS3Client configureClient(AmazonS3Client s3Client) {
        if (System.getProperty(S3_REGION) != null) {
            String region = System.getProperty(S3_REGION);
            LOG.debug((Object)String.format("S3 region specified: %s", region));
            s3Client.setRegion(RegionUtils.getRegion(region));
        }
        if (System.getProperty(S3_END_POINT) != null) {
            String endPoint = System.getProperty(S3_END_POINT);
            LOG.debug((Object)String.format("S3 endpoint specified: %s", endPoint));
            s3Client.setEndpoint(endPoint);
        }
        if (System.getProperty(S3_ENABLE_PATH_STYLE) != null && Boolean.parseBoolean(System.getProperty(S3_ENABLE_PATH_STYLE))) {
            LOG.debug((Object)"S3 path style access enabled");
            S3ClientOptions sco = S3ClientOptions.builder().setPathStyleAccess(true).build();
            s3Client.setS3ClientOptions(sco);
        }
        return s3Client;
    }

    @Override
    public void delete(Value v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Key uriToKey(URI uri) throws IOException {
        AmazonS3 s3 = PersistS3.getClient();
        Object[] parts = PersistS3.decodePath(uri.toString());
        try {
            ObjectMetadata om = s3.getObjectMetadata(parts[0], parts[1]);
            return S3FileVec.make(PersistS3.encodePath(parts[0], parts[1]), om.getContentLength());
        }
        catch (AmazonServiceException e2) {
            if (e2.getErrorCode().contains("404")) {
                throw new IOException(e2);
            }
            LOG.error((Object)("AWS failed for " + Arrays.toString(parts) + ": " + e2.getMessage()));
            throw e2;
        }
    }

    @Override
    public void cleanUp() {
        throw H2O.unimpl();
    }

    @Override
    public List<String> calcTypeaheadMatches(String filter, int limit) {
        String[] parts = PersistS3.decodePath(filter);
        if (parts[1] != null) {
            if (_keyCaches.get(parts[0]) == null) {
                if (!PersistS3.getClient().doesBucketExist(parts[0])) {
                    return new ArrayList<String>();
                }
                _keyCaches.put(parts[0], new KeyCache(parts[0]));
            }
            return _keyCaches.get(parts[0]).fetch(parts[1], limit);
        }
        return _bucketCache.fetch(parts[0], limit);
    }

    static {
        _bucketCache = new Cache();
        _keyCaches = new HashMap();
    }

    private static class KeyCache
    extends Cache {
        private final String _keyPrefix;
        private final String _bucket;

        public KeyCache(String bucket) {
            this._bucket = bucket;
            this._keyPrefix = super.wrapKey(bucket) + "/";
        }

        @Override
        protected String[] update() {
            LOG.debug((Object)"Renewing S3 cache.");
            AmazonS3 s3 = PersistS3.getClient();
            ObjectListing currentList = s3.listObjects(this._bucket, "");
            ArrayList res = new ArrayList();
            PersistS3.processListing(currentList, null, res, null, false);
            while (currentList.isTruncated()) {
                currentList = s3.listNextBatchOfObjects(currentList);
                PersistS3.processListing(currentList, null, res, null, false);
            }
            Collections.sort(res);
            this._cache = res.toArray(new String[res.size()]);
            return this._cache;
        }

        @Override
        protected String wrapKey(String s2) {
            return this._keyPrefix + s2;
        }
    }

    static class Cache {
        long _lastUpdated = 0L;
        long _timeoutMillis = 300000L;
        String[] _cache = new String[0];

        Cache() {
        }

        public boolean containsKey(String k2) {
            return Arrays.binarySearch(this._cache, k2) >= 0;
        }

        protected String[] update() {
            LOG.debug((Object)"Renewing S3 bucket cache.");
            List<Bucket> l2 = PersistS3.getClient().listBuckets();
            Object[] cache = new String[l2.size()];
            int i2 = 0;
            for (Bucket b2 : l2) {
                cache[i2++] = b2.getName();
            }
            Arrays.sort(cache);
            this._cache = cache;
            return cache;
        }

        protected String wrapKey(String s2) {
            return PersistS3.KEY_PREFIX + s2;
        }

        public ArrayList<String> fetch(String filter, int limit) {
            Object[] cache = this._cache;
            if (System.currentTimeMillis() > this._lastUpdated + this._timeoutMillis) {
                cache = this.update();
                this._lastUpdated = System.currentTimeMillis();
            }
            ArrayList<String> res = new ArrayList<String>();
            int i2 = Arrays.binarySearch(cache, filter);
            if (i2 < 0) {
                i2 = -i2 - 1;
            }
            while (i2 < cache.length && ((String)cache[i2]).startsWith(filter) && (limit < 0 || res.size() < limit)) {
                res.add(this.wrapKey((String)cache[i2++]));
            }
            return res;
        }
    }

    static class CallbackFileOutputStream
    extends FileOutputStream {
        private final Object closeLock = new Object();
        private volatile boolean closed = false;
        private final Runnable callback;

        public CallbackFileOutputStream(File file, Runnable callback) throws FileNotFoundException {
            super(file);
            this.callback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.closeLock;
            synchronized (object) {
                if (this.closed) {
                    super.close();
                    return;
                }
                this.closed = true;
            }
            this.callback.run();
        }
    }

    static class PutObjectCallback
    implements Runnable {
        private final AmazonS3 _client;
        private final File _file;
        private final boolean _deleteOnDone;
        private final String _bucketName;
        private final String _key;

        public PutObjectCallback(AmazonS3 client, File file, boolean deleteOnDone, String bucketName, String key) {
            this._client = client;
            this._file = file;
            this._deleteOnDone = deleteOnDone;
            this._bucketName = bucketName;
            this._key = key;
        }

        @Override
        public void run() {
            try {
                PutObjectRequest request = new PutObjectRequest(this._bucketName, this._key, this._file);
                PutObjectResult result = this._client.putObject(request);
                Log.info("Object `" + this._key + "` uploaded to bucket `" + this._bucketName + "`, ETag=`" + result.getETag() + "`.");
            }
            finally {
                boolean deleted;
                if (this._deleteOnDone && !(deleted = this._file.delete())) {
                    LOG.warn((Object)("Temporary file `" + this._file.getAbsolutePath() + "` was not deleted. Please delete manually."));
                }
            }
        }
    }

    static class H2OArgCredentialsProvider
    implements AWSCredentialsProvider {
        public static final String DEFAULT_CREDENTIALS_LOCATION = "AwsCredentials.properties";

        H2OArgCredentialsProvider() {
        }

        @Override
        public AWSCredentials getCredentials() {
            File credentials = new File(H2O.ARGS.aws_credentials != null ? H2O.ARGS.aws_credentials : DEFAULT_CREDENTIALS_LOCATION);
            try {
                return new PropertiesCredentials(credentials);
            }
            catch (IOException e2) {
                LOG.debug((Object)("Unable to load AWS credentials from file " + credentials + "; exists? " + credentials.exists() + ", canRead? " + credentials.canRead() + ", size=" + credentials.length() + "; problem: " + e2.getMessage()));
                throw new AmazonClientException("PersistS3. Unable to load AWS credentials from file " + credentials + ": " + e2.getMessage());
            }
        }

        @Override
        public void refresh() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static final class H2ODynamicCredentialsProvider
    implements AWSCredentialsProvider {
        private H2ODynamicCredentialsProvider() {
        }

        @Override
        public AWSCredentials getCredentials() {
            IcedS3Credentials s3Credentials = (IcedS3Credentials)DKV.getGet("S3_CREDENTIALS_KEY");
            if (s3Credentials != null && s3Credentials.isAWSCredentialsAuth()) {
                return new BasicAWSCredentials(s3Credentials._secretKeyId, s3Credentials._secretAccessKey);
            }
            if (s3Credentials != null && s3Credentials.isAWSSessionTokenAuth()) {
                return new BasicSessionCredentials(s3Credentials._secretKeyId, s3Credentials._secretAccessKey, s3Credentials._sessionToken);
            }
            throw new AmazonClientException("No Amazon S3 credentials set directly.");
        }

        @Override
        public void refresh() {
        }
    }

    public static class H2OAWSCredentialsProviderChain
    extends AWSCredentialsProviderChain {
        public H2OAWSCredentialsProviderChain() {
            super(H2OAWSCredentialsProviderChain.constructProviderChain());
        }

        static AWSCredentialsProvider[] constructProviderChain() {
            return H2OAWSCredentialsProviderChain.constructProviderChain(System.getProperty(PersistS3.S3_CUSTOM_CREDENTIALS_PROVIDER_CLASS));
        }

        static AWSCredentialsProvider[] constructProviderChain(String customProviderClassName) {
            AWSCredentialsProvider[] defaultProviders = new AWSCredentialsProvider[]{new H2ODynamicCredentialsProvider(), new H2OArgCredentialsProvider(), new DefaultAWSCredentialsProviderChain()};
            if (customProviderClassName == null) {
                return defaultProviders;
            }
            try {
                AWSCredentialsProvider customProvider = ReflectionUtils.newInstance(customProviderClassName, AWSCredentialsProvider.class);
                Log.info("Added custom credentials provider (" + customProviderClassName + ") to credentials provider chain.");
                return ArrayUtils.append(new AWSCredentialsProvider[]{customProvider}, defaultProviders);
            }
            catch (Exception e2) {
                Log.warn("Skipping invalid credentials provider (" + customProviderClassName + ").", e2);
                return defaultProviders;
            }
        }
    }
}

