/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import water.AutoBuffer;
import water.H2O;
import water.Key;
import water.Value;
import water.exceptions.H2ONotFoundArgumentException;
import water.fvec.NFSFileVec;
import water.persist.Persist;
import water.util.FileIntegrityChecker;
import water.util.FileUtils;
import water.util.Log;

public final class PersistNFS
extends Persist {
    static final String KEY_PREFIX = "nfs:" + File.separator;
    static final int KEY_PREFIX_LENGTH = KEY_PREFIX.length();

    public static Key decodeFile(File f2) {
        return Key.make(KEY_PREFIX + f2.toString());
    }

    private static File getFileForKey(Key k2) {
        int off;
        int n2 = off = k2._kb[0] == 5 ? 10 : 0;
        assert (new String(k2._kb, off, KEY_PREFIX_LENGTH).equals(KEY_PREFIX)) : "Not an NFS key: " + k2;
        String s2 = new String(k2._kb, KEY_PREFIX_LENGTH + off, k2._kb.length - (KEY_PREFIX_LENGTH + off));
        return new File(s2);
    }

    @Override
    public void cleanUp() {
    }

    public static InputStream openStream(Key k2) throws IOException {
        return new FileInputStream(PersistNFS.getFileForKey(k2));
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] load(Value v) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void store(Value v2) {
        if (!v2._key.home()) {
            return;
        }
        if (v2.isPersisted()) {
            return;
        }
        try {
            File f2 = PersistNFS.getFileForKey(v2._key);
            if (!f2.mkdirs()) {
                throw new IOException("Unable to create directory " + f2);
            }
            try (FileOutputStream s2 = new FileOutputStream(f2);){
                byte[] m4 = v2.memOrLoad();
                assert (m4 == null || m4.length == v2._max);
                if (m4 != null) {
                    new AutoBuffer(s2.getChannel(), false, 4).putA1(m4, m4.length).close();
                }
            }
        }
        catch (IOException e2) {
            Log.err(e2);
        }
    }

    @Override
    public void delete(Value v2) {
        throw H2O.fail();
    }

    @Override
    public Key uriToKey(URI uri) {
        return NFSFileVec.make((File)(uri.getScheme() == null ? new File((String)uri.toString()) : new File((URI)uri)))._key;
    }

    public ArrayList<String> calcTypeaheadMatches(String filter, int limit) {
        File base = null;
        String filterPrefix = "";
        if (limit == 0) {
            --limit;
        }
        if (!filter.isEmpty()) {
            File file = new File(filter);
            if (file.isDirectory()) {
                base = file;
            } else {
                base = file.getParentFile();
                filterPrefix = file.getName().toLowerCase();
            }
        }
        if (base == null) {
            base = new File(".");
        }
        ArrayList<String> array = new ArrayList<String>();
        File[] files = base.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isHidden()) continue;
                if (file.getName().toLowerCase().startsWith(filterPrefix)) {
                    array.add(file.getPath());
                }
                if (array.size() == limit) break;
            }
        }
        return array;
    }

    @Override
    public void importFiles(String path, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        File f2 = new File(FileUtils.getURI(path));
        if (!f2.exists()) {
            throw new H2ONotFoundArgumentException("File " + path + " does not exist");
        }
        FileIntegrityChecker.check(f2).syncDirectory(files, keys, fails, dels);
    }
}

