/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import ai.h2o.com.google.common.cache.CacheBuilder;
import ai.h2o.com.google.common.cache.CacheLoader;
import ai.h2o.com.google.common.cache.LoadingCache;
import com.google.cloud.ReadChannel;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import water.H2O;
import water.Key;
import water.MemoryManager;
import water.Value;
import water.api.FSIOException;
import water.fvec.FileVec;
import water.fvec.GcsFileVec;
import water.persist.GcsBlob;
import water.persist.GcsStorageProvider;
import water.persist.Persist;
import water.util.Log;

public final class PersistGcs
extends Persist {
    private GcsStorageProvider storageProvider = new GcsStorageProvider();
    private final LoadingCache<String, List<String>> keyCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(10L, TimeUnit.MINUTES).build(new CacheLoader<String, List<String>>(){

        @Override
        public List<String> load(String key) {
            ArrayList<String> blobs = new ArrayList<String>();
            for (Blob b2 : PersistGcs.this.storageProvider.getStorage().get(key, new Storage.BucketGetOption[0]).list(new Storage.BlobListOption[0]).iterateAll()) {
                blobs.add(b2.getName());
            }
            return blobs;
        }
    });
    private final LoadingCache<Object, List<String>> bucketCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.MINUTES).build(new CacheLoader<Object, List<String>>(){

        @Override
        public List<String> load(Object key) {
            ArrayList<String> fileNames = new ArrayList<String>();
            for (Bucket b2 : PersistGcs.this.storageProvider.getStorage().list(new Storage.BucketListOption[0]).iterateAll()) {
                fileNames.add(b2.getName());
            }
            return fileNames;
        }
    });

    @Override
    public byte[] load(Value v2) throws IOException {
        BlobId blobId = GcsBlob.of(v2._key).getBlobId();
        byte[] contentBytes = MemoryManager.malloc1(v2._max);
        ByteBuffer wrappingBuffer = ByteBuffer.wrap(contentBytes);
        Key k2 = v2._key;
        long offset = 0L;
        if (k2._kb[0] == 5) {
            offset = FileVec.chunkOffset(k2);
        }
        ReadChannel reader = this.storageProvider.getStorage().reader(blobId, new Storage.BlobSourceOption[0]);
        reader.seek(offset);
        reader.read(wrappingBuffer);
        return contentBytes;
    }

    @Override
    public Key uriToKey(URI uri) throws IOException {
        GcsBlob blob = GcsBlob.of(uri);
        Long contentSize = this.storageProvider.getStorage().get(blob.getBlobId()).getSize();
        return GcsFileVec.make(blob.getCanonical(), contentSize);
    }

    @Override
    public void store(Value v2) throws IOException {
        if (!v2._key.home()) {
            return;
        }
        byte[] payload = v2.memOrLoad();
        GcsBlob blob = GcsBlob.of(v2._key);
        Log.debug("Storing: " + blob.toString());
        ByteBuffer buffer = ByteBuffer.wrap(payload);
        this.storageProvider.getStorage().create(blob.getBlobInfo(), new Storage.BlobTargetOption[0]).writer(new Storage.BlobWriteOption[0]).write(buffer);
    }

    @Override
    public void delete(Value v2) {
        BlobId blobId = GcsBlob.of(v2._key).getBlobId();
        Log.debug("Deleting: " + blobId.toString());
        this.storageProvider.getStorage().get(blobId).delete(new Blob.BlobSourceOption[0]);
    }

    @Override
    public void cleanUp() {
        throw H2O.unimpl();
    }

    @Override
    public List<String> calcTypeaheadMatches(String filter, int limit) {
        ArrayList<String> results;
        block6: {
            String input = GcsBlob.removePrefix(filter);
            String[] bk = input.split("/", 2);
            results = limit > 0 ? new ArrayList<String>(limit) : new ArrayList();
            try {
                if (bk.length == 1) {
                    List<String> buckets = this.bucketCache.get("all");
                    for (String s2 : buckets) {
                        results.add("gs://" + s2);
                        if (--limit != 0) continue;
                        break block6;
                    }
                    break block6;
                }
                if (bk.length != 2) break block6;
                List<String> objects = this.keyCache.get(bk[0]);
                for (String s3 : objects) {
                    if (s3.startsWith(bk[1])) {
                        results.add("gs://" + bk[0] + "/" + s3);
                    }
                    if (--limit != 0) continue;
                    break;
                }
            }
            catch (ExecutionException e2) {
                Log.err(e2);
            }
        }
        return results;
    }

    @Override
    public void importFiles(String path, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        String[] bk = GcsBlob.removePrefix(path).split("/", 2);
        if (bk.length < 2) {
            this.parseBucket(bk[0], files, keys, fails);
        } else {
            try {
                Iterable<Blob> values = this.storageProvider.getStorage().list(bk[0], Storage.BlobListOption.prefix(bk[1])).getValues();
                values.forEach(blob -> {
                    String blobPath = "gs://" + blob.getBucket() + "/" + blob.getName();
                    Key k2 = GcsFileVec.make(blobPath, blob.getSize());
                    keys.add(k2.toString());
                    files.add(blobPath);
                });
            }
            catch (Throwable t2) {
                Log.err(t2);
                fails.add(path);
            }
        }
    }

    private void parseBucket(String bucketId, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails) {
        Bucket bucket = this.storageProvider.getStorage().get(bucketId, new Storage.BucketGetOption[0]);
        for (Blob blob : bucket.list(new Storage.BlobListOption[0]).iterateAll()) {
            GcsBlob gcsBlob = GcsBlob.of(blob.getBlobId());
            Log.debug("Importing: " + gcsBlob.toString());
            try {
                Key k2 = GcsFileVec.make(gcsBlob.getCanonical(), blob.getSize());
                keys.add(k2.toString());
                files.add(gcsBlob.getCanonical());
            }
            catch (Throwable t2) {
                Log.err(t2);
                fails.add(gcsBlob.getCanonical());
            }
        }
    }

    @Override
    public InputStream open(final String path) {
        GcsBlob gcsBlob = GcsBlob.of(path);
        Log.debug("Opening: " + gcsBlob.toString());
        final Blob blob = this.storageProvider.getStorage().get(gcsBlob.getBlobId());
        return new InputStream(){
            final ReadChannel reader;
            {
                this.reader = blob.reader(new Blob.BlobSourceOption[0]);
            }

            @Override
            public int read() throws IOException {
                try {
                    ByteBuffer bytes = ByteBuffer.wrap(MemoryManager.malloc1(1));
                    int numRed = this.reader.read(bytes);
                    if (numRed == 0) {
                        return -1;
                    }
                    return bytes.get(0);
                }
                catch (IOException e2) {
                    throw new FSIOException(path, e2);
                }
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                Objects.requireNonNull(bytes);
                if (off < 0 || len < 0 || len > bytes.length - off) {
                    throw new IndexOutOfBoundsException("Length of byte array is " + bytes.length + ". Offset is " + off + " and length is " + len);
                }
                if (len == 0) {
                    return 0;
                }
                ByteBuffer buffer = ByteBuffer.wrap(bytes, off, len);
                return this.reader.read(buffer);
            }

            @Override
            public int available() throws IOException {
                return 1;
            }

            @Override
            public void close() throws IOException {
                this.reader.close();
            }
        };
    }

    @Override
    public OutputStream create(String path, boolean overwrite) {
        GcsBlob gcsBlob = GcsBlob.of(path);
        Log.debug("Creating: " + gcsBlob.getCanonical());
        final WriteChannel writer = this.storageProvider.getStorage().create(gcsBlob.getBlobInfo(), new Storage.BlobTargetOption[0]).writer(new Storage.BlobWriteOption[0]);
        return new OutputStream(){

            @Override
            public void write(int b2) throws IOException {
                ByteBuffer buffer = ByteBuffer.wrap(new byte[]{(byte)b2});
                writer.write(buffer);
            }

            @Override
            public void write(byte[] b2) throws IOException {
                ByteBuffer buffer = ByteBuffer.wrap(b2);
                writer.write(buffer);
            }

            @Override
            public void write(byte[] b2, int off, int len) throws IOException {
                ByteBuffer buffer = ByteBuffer.wrap(b2, off, len);
                writer.write(buffer);
            }

            @Override
            public void close() throws IOException {
                writer.close();
            }
        };
    }

    @Override
    public boolean rename(String fromPath, String toPath) {
        BlobId fromBlob = GcsBlob.of(fromPath).getBlobId();
        BlobId toBlob = GcsBlob.of(toPath).getBlobId();
        this.storageProvider.getStorage().get(fromBlob).copyTo(toBlob, new Blob.BlobSourceOption[0]);
        this.keyCache.invalidate(fromBlob.getBucket());
        this.keyCache.invalidate(toBlob.getBucket());
        return this.storageProvider.getStorage().delete(fromBlob);
    }

    private String[] split(String path) {
        return GcsBlob.removePrefix(path).split("/", 2);
    }

    @Override
    public boolean exists(String path) {
        String[] bk = this.split(path);
        if (bk.length == 1) {
            return this.storageProvider.getStorage().get(bk[0], new Storage.BucketGetOption[0]).exists(new Bucket.BucketSourceOption[0]);
        }
        if (bk.length == 2) {
            Blob blob = this.storageProvider.getStorage().get(bk[0], bk[1], new Storage.BlobGetOption[0]);
            return blob != null && blob.exists(new Blob.BlobSourceOption[0]);
        }
        return false;
    }

    @Override
    public boolean isDirectory(String path) {
        String[] bk = this.split(path);
        return bk.length == 1;
    }

    @Override
    public String getParent(String path) {
        String[] bk = this.split(path);
        if (bk.length > 0) {
            return bk[0];
        }
        return null;
    }

    @Override
    public boolean delete(String path) {
        BlobId blob = GcsBlob.of(path).getBlobId();
        this.keyCache.invalidate(blob.getBucket());
        return this.storageProvider.getStorage().get(blob).delete(new Blob.BlobSourceOption[0]);
    }

    @Override
    public long length(String path) {
        BlobId blob = GcsBlob.of(path).getBlobId();
        return this.storageProvider.getStorage().get(blob).getSize();
    }

    @Override
    public Persist.PersistEntry[] list(String path) {
        String[] bk = this.split(path);
        int substrLen = bk.length == 2 ? bk[1].length() : 0;
        ArrayList<Persist.PersistEntry> results = new ArrayList<Persist.PersistEntry>();
        try {
            for (Blob b2 : this.storageProvider.getStorage().list(bk[0], new Storage.BlobListOption[0]).iterateAll()) {
                if (bk.length != 1 && (bk.length != 2 || !b2.getName().startsWith(bk[1]))) continue;
                String relativeName = b2.getName().substring(substrLen);
                if (relativeName.startsWith("/")) {
                    relativeName = relativeName.substring(1);
                }
                results.add(new Persist.PersistEntry(relativeName, b2.getSize(), b2.getUpdateTime()));
            }
        }
        catch (StorageException e2) {
            Log.err(e2);
        }
        return results.toArray(new Persist.PersistEntry[results.size()]);
    }

    @Override
    public boolean mkdirs(String path) {
        try {
            String[] bk = this.split(path);
            if (bk.length > 0) {
                Bucket b2 = this.storageProvider.getStorage().get(bk[0], new Storage.BucketGetOption[0]);
                if (b2 == null || !b2.exists(new Bucket.BucketSourceOption[0])) {
                    this.storageProvider.getStorage().create(BucketInfo.of(bk[0]), new Storage.BucketTargetOption[0]);
                }
                return true;
            }
            return false;
        }
        catch (StorageException e2) {
            Log.err(e2);
            return false;
        }
    }
}

