/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import water.Key;
import water.Value;
import water.fvec.Vec;
import water.util.Log;

public abstract class Persist {
    public abstract void store(Value var1) throws IOException;

    public abstract byte[] load(Value var1) throws IOException;

    public byte[] load(Key k2, long skip, int max) throws IOException {
        throw new UnsupportedOperationException("Persist Backend " + this.getClass().getSimpleName() + " doesn't support direct data read.");
    }

    public abstract void delete(Value var1);

    public long getUsableSpace() {
        return -1L;
    }

    public long getTotalSpace() {
        return -1L;
    }

    public abstract Key uriToKey(URI var1) throws IOException;

    public abstract void cleanUp();

    public abstract List<String> calcTypeaheadMatches(String var1, int var2);

    public abstract void importFiles(String var1, String var2, ArrayList<String> var3, ArrayList<String> var4, ArrayList<String> var5, ArrayList<String> var6);

    static String getIceName(Value v2) {
        return Persist.getIceName(v2._key);
    }

    static String getIceName(Key k2) {
        return Persist.getIceDirectory(k2) + File.separator + Persist.key2Str(k2);
    }

    static String getIceDirectory(Key key) {
        if (!key.isChunkKey()) {
            return "not_a_Chunk";
        }
        return Persist.key2Str(key.getVecKey());
    }

    protected static String key2Str(Key k2) {
        Key x2;
        String s2 = Persist.key2Str_impl(k2);
        assert ((x2 = Persist.str2Key_impl(s2)).equals(k2)) : "bijection fail " + k2 + " <-> " + s2 + " <-> " + x2;
        return s2;
    }

    static Key str2Key(String s2) {
        Key k2 = Persist.str2Key_impl(s2);
        assert (Persist.key2Str_impl(k2).equals(s2)) : "bijection fail " + s2 + " <-> " + k2;
        return k2;
    }

    private static String key2Str_impl(Key k2) {
        StringBuilder sb = new StringBuilder(k2._kb.length / 2 + 4);
        int i2 = 0;
        if (k2._kb[0] < 32) {
            int j2;
            sb.append('%');
            for (j2 = k2._kb.length - 1; j2 >= 0 && k2._kb[j2] >= 32 && k2._kb[j2] < 128; --j2) {
            }
            while (i2 <= j2) {
                int nib1;
                byte b2 = k2._kb[i2];
                int nib0 = (b2 >>> 4 & 0xF) + 48;
                if (nib0 > 57) {
                    nib0 += 7;
                }
                if ((nib1 = (b2 >>> 0 & 0xF) + 48) > 57) {
                    nib1 += 7;
                }
                sb.append((char)nib0).append((char)nib1);
                ++i2;
            }
            sb.append('%');
        }
        return Persist.escapeBytes(k2._kb, i2, sb).toString();
    }

    private static StringBuilder escapeBytes(byte[] bytes, int i2, StringBuilder sb) {
        while (i2 < bytes.length) {
            char b2 = (char)bytes[i2];
            char c2 = '\u0000';
            switch (b2) {
                case '%': {
                    c2 = '%';
                    break;
                }
                case '.': {
                    c2 = 'd';
                    break;
                }
                case '/': {
                    c2 = 's';
                    break;
                }
                case ':': {
                    c2 = 'c';
                    break;
                }
                case '\"': {
                    c2 = 'q';
                    break;
                }
                case '>': {
                    c2 = 'g';
                    break;
                }
                case '<': {
                    c2 = 'l';
                    break;
                }
                case '\\': {
                    c2 = 'b';
                    break;
                }
                case '\u0000': {
                    c2 = 'z';
                }
            }
            if (c2 != '\u0000') {
                sb.append('%').append(c2);
            } else {
                sb.append(b2);
            }
            ++i2;
        }
        return sb;
    }

    private static Key str2Key_impl(String s2) {
        String key = s2;
        byte[] kb = new byte[(key.length() - 1) / 2];
        int i2 = 0;
        int j2 = 0;
        if (key.length() > 2 && key.charAt(0) == '%' && key.charAt(1) >= '0' && key.charAt(1) <= '9') {
            for (i2 = 1; i2 < key.length() && key.charAt(i2) != '%'; i2 += 2) {
                char b1;
                char b0 = (char)(key.charAt(i2) - 48);
                if (b0 > '\t') {
                    b0 = (char)(b0 - 7);
                }
                if ((b1 = (char)(key.charAt(i2 + 1) - 48)) > '\t') {
                    b1 = (char)(b1 - 7);
                }
                kb[j2++] = (byte)(b0 << 4 | b1);
            }
            ++i2;
        }
        while (i2 < key.length()) {
            int b2 = key.charAt(i2);
            if (b2 == 37) {
                switch (key.charAt(++i2)) {
                    case '%': {
                        b2 = 37;
                        break;
                    }
                    case 'c': {
                        b2 = 58;
                        break;
                    }
                    case 'd': {
                        b2 = 46;
                        break;
                    }
                    case 'g': {
                        b2 = 62;
                        break;
                    }
                    case 'l': {
                        b2 = 60;
                        break;
                    }
                    case 'q': {
                        b2 = 34;
                        break;
                    }
                    case 's': {
                        b2 = 47;
                        break;
                    }
                    case 'b': {
                        b2 = 92;
                        break;
                    }
                    case 'z': {
                        b2 = 0;
                        break;
                    }
                    default: {
                        Log.warn("Invalid format of filename " + s2 + " at index " + i2);
                    }
                }
            }
            if (j2 >= kb.length) {
                kb = Arrays.copyOf(kb, Math.max(2, j2 * 2));
            }
            kb[j2++] = b2;
            ++i2;
        }
        return Key.make(Arrays.copyOf(kb, j2));
    }

    public String getHomeDirectory() {
        throw new RuntimeException("Not implemented");
    }

    public PersistEntry[] list(String path) {
        throw new RuntimeException("Not implemented");
    }

    public boolean exists(String path) {
        throw new RuntimeException("Not implemented");
    }

    public String getParent(String path) {
        throw new RuntimeException("Not implemented");
    }

    public boolean isDirectory(String path) {
        throw new RuntimeException("Not implemented");
    }

    public long length(String path) {
        throw new RuntimeException("Not implemented");
    }

    public InputStream open(String path) {
        throw new RuntimeException("Not implemented");
    }

    public InputStream openSeekable(String path) {
        throw new RuntimeException("Not implemented");
    }

    public boolean isSeekableOpenSupported() {
        return false;
    }

    public InputStream wrapSeekable(Vec vec) {
        throw new RuntimeException("Not implemented");
    }

    public boolean mkdirs(String path) {
        throw new RuntimeException("Not implemented");
    }

    public boolean rename(String fromPath, String toPath) {
        throw new RuntimeException("Not implemented");
    }

    public OutputStream create(String path, boolean overwrite) {
        throw new RuntimeException("Not implemented");
    }

    public boolean delete(String path) {
        throw new RuntimeException("Not implemented");
    }

    public boolean canHandle(String path) {
        throw new RuntimeException("Not implemented");
    }

    public static class PersistEntry {
        public final String _name;
        public final long _size;
        public final long _timestamp_millis;

        public PersistEntry(String name, long size, long timestamp) {
            this._name = name;
            this._size = size;
            this._timestamp_millis = timestamp;
        }
    }
}

