/*
 * Decompiled with CFR 0.152.
 */
package water.parser.orc;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.io.orc.OrcFile;
import org.apache.hadoop.hive.ql.io.orc.Reader;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import water.DKV;
import water.H2O;
import water.Job;
import water.Key;
import water.fvec.ByteVec;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.ParseSetup;
import water.parser.ParseWriter;
import water.parser.Parser;
import water.parser.ParserInfo;
import water.parser.ParserProvider;
import water.parser.orc.OrcParser;
import water.persist.VecFileSystem;

public class OrcParserProvider
extends ParserProvider {
    static ParserInfo ORC_INFO = new OrcParserInfo();
    public static byte[][] supported_type_conversions = new byte[][]{{0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 1, 1}, {1, 0, 0, 0, 0, 0}, {1, 0, 1, 0, 0, 0}, {1, 0, 0, 0, 0, 0}};

    @Override
    public ParserInfo info() {
        return ORC_INFO;
    }

    @Override
    public Parser createParser(ParseSetup setup, Key<Job> jobKey) {
        return new OrcParser(setup, jobKey);
    }

    @Override
    public ParseSetup guessSetup(ByteVec bv, byte[] bits, byte sep, int ncols, boolean singleQuotes, int checkHeader, String[] columnNames, byte[] columnTypes, String[][] domains, String[][] naStrings) {
        if (bv instanceof FileVec) {
            return this.readSetup((FileVec)bv, columnNames, columnTypes);
        }
        throw new UnsupportedOperationException("ORC only works on Files");
    }

    @Override
    public ParseSetup createParserSetup(Key[] inputs, ParseSetup requiredSetup) {
        Object frameOrVec = DKV.getGet(inputs[0]);
        FileVec f2 = frameOrVec instanceof Frame ? (FileVec)((Frame)frameOrVec).vec(0) : (FileVec)frameOrVec;
        return this.readSetup(f2, requiredSetup.getColumnNames(), requiredSetup.getColumnTypes());
    }

    private Reader getReader(FileVec f2) throws IOException {
        return OrcFile.createReader((FileSystem)VecFileSystem.VEC_PATH.getFileSystem(VecFileSystem.makeConfiguration(f2)), (Path)VecFileSystem.VEC_PATH);
    }

    public ParseSetup readSetup(FileVec f2, String[] columnNames, byte[] columnTypes) {
        try {
            List stripesInfo;
            Reader orcFileReader = this.getReader(f2);
            StructObjectInspector insp = (StructObjectInspector)orcFileReader.getObjectInspector();
            OrcParser.OrcParseSetup stp = OrcParser.deriveParseSetup(orcFileReader, insp);
            if (columnNames != null && stp.getAllColNames().length == columnNames.length) {
                stp.setColumnNames(columnNames);
                stp.setAllColNames(columnNames);
            }
            if (columnTypes != null) {
                byte[] old_columnTypes = stp.getColumnTypes();
                String[] old_columnTypeNames = stp.getColumnTypesString();
                for (int index = 0; index < columnTypes.length; ++index) {
                    if (columnTypes[index] != old_columnTypes[index]) {
                        if (supported_type_conversions[old_columnTypes[index]][columnTypes[index]] == 1) {
                            old_columnTypes[index] = columnTypes[index];
                        } else {
                            stp.addErrs(new ParseWriter.UnsupportedTypeOverride(f2._key.toString(), Vec.TYPE_STR[old_columnTypes[index]], Vec.TYPE_STR[columnTypes[index]], columnNames[index]));
                        }
                    }
                    if (columnTypes[index] != 4 && columnTypes[index] != 0 && columnTypes[index] != 5) continue;
                    old_columnTypes[index] = columnTypes[index];
                }
                stp.setColumnTypes(old_columnTypes);
                stp.setColumnTypeStrings(old_columnTypeNames);
            }
            if ((stripesInfo = orcFileReader.getStripes()).size() == 0) {
                stp._chunk_size = (int)f2.length();
                f2.setChunkSize(stp._chunk_size);
                return stp;
            }
            f2.setNChunks(stripesInfo.size());
            stp._chunk_size = f2._chunkSize;
            assert (f2.nChunks() == stripesInfo.size());
            return stp;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public ParseSetup setupLocal(Vec v2, ParseSetup setup) {
        if (!(v2 instanceof FileVec)) {
            throw H2O.unimpl("ORC only implemented for HDFS / NFS files");
        }
        try {
            ((OrcParser.OrcParseSetup)setup).setOrcFileReader(this.getReader((FileVec)v2));
            return setup;
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    public static class OrcParserInfo
    extends ParserInfo {
        public OrcParserInfo() {
            super("ORC", 10030, true, true, false);
        }

        public ParserInfo.ParseMethod parseMethod(int nfiles, int nchunks) {
            int ncores_tot = H2O.NUMCPUS * H2O.CLOUD.size();
            return nfiles >= ncores_tot >> 1 ? ParserInfo.ParseMethod.StreamParse : ParserInfo.ParseMethod.StreamParse;
        }
    }
}

