/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import water.H2O;
import water.Key;
import water.parser.BufferedString;
import water.parser.DefaultParserProviders;
import water.parser.ParseDataset;
import water.parser.ParseReader;
import water.parser.ParseSetup;
import water.parser.ParseWriter;
import water.parser.Parser;
import water.parser.PreviewParseWriter;
import water.parser.StreamParseWriter;
import water.util.UnsafeUtils;

class XlsParser
extends Parser {
    private InputStream _is;
    private byte[] _buf;
    private int _lim;
    private static final int NUM_BIG_BLOCK_DEPOT_BLOCKS_POS = 44;
    private static final int SMALL_BLOCK_DEPOT_BLOCK_POS = 60;
    private static final int ROOT_START_BLOCK_POS = 48;
    private static final int BIG_BLOCK_SIZE = 512;
    private static final int SMALL_BLOCK_SIZE = 64;
    private static final int EXTENSION_BLOCK_POS = 68;
    private static final int NUM_EXTENSION_BLOCK_POS = 72;
    private static final int PROPERTY_STORAGE_BLOCK_SIZE = 128;
    private static final int BIG_BLOCK_DEPOT_BLOCKS_POS = 76;
    private static final int SMALL_BLOCK_THRESHOLD = 4096;
    private static final int SIZE_OF_NAME_POS = 64;
    private static final int TYPE_POS = 66;
    private static final int START_BLOCK_POS = 116;
    private static final int SIZE_POS = 120;
    private static final byte[] IDENTIFIER_OLE = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};
    private int _numBigBlockDepotBlocks;
    private int _sbdStartBlock;
    private int _rootStartBlock;
    private int _extensionBlock;
    private int _numExtensionBlocks;
    private int[] _bigBlockChain;
    private int[] _smallBlockChain;
    private ArrayList<Props> _props = new ArrayList();
    private Props _wrkbook;
    private Props _rootentry;
    private static final int SPREADSHEET_EXCEL_READER_BIFF8 = 1536;
    private static final int SPREADSHEET_EXCEL_READER_BIFF7 = 1280;
    private static final int SPREADSHEET_EXCEL_READER_WORKBOOKGLOBALS = 5;
    private static final int SPREADSHEET_EXCEL_READER_WORKSHEET = 16;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_BOF = 2057;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_EOF = 10;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_BOUNDSHEET = 133;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_DIMENSION = 512;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_ROW = 520;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_DBCELL = 215;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_FILEPASS = 47;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_NOTE = 28;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_TXO = 438;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_RK = 126;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_RK2 = 638;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_MULRK = 189;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_MULBLANK = 190;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_INDEX = 523;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_SST = 252;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_EXTSST = 255;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_CONTINUE = 60;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_LABEL = 516;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_LABELSST = 253;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_NUMBER = 515;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_NAME = 24;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_ARRAY = 545;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_STRING = 519;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_FORMULA = 1030;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_FORMULA2 = 6;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_FORMAT = 1054;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_XF = 224;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_BOOLERR = 517;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_FONT = 49;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_PALETTE = 146;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_UNKNOWN = 65535;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_NINETEENFOUR = 34;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_MERGEDCELLS = 229;
    private static final int SPREADSHEET_EXCEL_READER_UTCOFFSETDAYS = 25569;
    private static final int SPREADSHEET_EXCEL_READER_UTCOFFSETDAYS1904 = 24107;
    private static final int SPREADSHEET_EXCEL_READER_MSINADAY = 86400;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_HYPER = 440;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_COLINFO = 125;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_DEFCOLWIDTH = 85;
    private static final int SPREADSHEET_EXCEL_READER_TYPE_STANDARDWIDTH = 153;
    private static final String SPREADSHEET_EXCEL_READER_DEF_NUM_FORMAT = "%s";
    private int _version;
    private boolean _nineteenFour;
    private String[] _formatRecords = new String[1];
    private ArrayList<String> _sst = new ArrayList();
    private ArrayList<Sheet> _boundsheets = new ArrayList();
    private ArrayList<XF> _xfRecords = new ArrayList();
    private static HashMap<Integer, String> DATEFORMATS = new HashMap();
    private static HashMap<Integer, String> NUMBERFORMATS;

    XlsParser(ParseSetup ps, Key jobKey) {
        super(ps, jobKey);
    }

    @Override
    protected ParseWriter parseChunk(int cidx, ParseReader din, ParseWriter dout) {
        throw H2O.unimpl();
    }

    private void readAtLeast(int lim) throws IOException {
        int x2;
        if (lim <= this._lim) {
            return;
        }
        if (this._buf == null) {
            this._buf = new byte[0];
        }
        if (lim > this._buf.length) {
            int oldlen = this._buf.length;
            int newlen = oldlen;
            if (newlen == 0) {
                newlen = 1024;
            }
            while (newlen < lim) {
                newlen <<= 1;
            }
            this._buf = Arrays.copyOf(this._buf, newlen);
        }
        while (this._lim < lim && (x2 = this._is.read(this._buf, this._lim, this._buf.length - this._lim)) != -1) {
            this._lim += x2;
        }
        if (this._lim < lim) {
            throw new ArrayIndexOutOfBoundsException("not an XLS file: reading at " + lim + " but file is only " + this._lim + " bytes");
        }
    }

    private int get4(int pos) throws IOException {
        this.readAtLeast(pos + 4);
        return UnsafeUtils.get4(this._buf, pos);
    }

    public static ParseSetup guessSetup(byte[] bytes) {
        XlsParser p2 = new XlsParser(new ParseSetup(DefaultParserProviders.XLS_INFO, -1, false, 0, -1, null, null, null, null, null), null);
        p2._buf = bytes;
        p2._lim = bytes.length;
        PreviewParseWriter dout = new PreviewParseWriter();
        try {
            p2.streamParse(new ByteArrayInputStream(bytes), dout);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        if (dout._ncols > 0 && dout._nlines > 0 && dout._nlines > dout._invalidLines) {
            return new ParseSetup(DefaultParserProviders.XLS_INFO, -1, false, dout.colNames() == null ? -1 : 1, dout._ncols, dout.colNames(), dout.guessTypes(), null, null, dout._data);
        }
        throw new ParseDataset.H2OParseException("Could not parse file as an XLS file.");
    }

    @Override
    public ParseWriter streamParse(InputStream is, StreamParseWriter dout) throws IOException {
        this._is = is;
        this.readAtLeast(IDENTIFIER_OLE.length);
        for (int i2 = 0; i2 < IDENTIFIER_OLE.length; ++i2) {
            if (this._buf[i2] == IDENTIFIER_OLE[i2]) continue;
            throw new ParseDataset.H2OParseException("Not a valid XLS file, lacks correct starting bits (aka magic number).");
        }
        this._numBigBlockDepotBlocks = this.get4(44);
        this._sbdStartBlock = this.get4(60);
        this._rootStartBlock = this.get4(48);
        this._extensionBlock = this.get4(68);
        this._numExtensionBlocks = this.get4(72);
        int pos = 76;
        int bbdBlocks = this._numExtensionBlocks == 0 ? this._numBigBlockDepotBlocks : 109;
        int[] bigBlockDepotBlocks = new int[bbdBlocks];
        for (int i3 = 0; i3 < bbdBlocks; ++i3) {
            bigBlockDepotBlocks[i3] = this.get4((pos += 4) - 4);
        }
        for (int j2 = 0; j2 < this._numExtensionBlocks; ++j2) {
            pos = (this._extensionBlock + 1) * 512;
            int blocksToRead = Math.min(this._numBigBlockDepotBlocks - bbdBlocks, 127);
            for (int i4 = bbdBlocks; i4 < bbdBlocks + blocksToRead; ++i4) {
                bigBlockDepotBlocks[i4] = this.get4((pos += 4) - 4);
            }
            if ((bbdBlocks += blocksToRead) >= this._numBigBlockDepotBlocks) continue;
            this._extensionBlock = this.get4(pos);
        }
        int index = 0;
        this._bigBlockChain = new int[1];
        for (int i5 = 0; i5 < this._numBigBlockDepotBlocks; ++i5) {
            pos = (bigBlockDepotBlocks[i5] + 1) * 512;
            for (int j3 = 0; j3 < 128; ++j3) {
                this._bigBlockChain[index++] = this.get4((pos += 4) - 4);
                if (index != this._bigBlockChain.length) continue;
                this._bigBlockChain = Arrays.copyOf(this._bigBlockChain, index << 1);
            }
        }
        index = 0;
        int sbdBlock = this._sbdStartBlock;
        int[] smallBlockChain = new int[1];
        while (sbdBlock != -2) {
            pos = (sbdBlock + 1) * 512;
            for (int j4 = 0; j4 < 128; ++j4) {
                smallBlockChain[index++] = this.get4((pos += 4) - 4);
                if (index != smallBlockChain.length) continue;
                smallBlockChain = Arrays.copyOf(smallBlockChain, index << 1);
            }
            sbdBlock = this._bigBlockChain[sbdBlock];
        }
        this.__readPropertySets(this.__readData(this._rootStartBlock));
        Buf data = this.getWorkBook();
        boolean res = this.parseWorkbook(data, dout);
        if (!res) {
            throw new IOException("not an XLS file");
        }
        return dout;
    }

    private Buf __readData(int block) throws IOException {
        Buf data = new Buf(this._buf, 0, 0);
        while (block != -2) {
            int pos = (block + 1) * 512;
            data.concat(pos, 512);
            block = this._bigBlockChain[block];
        }
        return data;
    }

    private void __readPropertySets(Buf entry) {
        for (int offset = 0; offset < entry._lim; offset += 128) {
            Buf d2 = new Buf(entry, offset, 128);
            int nameSize = d2.get2(64);
            byte type = d2._bbuf[66];
            int startBlock = d2.get4(116);
            int size = d2.get4(120);
            String name = "";
            for (int i2 = 0; i2 < nameSize; i2 += 2) {
                name = name + (char)d2.get2(i2);
            }
            name = name.replaceAll("\u0000", "");
            Props p2 = new Props(name, type, startBlock, size);
            this._props.add(p2);
            if (name.equalsIgnoreCase("workbook") || name.equalsIgnoreCase("book")) {
                this._wrkbook = p2;
            }
            if (!name.equals("Root Entry")) continue;
            this._rootentry = p2;
        }
    }

    private Buf getWorkBook() throws IOException {
        if (this._wrkbook._size < 4096) {
            Buf rootdata = this.__readData(this._rootentry._startBlock);
            Buf streamData = new Buf(rootdata, 0, 0);
            int block = this._wrkbook._startBlock;
            while (block != -2) {
                int pos = block * 64;
                streamData.concat(pos, 64);
                block = this._smallBlockChain[block];
            }
            return streamData;
        }
        int numBlocks = this._wrkbook._size / 512;
        if (this._wrkbook._size % 512 != 0) {
            ++numBlocks;
        }
        Buf streamData = new Buf(this._buf, 0, 0);
        if (numBlocks == 0) {
            return streamData;
        }
        int block = this._wrkbook._startBlock;
        while (block != -2) {
            int pos = (block + 1) * 512;
            streamData.concat(pos, 512);
            block = this._bigBlockChain[block];
        }
        return streamData;
    }

    private boolean parseWorkbook(Buf data, ParseWriter dout) {
        int pos = 0;
        int code = data.get2(pos);
        int length = data.get2(pos + 2);
        int version = data.get2(pos + 4);
        int substreamType = data.get2(pos + 6);
        this._version = version;
        if (version != 1536 && version != 1280) {
            return false;
        }
        if (substreamType != 5) {
            return false;
        }
        code = data.get2(pos += length + 4);
        length = data.get2(pos + 2);
        while (code != 10) {
            switch (code) {
                case 252: {
                    int spos = pos + 4;
                    int limitpos = spos + length;
                    int uniqueStrings = data.get4(spos + 4);
                    spos += 8;
                    for (int i2 = 0; i2 < uniqueStrings; ++i2) {
                        int len;
                        if (spos == limitpos) {
                            int conlength = data.get2(spos + 2);
                            limitpos = (spos += 4) + conlength;
                        }
                        int numChars = data.get2(spos);
                        char optionFlags = data.get1(spos += 2);
                        ++spos;
                        boolean asciiEncoding = (optionFlags & '\u0001') == 0;
                        boolean extendedString = (optionFlags & 4) != 0;
                        boolean richString = (optionFlags & 8) != 0;
                        int formattingRuns = 0;
                        if (richString) {
                            formattingRuns = data.get2((spos += 2) - 2);
                        }
                        int extendedRunLength = 0;
                        if (extendedString) {
                            extendedRunLength = data.get4((spos += 4) - 4);
                        }
                        String retstr = null;
                        int n2 = len = asciiEncoding ? numChars : numChars * 2;
                        if (spos + len < limitpos) {
                            retstr = data.getStr((spos += len) - len, len);
                        } else {
                            retstr = data.getStr(spos, limitpos - spos);
                            int bytesRead = limitpos - spos;
                            int charsLeft = numChars - (asciiEncoding ? bytesRead : bytesRead / 2);
                            spos = limitpos;
                            if (charsLeft > 0) {
                                int opcode = data.get2(spos);
                                int conlength = data.get2(spos + 2);
                                if (opcode != 60) {
                                    return false;
                                }
                                limitpos = (spos += 4) + conlength;
                                char option = data.get1(spos);
                                ++spos;
                                throw H2O.unimpl();
                            }
                        }
                        String string = retstr = asciiEncoding ? retstr : this.__encodeUTF16(retstr);
                        if (richString) {
                            spos += 4 * formattingRuns;
                        }
                        if (extendedString) {
                            spos += extendedRunLength;
                        }
                        this._sst.add(retstr);
                    }
                    break;
                }
                case 47: {
                    return false;
                }
                case 24: {
                    break;
                }
                case 1054: {
                    String formatString = version == 1536 ? data.getStr(pos + 9, data.get2(pos + 6) * (data.get1(pos + 8) == '\u0000' ? 1 : 2)) : data.getStr(pos + 7, data.get1(pos + 6) * 2);
                    int indexCode = data.get2(pos + 4);
                    while (indexCode >= this._formatRecords.length) {
                        this._formatRecords = Arrays.copyOf(this._formatRecords, this._formatRecords.length << 1);
                    }
                    this._formatRecords[indexCode] = formatString;
                    break;
                }
                case 49: {
                    break;
                }
                case 146: {
                    break;
                }
                case 224: {
                    int indexCode = data.get2(pos + 6);
                    XF.Type t2 = null;
                    if (DATEFORMATS.containsKey(indexCode)) {
                        t2 = XF.Type.Date;
                    } else if (NUMBERFORMATS.containsKey(indexCode)) {
                        t2 = XF.Type.Number;
                    } else if (indexCode < this._formatRecords.length && this._formatRecords[indexCode] != null) {
                        t2 = XF.Type.Other;
                    }
                    this._xfRecords.add(new XF(indexCode, t2));
                    break;
                }
                case 34: {
                    this._nineteenFour = data.get1(pos + 4) == '\u0001';
                    break;
                }
                case 133: {
                    int recOffset = data.get4(pos + 4);
                    char recLength = data.get1(pos + 10);
                    String recName = version == 1536 ? data.getStr(pos + 12, recLength * (data.get1(pos + 11) == '\u0000' ? 1 : 2)) : data.getStr(pos + 11, recLength);
                    this._boundsheets.add(new Sheet(data, dout, recName, recOffset));
                    break;
                }
            }
            code = data.get2(pos += length + 4);
            length = data.get2(pos + 2);
        }
        for (Sheet sheet : this._boundsheets) {
            sheet.parse();
        }
        return true;
    }

    boolean isDate(Buf data, int spos) {
        int xfindex = data.get2(spos + 4);
        return this._xfRecords.get((int)xfindex)._type == XF.Type.Date;
    }

    static double _GetIEEE754(long rknum) {
        double value;
        if ((rknum & 2L) != 0L) {
            value = rknum >> 2;
        } else {
            int exp = (int)((rknum & 0x7FF00000L) >> 20);
            long mantissa = 0x100000L | rknum & 0xFFFFCL;
            value = (double)mantissa / Math.pow(2.0, 20 - (exp - 1023));
            if ((rknum & Integer.MIN_VALUE) >> 31 != 0L) {
                value *= -1.0;
            }
        }
        if ((rknum & 1L) != 0L) {
            value /= 100.0;
        }
        return value;
    }

    private String __encodeUTF16(String s2) {
        return s2;
    }

    static {
        DATEFORMATS.put(14, "m/d/Y");
        DATEFORMATS.put(15, "M-d-Y");
        DATEFORMATS.put(16, "d-M");
        DATEFORMATS.put(17, "M-Y");
        DATEFORMATS.put(18, "h:i a");
        DATEFORMATS.put(19, "h:i:s a");
        DATEFORMATS.put(20, "H:i");
        DATEFORMATS.put(21, "H:i:s");
        DATEFORMATS.put(22, "d/m/Y H:i");
        DATEFORMATS.put(45, "i:s");
        DATEFORMATS.put(46, "H:i:s");
        DATEFORMATS.put(47, "i:s.S");
        NUMBERFORMATS = new HashMap();
        NUMBERFORMATS.put(1, "0");
        NUMBERFORMATS.put(2, "0.00");
        NUMBERFORMATS.put(3, "#,##0");
        NUMBERFORMATS.put(4, "#,##0.00");
        NUMBERFORMATS.put(5, "$#,##0;($#,##0)");
        NUMBERFORMATS.put(6, "$#,##0;[Red]($#,##0)");
        NUMBERFORMATS.put(7, "$#,##0.00;($#,##0.00)");
        NUMBERFORMATS.put(8, "$#,##0.00;[Red]($#,##0.00)");
        NUMBERFORMATS.put(9, "0%");
        NUMBERFORMATS.put(10, "0.00%");
        NUMBERFORMATS.put(11, "0.00E+00");
        NUMBERFORMATS.put(37, "#,##0;(#,##0)");
        NUMBERFORMATS.put(38, "#,##0;[Red](#,##0)");
        NUMBERFORMATS.put(39, "#,##0.00;(#,##0.00)");
        NUMBERFORMATS.put(40, "#,##0.00;[Red](#,##0.00)");
        NUMBERFORMATS.put(41, "#,##0;(#,##0)");
        NUMBERFORMATS.put(42, "$#,##0;($#,##0)");
        NUMBERFORMATS.put(43, "#,##0.00;(#,##0.00)");
        NUMBERFORMATS.put(44, "$#,##0.00;($#,##0.00)");
        NUMBERFORMATS.put(48, "##0.0E+0");
    }

    private class Sheet {
        final String _name;
        final Buf _data;
        final int _offset;
        final ParseWriter _dout;
        int _numRows;
        int _numCols;
        String[] _labels;
        int _currow = 0;
        double[] _ds;

        Sheet(Buf data, ParseWriter dout, String name, int offset) {
            this._data = data;
            this._dout = dout;
            this._name = name;
            this._offset = offset;
        }

        int row(int spos) {
            int row = this._data.get2(spos);
            if (row < this._currow) {
                throw new RuntimeException("XLS file but rows running backwards");
            }
            return this.doRow(row);
        }

        int doRow(int row) {
            if (row > this._currow && this._currow == 0) {
                boolean header = true;
                for (String s2 : this._labels) {
                    header &= s2 != null;
                }
                if (header) {
                    this._dout.setColumnNames((String[])this._labels.clone());
                    Arrays.fill(this._labels, null);
                    this._currow = 1;
                }
            }
            while (this._currow < row) {
                ++this._currow;
                for (int i2 = 0; i2 < this._ds.length; ++i2) {
                    if (this._labels[i2] != null) {
                        this._dout.addStrCol(i2, new BufferedString(this._labels[i2]));
                        this._labels[i2] = null;
                        continue;
                    }
                    this._dout.addNumCol(i2, this._ds[i2]);
                    this._ds[i2] = Double.NaN;
                }
                this._dout.newLine();
            }
            return row;
        }

        boolean parse() {
            int spos = this._offset;
            int code = this._data.get2(spos);
            int length = this._data.get2(spos + 2);
            int version = this._data.get2(spos + 4);
            if (version != 1536 && version != 1280) {
                return false;
            }
            int substreamType = this._data.get2(spos + 6);
            if (substreamType != 16) {
                return false;
            }
            spos += length + 4;
            Object recType = null;
            while (true) {
                if ((code = (int)this._data.get1(spos)) != 10) {
                    code = this._data.get2(spos);
                    length = this._data.get2(spos + 2);
                    recType = null;
                    spos += 4;
                }
                switch (code) {
                    case 512: {
                        if (this._numRows != 0 || this._numCols != 0) break;
                        if (length == 10 || version == 1280) {
                            this._numRows = this._data.get2(spos + 2);
                            this._numCols = this._data.get2(spos + 6);
                        } else {
                            this._numRows = this._data.get2(spos + 4);
                            this._numCols = this._data.get2(spos + 10);
                        }
                        this._labels = new String[this._numCols];
                        this._ds = new double[this._numCols];
                        Arrays.fill(this._ds, Double.NaN);
                        break;
                    }
                    case 229: {
                        break;
                    }
                    case 126: 
                    case 638: {
                        int row = this.row(spos);
                        int col = this._data.get2(spos + 2);
                        double d2 = XlsParser._GetIEEE754(this._data.get4(spos + 6));
                        if (XlsParser.this.isDate(this._data, spos)) {
                            throw H2O.unimpl();
                        }
                        this._ds[col] = d2;
                        break;
                    }
                    case 253: {
                        int row = this.row(spos);
                        int col = this._data.get2(spos + 2);
                        int index = this._data.get4(spos + 6);
                        this._labels[col] = (String)XlsParser.this._sst.get(index);
                        break;
                    }
                    case 189: {
                        int row = this.row(spos);
                        int colFirst = this._data.get2(spos + 2);
                        int colLast = this._data.get2(spos + length - 2);
                        int columns = colLast - colFirst + 1;
                        int tmppos = spos + 4;
                        for (int i2 = 0; i2 < columns; ++i2) {
                            double numValue = XlsParser._GetIEEE754(this._data.get4(tmppos + 2));
                            if (XlsParser.this.isDate(this._data, tmppos - 4)) {
                                throw H2O.unimpl();
                            }
                            tmppos += 6;
                            this._ds[colFirst + i2] = numValue;
                        }
                        break;
                    }
                    case 515: {
                        int row = this.row(spos);
                        int col = this._data.get2(spos + 2);
                        double d3 = this._data.get8d(spos + 6);
                        if (XlsParser.this.isDate(this._data, spos)) {
                            throw H2O.unimpl();
                        }
                        this._ds[col] = d3;
                        break;
                    }
                    case 190: {
                        int row = this.row(spos);
                        int col = this._data.get2(spos + 2);
                        int cols = length / 2 - 3;
                        for (int c2 = 0; c2 < cols; ++c2) {
                            if (XlsParser.this.isDate(this._data, spos + c2 * 2)) {
                                throw H2O.unimpl();
                            }
                            this._ds[col + c2] = 0.0;
                        }
                        break;
                    }
                    case 6: 
                    case 1030: {
                        throw H2O.unimpl();
                    }
                    case 517: {
                        throw H2O.unimpl();
                    }
                    case 519: {
                        throw H2O.unimpl();
                    }
                    case 520: {
                        break;
                    }
                    case 215: {
                        break;
                    }
                    case 516: {
                        throw H2O.unimpl();
                    }
                    case 10: {
                        this.doRow(this._currow + 1);
                        return true;
                    }
                    case 440: {
                        throw H2O.unimpl();
                    }
                    case 85: {
                        break;
                    }
                    case 153: {
                        break;
                    }
                    case 125: {
                        break;
                    }
                }
                spos += length;
            }
        }
    }

    private static class XF {
        final int _indexCode;
        final Type _type;

        XF(int code, Type type) {
            this._indexCode = code;
            this._type = type;
        }

        static enum Type {
            Date,
            Number,
            Other;

        }
    }

    private static class Props {
        final String _name;
        final int _type;
        final int _startBlock;
        final int _size;

        Props(String name, int type, int startBlock, int size) {
            this._name = name;
            this._type = type;
            this._startBlock = startBlock;
            this._size = size;
        }
    }

    private class Buf {
        final byte[] _buf;
        byte[] _bbuf;
        int _off;
        int _lim;

        Buf(byte[] buf, int off, int size) throws IOException {
            this._bbuf = buf;
            this._buf = buf;
            this._off = off;
            this._lim = off + size;
            XlsParser.this.readAtLeast(this._lim);
        }

        Buf(Buf B2, int off, int size) {
            this._bbuf = B2._bbuf;
            this._buf = B2._bbuf;
            this._off = off;
            this._lim = off + size;
            assert (this._lim <= this._buf.length);
        }

        void concat(int off, int size) throws IOException {
            XlsParser.this.readAtLeast(off + size);
            if (this._off == this._lim) {
                this._off = off;
                this._lim = off + size;
                return;
            }
            if (off == this._lim) {
                this._lim += size;
                return;
            }
            this._bbuf = Arrays.copyOfRange(this._bbuf, this._off, this._lim + size);
            this._lim = this._lim - this._off + size;
            this._off = 0;
            System.arraycopy(this._buf, off, this._bbuf, this._lim - size, size);
        }

        char get1(int pos) {
            assert (this._off + pos + 1 < this._lim);
            return (char)this._bbuf[this._off + pos];
        }

        int get2(int pos) {
            assert (this._off + pos + 2 < this._lim);
            return UnsafeUtils.get2(this._bbuf, this._off + pos);
        }

        int get4(int pos) {
            assert (this._off + pos + 4 < this._lim);
            return UnsafeUtils.get4(this._bbuf, this._off + pos);
        }

        double get8d(int pos) {
            assert (this._off + pos + 8 < this._lim);
            return UnsafeUtils.get8d(this._bbuf, this._off + pos);
        }

        String getStr(int pos, int len) {
            return new String(this._bbuf, this._off + pos, len);
        }
    }
}

