/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import water.Futures;
import water.H2O;
import water.Iced;
import water.parser.BufferedString;
import water.parser.ParseDataset;
import water.parser.ParseTime;
import water.parser.ParseUUID;
import water.parser.ParseWriter;
import water.parser.StreamParseWriter;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.PrettyPrint;

public class PreviewParseWriter
extends Iced
implements StreamParseWriter {
    protected static final int MAX_PREVIEW_COLS = 100;
    protected static final int MAX_PREVIEW_LINES = 10;
    protected int _nlines;
    protected int _ncols;
    protected int _invalidLines;
    private String[] _colNames;
    protected String[][] _data = new String[10][];
    private IcedHashMap<String, String>[] _domains;
    int[] _nnums;
    int[] _nstrings;
    int[] _ndates;
    int[] _nUUID;
    int[] _nzeros;
    int[] _nempty;
    protected ParseWriter.ParseErr[] _errs = new ParseWriter.ParseErr[0];

    protected PreviewParseWriter() {
    }

    protected PreviewParseWriter(int ncols) {
        this.setColumnCount(ncols);
    }

    String[] colNames() {
        return this._colNames;
    }

    @Override
    public void setColumnNames(String[] names) {
        this._colNames = names;
        this._data[0] = names;
        ++this._nlines;
        this.setColumnCount(names.length);
    }

    private void setColumnCount(int n2) {
        if (this._ncols == 0 && n2 > 0) {
            int i2;
            this._ncols = n2;
            this._nzeros = new int[n2];
            this._nstrings = new int[n2];
            this._nUUID = new int[n2];
            this._ndates = new int[n2];
            this._nnums = new int[n2];
            this._nempty = new int[n2];
            this._domains = new IcedHashMap[n2];
            for (i2 = 0; i2 < n2; ++i2) {
                this._domains[i2] = new IcedHashMap();
            }
            for (i2 = 0; i2 < 10; ++i2) {
                this._data[i2] = new String[n2];
            }
        }
    }

    @Override
    public void newLine() {
        ++this._nlines;
    }

    @Override
    public boolean isString(int colIdx) {
        return false;
    }

    @Override
    public void addNumCol(int colIdx, long number, int exp) {
        if (colIdx < this._ncols) {
            if (number == 0L) {
                int n2 = colIdx;
                this._nzeros[n2] = this._nzeros[n2] + 1;
            } else {
                int n3 = colIdx;
                this._nnums[n3] = this._nnums[n3] + 1;
            }
            if (this._nlines < 10) {
                this._data[this._nlines][colIdx] = Double.toString(PrettyPrint.pow10(number, exp));
            }
        }
    }

    @Override
    public void addNumCol(int colIdx, double d2) {
        if (colIdx < this._ncols) {
            if (d2 == 0.0) {
                int n2 = colIdx;
                this._nzeros[n2] = this._nzeros[n2] + 1;
            } else {
                int n3 = colIdx;
                this._nnums[n3] = this._nnums[n3] + 1;
            }
            if (this._nlines < 10) {
                this._data[this._nlines][colIdx] = Double.toString(d2);
            }
        }
    }

    @Override
    public void addInvalidCol(int colIdx) {
        if (colIdx < this._ncols) {
            int n2 = colIdx;
            this._nempty[n2] = this._nempty[n2] + 1;
            if (this._nlines < 10) {
                this._data[this._nlines][colIdx] = "NA";
            }
        }
    }

    @Override
    public void addNAs(int colIdx, int nrow) {
        throw H2O.unimpl();
    }

    @Override
    public void addStrCol(int colIdx, BufferedString str) {
        if (colIdx < this._ncols) {
            if (ParseTime.isTime(str)) {
                int n2 = colIdx;
                this._ndates[n2] = this._ndates[n2] + 1;
                return;
            }
            if (ParseUUID.isUUID(str)) {
                int n3 = colIdx;
                this._nUUID[n3] = this._nUUID[n3] + 1;
                return;
            }
            int n4 = colIdx;
            this._nstrings[n4] = this._nstrings[n4] + 1;
            this._domains[colIdx].put(str.toString(), "");
            if (this._nlines < 10) {
                this._data[this._nlines][colIdx] = str.toString();
            }
        }
    }

    @Override
    public void rollbackLine() {
        --this._nlines;
    }

    @Override
    public void setIsAllASCII(int colIdx, boolean b2) {
    }

    public byte[] guessTypes() {
        byte[] types = new byte[this._ncols];
        for (int i2 = 0; i2 < this._ncols; ++i2) {
            final IcedHashMap<String, String> sourceDomain = this._domains[i2];
            IDomain domain = new IDomain(){

                @Override
                public int size() {
                    return sourceDomain.size();
                }

                @Override
                public boolean contains(String value) {
                    return sourceDomain.containsKey(value);
                }
            };
            types[i2] = PreviewParseWriter.guessType(this._nlines, this._nnums[i2], this._nstrings[i2], this._ndates[i2], this._nUUID[i2], this._nzeros[i2], this._nempty[i2], domain);
        }
        return types;
    }

    public static byte guessType(int nlines, int nnums, int nstrings, int ndates, int nUUID, int nzeros, int nempty, IDomain domain) {
        int nonemptyLines = nlines - nempty - 1;
        if (nnums + nzeros >= ndates && nnums + nzeros >= nUUID && nnums >= nstrings) {
            return 3;
        }
        if (domain.size() == 1 && ndates == 0) {
            return (byte)(domain.contains("NA") || domain.contains("na") || domain.contains("Na") || domain.contains("N/A") || nstrings < nnums + nzeros ? 3 : 4);
        }
        if (domain.size() <= 1 && nnums + nzeros > ndates + nUUID) {
            return 3;
        }
        if (ndates > nUUID && ndates > nnums + nzeros && (ndates > nstrings || domain.size() <= 1)) {
            return 5;
        }
        if (nUUID > ndates && nUUID > nnums + nzeros && (nUUID > nstrings || domain.size() <= 1)) {
            return 1;
        }
        if (nstrings > ndates && nstrings > nUUID && nstrings > nnums + nzeros && (double)domain.size() >= 0.95 * (double)nstrings) {
            return 2;
        }
        if (nzeros > 0 && nzeros + nstrings >= nonemptyLines && (double)domain.size() <= 0.95 * (double)nstrings) {
            return 4;
        }
        if (nstrings >= nnums + nzeros && (double)domain.size() <= 0.95 * (double)nstrings) {
            return 4;
        }
        return 3;
    }

    public String[][] guessNAStrings(byte[] types) {
        String[][] naStrings = new String[this._ncols][];
        boolean empty = true;
        for (int i2 = 0; i2 < this._ncols; ++i2) {
            int nonemptyLines = this._nlines - this._nempty[i2] - 1;
            if (types[i2] != 4 || this._nzeros[i2] <= 0 || this._nzeros[i2] + this._nstrings[i2] < nonemptyLines || !((double)this._domains[i2].size() <= 0.95 * (double)this._nstrings[i2])) continue;
            naStrings[i2] = new String[1];
            naStrings[i2][0] = "0";
            empty = false;
        }
        if (empty) {
            return null;
        }
        return naStrings;
    }

    public static PreviewParseWriter unifyColumnPreviews(PreviewParseWriter prevA, PreviewParseWriter prevB) {
        if (prevA == null) {
            return prevB;
        }
        if (prevB == null) {
            return prevA;
        }
        if (prevA._ncols != prevB._ncols) {
            throw new ParseDataset.H2OParseException("Files conflict in number of columns. " + prevA._ncols + " vs. " + prevB._ncols + ".");
        }
        prevA._nlines += prevB._nlines;
        prevA._invalidLines += prevB._invalidLines;
        for (int i2 = 0; i2 < prevA._ncols; ++i2) {
            int n2 = i2;
            prevA._nnums[n2] = prevA._nnums[n2] + prevB._nnums[i2];
            int n3 = i2;
            prevA._nstrings[n3] = prevA._nstrings[n3] + prevB._nstrings[i2];
            int n4 = i2;
            prevA._ndates[n4] = prevA._ndates[n4] + prevB._ndates[i2];
            int n5 = i2;
            prevA._nUUID[n5] = prevA._nUUID[n5] + prevB._nUUID[i2];
            int n6 = i2;
            prevA._nzeros[n6] = prevA._nzeros[n6] + prevB._nzeros[i2];
            int n7 = i2;
            prevA._nempty[n7] = prevA._nempty[n7] + prevB._nempty[i2];
            if (prevA._domains[i2] != null) {
                if (prevB._domains[i2] == null) continue;
                for (String s2 : prevB._domains[i2].keySet()) {
                    prevA._domains[i2].put(s2, "");
                }
                continue;
            }
            if (prevB._domains[i2] == null) continue;
            prevA._domains = prevB._domains;
        }
        return prevA;
    }

    @Override
    public void invalidLine(ParseWriter.ParseErr err) {
        this.addError(err);
        ++this._invalidLines;
    }

    @Override
    public void addError(ParseWriter.ParseErr err) {
        if (this._errs == null) {
            this._errs = new ParseWriter.ParseErr[]{err};
        } else if (this._errs.length < 20) {
            this._errs = ArrayUtils.append(this._errs, err);
        }
    }

    @Override
    public boolean hasErrors() {
        return this._errs != null && this._errs.length > 0;
    }

    @Override
    public ParseWriter.ParseErr[] removeErrors() {
        return this._errs;
    }

    @Override
    public long lineNum() {
        return this._nlines;
    }

    @Override
    public StreamParseWriter nextChunk() {
        throw H2O.unimpl();
    }

    @Override
    public StreamParseWriter reduce(StreamParseWriter dout) {
        throw H2O.unimpl();
    }

    @Override
    public StreamParseWriter close() {
        return this;
    }

    @Override
    public StreamParseWriter close(Futures fs) {
        return this;
    }

    public static interface IDomain {
        public int size();

        public boolean contains(String var1);
    }
}

