/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.fvec.Vec;
import water.parser.DefaultParserProviders;
import water.parser.ParseReader;
import water.parser.ParseSetup;
import water.parser.ParseWriter;
import water.parser.StreamParseWriter;
import water.parser.ZipUtil;

public abstract class Parser
extends Iced {
    static final byte CHAR_TAB = 9;
    static final byte CHAR_CR = 13;
    static final byte CHAR_LF = 10;
    static final byte CHAR_SPACE = 32;
    static final byte CHAR_DOUBLE_QUOTE = 34;
    static final byte CHAR_SINGLE_QUOTE = 39;
    protected static final byte SKIP_LINE = 0;
    protected static final byte EXPECT_COND_LF = 1;
    protected static final byte EOL = 2;
    protected static final byte TOKEN = 3;
    protected static final byte COND_QUOTED_TOKEN = 4;
    protected static final byte NUMBER = 5;
    protected static final byte NUMBER_SKIP = 6;
    protected static final byte NUMBER_SKIP_NO_DOT = 7;
    protected static final byte NUMBER_FRACTION = 8;
    protected static final byte NUMBER_EXP = 9;
    protected static final byte NUMBER_EXP_START = 11;
    protected static final byte NUMBER_END = 12;
    protected static final byte STRING = 13;
    protected static final byte COND_QUOTE = 14;
    protected static final byte SEPARATOR_OR_EOL = 15;
    protected static final byte WHITESPACE_BEFORE_TOKEN = 16;
    protected static final byte STRING_END = 17;
    protected static final byte COND_QUOTED_NUMBER_END = 18;
    protected static final byte POSSIBLE_EMPTY_LINE = 19;
    protected static final byte POSSIBLE_CURRENCY = 20;
    protected static final byte HASHTAG = 35;
    protected static final byte POSSIBLE_ESCAPED_QUOTE = 36;
    protected final byte CHAR_DECIMAL_SEP = (byte)46;
    protected final byte CHAR_SEPARATOR;
    protected final byte CHAR_ESCAPE;
    protected static final long LARGEST_DIGIT_NUMBER = 0xCCCCCCCCCCCCCCCL;
    public boolean[] _keepColumns;
    protected final ParseSetup _setup;
    protected final Key<Job> _jobKey;

    protected static boolean isEOL(byte c2) {
        return c2 == 10 || c2 == 13;
    }

    protected Parser(ParseSetup setup, Key<Job> jobKey) {
        this._setup = setup;
        this.CHAR_SEPARATOR = setup._separator;
        this._jobKey = jobKey;
        this.CHAR_ESCAPE = setup._escapechar;
        if (this._setup != null && this._setup._number_columns > 0) {
            this._keepColumns = new boolean[this._setup._number_columns];
            for (int colIdx = 0; colIdx < this._setup._number_columns; ++colIdx) {
                this._keepColumns[colIdx] = true;
            }
            if (this._setup._skipped_columns != null) {
                for (int colIdx : this._setup._skipped_columns) {
                    if (colIdx >= this._setup._number_columns) {
                        throw new IllegalArgumentException("Skipped column index " + colIdx + " is illegal.  It exceeds the actual number of columns in your file.");
                    }
                    this._keepColumns[colIdx] = false;
                }
            }
        }
    }

    protected int fileHasHeader(byte[] bits, ParseSetup ps) {
        return -1;
    }

    protected abstract ParseWriter parseChunk(int var1, ParseReader var2, ParseWriter var3);

    protected StreamParseWriter sequentialParse(Vec vec, StreamParseWriter dout) {
        throw new UnsupportedOperationException("Sequential Parsing is not supported by " + this.getClass().getName());
    }

    protected ParseWriter streamParse(InputStream is, StreamParseWriter dout) throws IOException {
        return this.streamParseZip(is, dout, is);
    }

    private boolean checkFileNHeader(InputStream is, StreamParseWriter dout, StreamData din, int cidx) throws IOException {
        byte[] headerBytes = ZipUtil.unzipForHeader(din.getChunkData(cidx), this._setup._chunk_size);
        ParseSetup ps = ParseSetup.guessSetup(null, headerBytes, new ParseSetup(DefaultParserProviders.GUESS_INFO, -1, this._setup._single_quotes, 0, -1, null, null));
        if (this._setup._number_columns != ps._number_columns || this._setup._separator != ps._separator) {
            String warning = "Your zip file contains a file that belong to another dataset with different number of column or separator.  Number of columns for files that have been parsed = " + this._setup._number_columns + ".  Number of columns in new file = " + ps._number_columns + ".  This new file is skipped and not parsed.";
            dout.addError(new ParseWriter.ParseErr(warning, -1, -1L, -2L));
            return false;
        }
        if (ps._check_header == 1) {
            if (this._setup._column_names != null) {
                String[] thisColumnName = this._setup.getColumnNames();
                String[] psColumnName = ps.getColumnNames();
                Boolean sameColumnNames = true;
                for (int index = 0; index < this._setup._number_columns; ++index) {
                    if (thisColumnName[index].equals(psColumnName[index])) continue;
                    sameColumnNames = false;
                    break;
                }
                if (sameColumnNames.booleanValue()) {
                    this._setup.setCheckHeader(ps._check_header);
                }
            }
        } else {
            this._setup.setCheckHeader(ps._check_header);
        }
        return true;
    }

    private void getNextFile(InputStream is) throws IOException {
        if (is instanceof ZipInputStream) {
            ZipEntry ze = ((ZipInputStream)is).getNextEntry();
            while (ze != null && ze.isDirectory()) {
                ze = ((ZipInputStream)is).getNextEntry();
            }
        }
    }

    private StreamInfo readOneFile(InputStream is, StreamParseWriter dout, InputStream bvs, StreamParseWriter nextChunk, int zidx, int fileIndex) throws IOException {
        int cidx = 0;
        StreamData din = new StreamData(is);
        if (fileIndex > 0 && !this.checkFileNHeader(is, dout, din, cidx)) {
            return new StreamInfo(zidx, nextChunk);
        }
        int streamAvailable = is.available();
        while (streamAvailable > 0) {
            this.parseChunk(cidx++, din, nextChunk);
            streamAvailable = is.available();
            int xidx = bvs.read(null, 0, 0);
            if (xidx <= zidx) continue;
            zidx = xidx;
            nextChunk.close();
            if (dout != nextChunk) {
                dout.reduce(nextChunk);
                if (this._jobKey != null && this._jobKey.get().stop_requested()) break;
            }
            nextChunk = nextChunk.nextChunk();
        }
        this.parseChunk(cidx, din, nextChunk);
        return new StreamInfo(zidx, nextChunk);
    }

    protected ParseWriter streamParseZip(InputStream is, StreamParseWriter dout, InputStream bvs) throws IOException {
        if (!this._setup._parse_type.isParallelParseSupported) {
            throw H2O.unimpl();
        }
        StreamParseWriter nextChunk = dout;
        int zidx = bvs.read(null, 0, 0);
        assert (zidx == 1);
        int fileIndex = 0;
        StreamInfo streamInfo = new StreamInfo(zidx, nextChunk);
        while (is.available() > 0) {
            streamInfo = this.readOneFile(is, dout, bvs, streamInfo._nextChunk, streamInfo._zidx, fileIndex++);
            if (is.available() > 0) continue;
            this.getNextFile(is);
        }
        streamInfo._nextChunk.close();
        bvs.close();
        is.close();
        if (dout != nextChunk) {
            dout.reduce(nextChunk);
        }
        return dout;
    }

    static final class StreamData
    implements ParseReader {
        final int bufSz;
        final transient InputStream _is;
        private byte[] _bits0;
        private byte[] _bits1;
        private int _cidx0 = -1;
        private int _cidx1 = -1;
        private int _coff0 = -1;
        private int _coff1 = -1;
        long _gOff;

        protected StreamData(InputStream is) {
            this(is, 65536);
        }

        protected StreamData(InputStream is, int bufSz) {
            this._is = is;
            this.bufSz = bufSz;
            this._bits0 = new byte[bufSz];
            this._bits1 = new byte[bufSz];
        }

        @Override
        public byte[] getChunkData(int cidx) {
            byte[] bits2;
            int off;
            if (cidx == this._cidx0) {
                return this._bits0;
            }
            this._gOff = this._bits0.length;
            if (cidx == this._cidx1) {
                return this._bits1;
            }
            assert (cidx == this._cidx0 + 1 || cidx == this._cidx1 + 1);
            byte[] bits = this._cidx0 < this._cidx1 ? this._bits0 : this._bits1;
            this._gOff += (long)bits.length;
            if (this._cidx0 < this._cidx1) {
                this._cidx0 = cidx;
                this._coff0 = -1;
            } else {
                this._cidx1 = cidx;
                this._coff1 = -1;
            }
            try {
                int len;
                for (off = 0; off < bits.length && (len = this._is.read(bits, off, bits.length - off)) != -1; off += len) {
                }
                assert (off == bits.length || this._is.available() <= 0);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            if (off == bits.length) {
                return bits;
            }
            byte[] byArray = bits2 = off == 0 ? null : Arrays.copyOf(bits, off);
            if (this._cidx0 == cidx) {
                this._bits0 = bits2;
            } else {
                this._bits1 = bits2;
            }
            return bits2;
        }

        @Override
        public int getChunkDataStart(int cidx) {
            if (this._cidx0 == cidx) {
                return this._coff0;
            }
            if (this._cidx1 == cidx) {
                return this._coff1;
            }
            return 0;
        }

        @Override
        public void setChunkDataStart(int cidx, int offset) {
            if (this._cidx0 == cidx) {
                this._coff0 = offset;
            }
            if (this._cidx1 == cidx) {
                this._coff1 = offset;
            }
        }

        @Override
        public long getGlobalByteOffset() {
            return 0L;
        }
    }

    static final class ByteAryData
    implements ParseReader {
        private final byte[] _bits;
        public int _off;
        final long _globalOffset;

        public ByteAryData(byte[] bits, long globalOffset) {
            this._bits = bits;
            this._globalOffset = globalOffset;
        }

        @Override
        public byte[] getChunkData(int cidx) {
            return cidx == 0 ? this._bits : null;
        }

        @Override
        public int getChunkDataStart(int cidx) {
            return -1;
        }

        @Override
        public void setChunkDataStart(int cidx, int offset) {
            if (cidx == 0) {
                this._off = offset;
            }
        }

        @Override
        public long getGlobalByteOffset() {
            return this._globalOffset;
        }
    }

    private class StreamInfo {
        int _zidx;
        StreamParseWriter _nextChunk;

        StreamInfo(int zidx, StreamParseWriter nextChunk) {
            this._zidx = zidx;
            this._nextChunk = nextChunk;
        }
    }
}

