/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import water.MemoryManager;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.StringUtils;

public class PackedDomains {
    public static int sizeOf(byte[] domain) {
        return ArrayUtils.encodeAsInt(domain, 0);
    }

    public static String[] unpackToStrings(byte[] domain) {
        int n2 = PackedDomains.sizeOf(domain);
        String[] out = new String[n2];
        int pos = 4;
        for (int i2 = 0; i2 < n2; ++i2) {
            int len = ArrayUtils.encodeAsInt(domain, pos);
            out[i2] = StringUtils.toString(domain, pos += 4, len);
            pos += len;
        }
        return out;
    }

    public static byte[] pack(BufferedString[] source) {
        int len = 0;
        for (BufferedString bs : source) {
            len += bs.length();
        }
        byte[] data = new byte[len + (source.length + 1) * 4];
        ArrayUtils.decodeAsInt(source.length, data, 0);
        int pos = 4;
        for (BufferedString bs : source) {
            byte[] buff = bs.getBuffer();
            ArrayUtils.decodeAsInt(bs.length(), data, pos);
            pos += 4;
            for (int i2 = bs.getOffset(); i2 < bs.getOffset() + bs.length(); ++i2) {
                data[pos++] = buff[i2];
            }
        }
        return data;
    }

    static int calcMergedSize(byte[] as, byte[] bs) {
        int shared = 0;
        int pA = 4;
        int pB = 4;
        BufferedString bsA = new BufferedString(as, 0, 0);
        BufferedString bsB = new BufferedString(bs, 0, 0);
        while (pA < as.length && pB < bs.length) {
            int sizeA = ArrayUtils.encodeAsInt(as, pA);
            bsA.setOff(pA + 4);
            bsA.setLen(sizeA);
            int sizeB = ArrayUtils.encodeAsInt(bs, pB);
            bsB.setOff(pB + 4);
            bsB.setLen(sizeB);
            int x2 = bsA.compareTo(bsB);
            if (x2 < 0) {
                pA += sizeA + 4;
                continue;
            }
            if (x2 > 0) {
                pB += sizeB + 4;
                continue;
            }
            shared += sizeA + 4;
            pA += sizeA + 4;
            pB += sizeA + 4;
        }
        return as.length + bs.length - 4 - shared;
    }

    public static byte[] merge(byte[] as, byte[] bs) {
        int size = PackedDomains.calcMergedSize(as, bs);
        if (size == as.length) {
            return as;
        }
        if (size == bs.length) {
            return bs;
        }
        byte[] data = MemoryManager.malloc1(size);
        int shared = 0;
        int pos = 4;
        int pA = 4;
        int pB = 4;
        while (pA < as.length && pB < bs.length) {
            int wordPos = pos;
            pos += 4;
            int wA = pA;
            int sizeA = ArrayUtils.encodeAsInt(as, pA);
            int endA = (pA += 4) + sizeA;
            int wB = pB;
            int sizeB = ArrayUtils.encodeAsInt(bs, pB);
            int endB = (pB += 4) + sizeB;
            int l2 = sizeA > sizeB ? sizeB : sizeA;
            int comp = sizeA - sizeB;
            for (int i2 = 0; i2 < l2; ++i2) {
                int x2 = (0xFF & as[pA]) - (0xFF & bs[pB]);
                if (x2 != 0) {
                    comp = x2;
                    break;
                }
                data[pos++] = as[pA++];
                ++pB;
            }
            if (pA == endA && pB == endB) {
                ArrayUtils.decodeAsInt(sizeA, data, wordPos);
                ++shared;
                continue;
            }
            if (comp < 0) {
                while (pA < endA) {
                    data[pos++] = as[pA++];
                }
                ArrayUtils.decodeAsInt(sizeA, data, wordPos);
                pB = wB;
                continue;
            }
            while (pB < endB) {
                data[pos++] = bs[pB++];
            }
            ArrayUtils.decodeAsInt(sizeB, data, wordPos);
            pA = wA;
        }
        while (pA < as.length) {
            data[pos++] = as[pA++];
        }
        while (pB < bs.length) {
            data[pos++] = bs[pB++];
        }
        int len = ArrayUtils.encodeAsInt(as, 0) + ArrayUtils.encodeAsInt(bs, 0) - shared;
        ArrayUtils.decodeAsInt(len, data, 0);
        return data;
    }
}

