/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import water.H2ORuntime;
import water.MemoryManager;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.Timer;

public class MemoryBandwidth {
    public static void main(String[] args) {
        int num_threads = H2ORuntime.availableProcessors();
        double membw = MemoryBandwidth.run(num_threads);
        Log.info("Memory bandwidth (" + num_threads + " cores) : " + membw + " GB/s.");
    }

    public static double run(int num_threads) {
        int t2;
        final double[] membw = new double[num_threads];
        Thread[] threads = new Thread[num_threads];
        for (t2 = 0; t2 < num_threads; ++t2) {
            final int thread_num = t2;
            threads[t2] = new Thread(){

                @Override
                public void run() {
                    MemoryBandwidth l2 = new MemoryBandwidth();
                    membw[thread_num] = l2.run_benchmark();
                }
            };
        }
        for (t2 = 0; t2 < num_threads; ++t2) {
            threads[t2].start();
        }
        for (t2 = 0; t2 < num_threads; ++t2) {
            try {
                threads[t2].join();
                continue;
            }
            catch (InterruptedException e2) {
                Thread.currentThread().interrupt();
            }
        }
        return ArrayUtils.sum(membw);
    }

    double run_benchmark() {
        long M2 = Math.min(10000000L, Runtime.getRuntime().maxMemory() / 10L);
        int[] vals = MemoryManager.malloc4((int)M2);
        int repeats = 20;
        Timer timer = new Timer();
        long sum = 0L;
        for (int l2 = repeats - 1; l2 >= 0; --l2) {
            int i2 = 0;
            while ((long)i2 < M2) {
                vals[i2] = i2 + l2;
                ++i2;
            }
            sum = 0L;
            i2 = 0;
            while ((long)i2 < M2) {
                sum += (long)vals[i2];
                ++i2;
            }
        }
        double total = (double)timer.time() / 1000.0 / (double)repeats;
        double time = total + (double)(M2 * (M2 - 1L) / 2L - sum);
        return 2.0 * (double)M2 * 4.0 / time;
    }
}

