/*
 * Decompiled with CFR 0.152.
 */
package water.hive;

import java.io.IOException;
import java.io.PrintWriter;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import water.hive.DelegationTokenPrinter;
import water.hive.HiveTokenGenerator;
import water.hive.ImpersonationUtils;

public class GenerateHiveToken
extends Configured
implements Tool {
    private String runAsUser = null;
    private String principal = null;
    private String keytabPath = null;
    private String hiveJdbcUrlPattern = null;
    private String hiveHost = null;
    private String hivePrincipal = null;
    private String tokenFile = null;

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new GenerateHiveToken(), (String[])args);
        System.exit(exitCode);
    }

    private void usage() {
        System.out.println("Usage:");
        System.exit(1);
    }

    private void parseArgs(String[] args) {
        for (int i2 = 0; i2 < args.length; ++i2) {
            String s2 = args[i2];
            if (s2.equals("-run_as_user")) {
                if (++i2 >= args.length) {
                    this.usage();
                }
                this.runAsUser = args[i2];
                continue;
            }
            if (s2.equals("-principal")) {
                if (++i2 >= args.length) {
                    this.usage();
                }
                this.principal = args[i2];
                continue;
            }
            if (s2.equals("-keytab")) {
                if (++i2 >= args.length) {
                    this.usage();
                }
                this.keytabPath = args[i2];
                continue;
            }
            if (s2.equals("-hiveJdbcUrlPattern")) {
                if (++i2 >= args.length) {
                    this.usage();
                }
                this.hiveJdbcUrlPattern = args[i2];
                continue;
            }
            if (s2.equals("-hiveHost")) {
                if (++i2 >= args.length) {
                    this.usage();
                }
                this.hiveHost = args[i2];
                continue;
            }
            if (s2.equals("-hivePrincipal")) {
                if (++i2 >= args.length) {
                    this.usage();
                }
                this.hivePrincipal = args[i2];
                continue;
            }
            if (s2.equals("-tokenFile")) {
                if (++i2 >= args.length) {
                    this.usage();
                }
                this.tokenFile = args[i2];
                continue;
            }
            System.err.println("Unrecognized option " + s2);
            System.exit(1);
        }
    }

    private void validateArgs() {
        ImpersonationUtils.validateImpersonationArgs(this.principal, this.keytabPath, this.runAsUser, this::error, this::warning);
        if (this.hivePrincipal == null) {
            this.error("hive principal name is required (use the '-hivePrincipal' option)");
        }
        if (this.hiveHost == null && this.hiveJdbcUrlPattern == null) {
            this.error("delegation token generator requires Hive host or JDBC URL to be set (use the '-hiveHost' or '-hiveJdbcUrlPattern' option)");
        }
        if (this.tokenFile == null) {
            this.error("token file path required (use the '-tokenFile' option)");
        }
        if (!HiveTokenGenerator.isHiveDriverPresent()) {
            this.error("Hive JDBC driver not available on class-path");
        }
    }

    public int run(String[] args) throws IOException, InterruptedException {
        this.parseArgs(args);
        this.validateArgs();
        ImpersonationUtils.impersonate(this.getConf(), this.principal, this.keytabPath, this.runAsUser);
        String token = HiveTokenGenerator.getHiveDelegationTokenIfHivePresent(this.hiveJdbcUrlPattern, this.hiveHost, this.hivePrincipal);
        if (token != null) {
            DelegationTokenPrinter.printToken(token);
            System.out.println("Token generated, writing into file " + this.tokenFile);
            try (PrintWriter pw = new PrintWriter(this.tokenFile);){
                pw.print(token);
            }
            return 0;
        }
        System.out.println("No token generated.");
        return 1;
    }

    private void error(String s2) {
        System.err.printf("\nERROR: %s\n\n", s2);
        this.usage();
    }

    private void warning(String s2) {
        System.err.printf("\nWARNING: %s\n\n", s2);
    }
}

