/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.C1Chunk;
import water.fvec.C1NChunk;
import water.fvec.C1SChunk;
import water.fvec.C2Chunk;
import water.fvec.C2SChunk;
import water.fvec.C4Chunk;
import water.fvec.C4FChunk;
import water.fvec.C4SChunk;
import water.fvec.C8Chunk;
import water.fvec.C8DChunk;
import water.fvec.Chunk;
import water.fvec.RollupStats;

public class RollupStatsHelpers {
    private final RollupStats _rs;

    RollupStatsHelpers(RollupStats rs) {
        this._rs = rs;
    }

    public long numericChunkRollup(Chunk c2, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = this._rs._isInt;
        boolean hasNA = c2.hasNA();
        boolean hasFloat = c2.hasFloat();
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int i2 = c2.nextNZ(-1);
        while (i2 < c2._len) {
            if (hasNA && c2.isNA(i2)) {
                ++naCnt;
            } else {
                long l2;
                double x2 = c2.atd(i2);
                long l3 = l2 = hasFloat ? Double.doubleToRawLongBits(x2) : c2.at8(i2);
                if (l2 != 0L) {
                    checksum ^= 17L * (start + (long)i2) ^ 23L * l2;
                }
                if (x2 == Double.POSITIVE_INFINITY) {
                    ++pinfs;
                } else if (x2 == Double.NEGATIVE_INFINITY) {
                    ++ninfs;
                } else {
                    if (x2 != 0.0) {
                        ++nzCnt;
                    }
                    if (x2 < dmin) {
                        dmin = this._rs.min(x2);
                    }
                    if (x2 > dmax) {
                        dmax = this._rs.max(x2);
                    }
                    if (isInt) {
                        isInt = (double)((long)x2) == x2;
                    }
                    double delta = x2 - mean;
                    M2 += delta * (x2 - (mean += delta / (double)(++rows)));
                }
            }
            i2 = c2.nextNZ(i2);
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C1Chunk c2, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = true;
        boolean hasNA = true;
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c2._len;
        for (int i2 = 0; i2 < len; ++i2) {
            if (hasNA && c2.isNA(i2)) {
                ++naCnt;
                continue;
            }
            long l2 = c2.at8(i2);
            double x2 = l2;
            if (l2 != 0L) {
                checksum ^= 17L * (start + (long)i2) ^ 23L * l2;
            }
            if (x2 != 0.0) {
                ++nzCnt;
            }
            if (x2 < dmin) {
                dmin = this._rs.min(x2);
            }
            if (x2 > dmax) {
                dmax = this._rs.max(x2);
            }
            double delta = x2 - mean;
            M2 += delta * (x2 - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C1NChunk c2, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = true;
        boolean hasNA = false;
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c2._len;
        for (int i2 = 0; i2 < len; ++i2) {
            if (hasNA && c2.isNA(i2)) {
                ++naCnt;
                continue;
            }
            long l2 = c2.at8(i2);
            double x2 = l2;
            if (l2 != 0L) {
                checksum ^= 17L * (start + (long)i2) ^ 23L * l2;
            }
            if (x2 != 0.0) {
                ++nzCnt;
            }
            if (x2 < dmin) {
                dmin = this._rs.min(x2);
            }
            if (x2 > dmax) {
                dmax = this._rs.max(x2);
            }
            double delta = x2 - mean;
            M2 += delta * (x2 - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C1SChunk c2, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = this._rs._isInt;
        boolean hasNA = c2.hasNA();
        boolean hasFloat = c2.hasFloat();
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c2._len;
        for (int i2 = 0; i2 < len; ++i2) {
            long l2;
            if (hasNA && c2.isNA(i2)) {
                ++naCnt;
                continue;
            }
            double x2 = c2.atd(i2);
            long l3 = l2 = hasFloat ? Double.doubleToRawLongBits(x2) : c2.at8(i2);
            if (l2 != 0L) {
                checksum ^= 17L * (start + (long)i2) ^ 23L * l2;
            }
            if (x2 == Double.POSITIVE_INFINITY) {
                ++pinfs;
                continue;
            }
            if (x2 == Double.NEGATIVE_INFINITY) {
                ++ninfs;
                continue;
            }
            if (x2 != 0.0) {
                ++nzCnt;
            }
            if (x2 < dmin) {
                dmin = this._rs.min(x2);
            }
            if (x2 > dmax) {
                dmax = this._rs.max(x2);
            }
            if (isInt) {
                isInt = (double)((long)x2) == x2;
            }
            double delta = x2 - mean;
            M2 += delta * (x2 - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C2Chunk c2, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = true;
        boolean hasNA = true;
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c2._len;
        for (int i2 = 0; i2 < len; ++i2) {
            if (hasNA && c2.isNA(i2)) {
                ++naCnt;
                continue;
            }
            long l2 = c2.at8(i2);
            double x2 = l2;
            if (l2 != 0L) {
                checksum ^= 17L * (start + (long)i2) ^ 23L * l2;
            }
            if (x2 != 0.0) {
                ++nzCnt;
            }
            if (x2 < dmin) {
                dmin = this._rs.min(x2);
            }
            if (x2 > dmax) {
                dmax = this._rs.max(x2);
            }
            double delta = x2 - mean;
            M2 += delta * (x2 - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C2SChunk c2, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = this._rs._isInt;
        boolean hasNA = c2.hasNA();
        boolean hasFloat = c2.hasFloat();
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c2._len;
        for (int i2 = 0; i2 < len; ++i2) {
            long l2;
            if (hasNA && c2.isNA(i2)) {
                ++naCnt;
                continue;
            }
            double x2 = c2.atd(i2);
            long l3 = l2 = hasFloat ? Double.doubleToRawLongBits(x2) : c2.at8(i2);
            if (l2 != 0L) {
                checksum ^= 17L * (start + (long)i2) ^ 23L * l2;
            }
            if (x2 == Double.POSITIVE_INFINITY) {
                ++pinfs;
                continue;
            }
            if (x2 == Double.NEGATIVE_INFINITY) {
                ++ninfs;
                continue;
            }
            if (x2 != 0.0) {
                ++nzCnt;
            }
            if (x2 < dmin) {
                dmin = this._rs.min(x2);
            }
            if (x2 > dmax) {
                dmax = this._rs.max(x2);
            }
            if (isInt) {
                isInt = (double)((long)x2) == x2;
            }
            double delta = x2 - mean;
            M2 += delta * (x2 - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C4Chunk c2, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = true;
        boolean hasNA = true;
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c2._len;
        for (int i2 = 0; i2 < len; ++i2) {
            if (hasNA && c2.isNA(i2)) {
                ++naCnt;
                continue;
            }
            long l2 = c2.at8(i2);
            double x2 = l2;
            if (l2 != 0L) {
                checksum ^= 17L * (start + (long)i2) ^ 23L * l2;
            }
            if (x2 != 0.0) {
                ++nzCnt;
            }
            if (x2 < dmin) {
                dmin = this._rs.min(x2);
            }
            if (x2 > dmax) {
                dmax = this._rs.max(x2);
            }
            double delta = x2 - mean;
            M2 += delta * (x2 - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C4FChunk c2, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = this._rs._isInt;
        boolean hasNA = c2.hasNA();
        boolean hasFloat = c2.hasFloat();
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c2._len;
        for (int i2 = 0; i2 < len; ++i2) {
            long l2;
            if (hasNA && c2.isNA(i2)) {
                ++naCnt;
                continue;
            }
            double x2 = c2.atd(i2);
            long l3 = l2 = hasFloat ? Double.doubleToRawLongBits(x2) : c2.at8(i2);
            if (l2 != 0L) {
                checksum ^= 17L * (start + (long)i2) ^ 23L * l2;
            }
            if (x2 == Double.POSITIVE_INFINITY) {
                ++pinfs;
                continue;
            }
            if (x2 == Double.NEGATIVE_INFINITY) {
                ++ninfs;
                continue;
            }
            if (x2 != 0.0) {
                ++nzCnt;
            }
            if (x2 < dmin) {
                dmin = this._rs.min(x2);
            }
            if (x2 > dmax) {
                dmax = this._rs.max(x2);
            }
            if (isInt) {
                isInt = (double)((long)x2) == x2;
            }
            double delta = x2 - mean;
            M2 += delta * (x2 - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C4SChunk c2, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = this._rs._isInt;
        boolean hasNA = c2.hasNA();
        boolean hasFloat = c2.hasFloat();
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c2._len;
        for (int i2 = 0; i2 < len; ++i2) {
            long l2;
            if (hasNA && c2.isNA(i2)) {
                ++naCnt;
                continue;
            }
            double x2 = c2.atd(i2);
            long l3 = l2 = hasFloat ? Double.doubleToRawLongBits(x2) : c2.at8(i2);
            if (l2 != 0L) {
                checksum ^= 17L * (start + (long)i2) ^ 23L * l2;
            }
            if (x2 == Double.POSITIVE_INFINITY) {
                ++pinfs;
                continue;
            }
            if (x2 == Double.NEGATIVE_INFINITY) {
                ++ninfs;
                continue;
            }
            if (x2 != 0.0) {
                ++nzCnt;
            }
            if (x2 < dmin) {
                dmin = this._rs.min(x2);
            }
            if (x2 > dmax) {
                dmax = this._rs.max(x2);
            }
            if (isInt) {
                isInt = (double)((long)x2) == x2;
            }
            double delta = x2 - mean;
            M2 += delta * (x2 - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C8Chunk c2, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = true;
        boolean hasNA = c2.hasNA();
        boolean hasFloat = c2.hasFloat();
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c2._len;
        for (int i2 = 0; i2 < len; ++i2) {
            if (hasNA && c2.isNA(i2)) {
                ++naCnt;
                continue;
            }
            long l2 = c2.at8(i2);
            double x2 = l2;
            if (l2 != 0L) {
                checksum ^= 17L * (start + (long)i2) ^ 23L * l2;
            }
            if (x2 != 0.0) {
                ++nzCnt;
            }
            if (x2 < dmin) {
                dmin = this._rs.min(x2);
            }
            if (x2 > dmax) {
                dmax = this._rs.max(x2);
            }
            double delta = x2 - mean;
            M2 += delta * (x2 - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }

    public long numericChunkRollup(C8DChunk c2, long start, long checksum) {
        long pinfs = 0L;
        long ninfs = 0L;
        long naCnt = 0L;
        long nzCnt = 0L;
        boolean isInt = this._rs._isInt;
        boolean hasNA = c2.hasNA();
        boolean hasFloat = true;
        double dmin = this._rs._mins[this._rs._mins.length - 1];
        double dmax = this._rs._maxs[this._rs._maxs.length - 1];
        assert (this._rs._pinfs == 0L);
        assert (this._rs._ninfs == 0L);
        assert (this._rs._naCnt == 0L);
        assert (this._rs._nzCnt == 0L);
        assert (dmin == Double.MAX_VALUE);
        assert (dmax == -1.7976931348623157E308);
        long rows = 0L;
        double mean = 0.0;
        double M2 = 0.0;
        int len = c2._len;
        for (int i2 = 0; i2 < len; ++i2) {
            long l2;
            if (hasNA && c2.isNA(i2)) {
                ++naCnt;
                continue;
            }
            double x2 = c2.atd(i2);
            long l3 = l2 = hasFloat ? Double.doubleToRawLongBits(x2) : c2.at8(i2);
            if (l2 != 0L) {
                checksum ^= 17L * (start + (long)i2) ^ 23L * l2;
            }
            if (x2 == Double.POSITIVE_INFINITY) {
                ++pinfs;
                continue;
            }
            if (x2 == Double.NEGATIVE_INFINITY) {
                ++ninfs;
                continue;
            }
            if (x2 != 0.0) {
                ++nzCnt;
            }
            if (x2 < dmin) {
                dmin = this._rs.min(x2);
            }
            if (x2 > dmax) {
                dmax = this._rs.max(x2);
            }
            if (isInt) {
                isInt = (double)((long)x2) == x2;
            }
            double delta = x2 - mean;
            M2 += delta * (x2 - (mean += delta / (double)(++rows)));
        }
        this._rs._pinfs = pinfs;
        this._rs._ninfs = ninfs;
        this._rs._naCnt = naCnt;
        this._rs._nzCnt = nzCnt;
        this._rs._rows += rows;
        this._rs._isInt = isInt;
        this._rs._mean = mean;
        this._rs._sigma = M2;
        return checksum;
    }
}

