/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.HashMap;
import java.util.Map;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public class CUDChunk
extends Chunk {
    public static int MAX_UNIQUES = 256;
    int numUniques;

    public static int computeByteSize(int uniques, int len) {
        return 8 + (uniques << 3) + (len << 1);
    }

    CUDChunk() {
    }

    CUDChunk(byte[] bs, HashMap<Long, Byte> hs, int len) {
        this._start = -1L;
        this.numUniques = hs.size();
        this.set_len(len);
        this._mem = MemoryManager.malloc1(CUDChunk.computeByteSize(this.numUniques, this._len), false);
        UnsafeUtils.set4(this._mem, 0, this._len);
        UnsafeUtils.set4(this._mem, 4, this.numUniques);
        int j2 = 0;
        for (Map.Entry<Long, Byte> e2 : hs.entrySet()) {
            e2.setValue((byte)(j2 - 128));
            UnsafeUtils.set8(this._mem, 8 + (j2 << 3), e2.getKey());
            ++j2;
        }
        for (int i2 = 0; i2 < len; ++i2) {
            UnsafeUtils.set1(this._mem, 8 + (this.numUniques << 3) + i2, hs.get(Double.doubleToLongBits(UnsafeUtils.get8d(bs, i2 << 3))));
        }
    }

    @Override
    protected final long at8_impl(int i2) {
        double res = this.atd_impl(i2);
        if (Double.isNaN(res)) {
            throw new IllegalArgumentException("at8_impl but value is missing");
        }
        return (long)res;
    }

    @Override
    protected final double atd_impl(int i2) {
        int whichUnique = UnsafeUtils.get1(this._mem, 8 + (this.numUniques << 3) + i2) + 128;
        return Double.longBitsToDouble(UnsafeUtils.get8(this._mem, 8 + (whichUnique << 3)));
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to) {
        return this.getDoubles(vals, from, to, Double.NaN);
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA2) {
        int i2;
        double[] uniques = new double[this.numUniques];
        for (i2 = 0; i2 < this.numUniques; ++i2) {
            uniques[i2] = Double.longBitsToDouble(UnsafeUtils.get8(this._mem, 8 + (i2 << 3)));
            if (!Double.isNaN(uniques[i2])) continue;
            uniques[i2] = NA2;
        }
        for (i2 = 0; i2 < this._len; ++i2) {
            vals[i2] = uniques[UnsafeUtils.get1(this._mem, 8 + (this.numUniques << 3) + i2) + 128];
        }
        return vals;
    }

    @Override
    protected final boolean isNA_impl(int i2) {
        return Double.isNaN(this.atd_impl(i2));
    }

    @Override
    boolean set_impl(int idx, long l2) {
        return false;
    }

    @Override
    boolean set_impl(int i2, double d2) {
        for (int j2 = 0; j2 < this.numUniques; ++j2) {
            if (Double.compare(Double.doubleToLongBits(d2), UnsafeUtils.get8(this._mem, 8 + (j2 << 3))) != 0) continue;
            UnsafeUtils.set1(this._mem, 8 + (this.numUniques << 3) + i2, (byte)(j2 - 128));
            return true;
        }
        return false;
    }

    @Override
    boolean set_impl(int i2, float f2) {
        return this.set_impl(i2, (double)f2);
    }

    @Override
    boolean setNA_impl(int idx) {
        return this.set_impl(idx, Double.NaN);
    }

    public ChunkVisitor processRows(ChunkVisitor nc, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            nc.addValue(this.atd(i2));
        }
        return nc;
    }

    public ChunkVisitor processRows(ChunkVisitor nc, int ... rows) {
        for (int i2 : rows) {
            nc.addValue(this.atd(i2));
        }
        return nc;
    }

    @Override
    protected final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this._len = UnsafeUtils.get4(this._mem, 0);
        this.numUniques = UnsafeUtils.get4(this._mem, 4);
        this.set_len(this._len);
    }
}

