/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.fvec.NewChunk;
import water.parser.BufferedString;
import water.util.SetOfBytes;
import water.util.StringUtils;
import water.util.UnsafeUtils;

public class CStrChunk
extends Chunk {
    static final int NA = -1;
    protected static final int _OFF = 5;
    private int _valstart;
    public boolean _isAllASCII = false;

    public CStrChunk() {
    }

    public CStrChunk(String s2, int len) {
        byte[] sBytes = StringUtils.bytesOf(s2);
        sBytes = Arrays.copyOf(sBytes, sBytes.length + 1);
        sBytes[sBytes.length - 1] = 0;
        this.init(sBytes.length, StringUtils.bytesOf(s2), len, len, null, null);
    }

    public CStrChunk(int sslen, byte[] ss, int sparseLen, int idxLen, int[] id, int[] is) {
        this.init(sslen, ss, sparseLen, idxLen, id, is);
    }

    private void init(int sslen, byte[] ss, int sparseLen, int idxLen, int[] id, int[] is) {
        int i2;
        this._start = -1L;
        this._valstart = this.idx(idxLen);
        this._len = idxLen;
        this._mem = MemoryManager.malloc1(this._valstart + sslen, false);
        UnsafeUtils.set4(this._mem, 0, this._valstart);
        Arrays.fill(this._mem, 5, this._valstart, (byte)-1);
        for (i2 = 0; i2 < sparseLen; ++i2) {
            UnsafeUtils.set4(this._mem, this.idx(id == null ? i2 : id[i2]), is == null ? 0 : is[i2]);
        }
        UnsafeUtils.copyMemory(ss, 0L, this._mem, this._valstart, sslen);
        this._isAllASCII = true;
        for (i2 = this._valstart; i2 < this._mem.length; ++i2) {
            byte c2 = this._mem[i2];
            if ((c2 & 0x80) != 128) continue;
            this._isAllASCII = false;
            break;
        }
        UnsafeUtils.set1(this._mem, 4, (byte)(this._isAllASCII ? 1 : 0));
    }

    private int idx(int i2) {
        return 5 + (i2 << 2);
    }

    @Override
    public boolean setNA_impl(int idx) {
        return false;
    }

    @Override
    public boolean set_impl(int idx, float f2) {
        if (Float.isNaN(f2)) {
            return false;
        }
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, double d2) {
        if (Double.isNaN(d2)) {
            return false;
        }
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, long l2) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public boolean set_impl(int idx, String str) {
        return false;
    }

    @Override
    public boolean isNA_impl(int idx) {
        int off = this.intAt(idx);
        return off == -1;
    }

    public int intAt(int i2) {
        return UnsafeUtils.get4(this._mem, this.idx(i2));
    }

    public byte byteAt(int i2) {
        return this._mem[this._valstart + i2];
    }

    public int lengthAtOffset(int off) {
        int len = 0;
        while (this.byteAt(off + len) != 0) {
            ++len;
        }
        return len;
    }

    @Override
    public long at8_impl(int idx) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public double atd_impl(int idx) {
        throw new IllegalArgumentException("Operation not allowed on string vector.");
    }

    @Override
    public BufferedString atStr_impl(BufferedString bStr, int idx) {
        int off = this.intAt(idx);
        if (off == -1) {
            return null;
        }
        int len = this.lengthAtOffset(off);
        assert (len >= 0) : this.getClass().getSimpleName() + ".atStr_impl: len=" + len + ", idx=" + idx + ", off=" + off;
        return bStr.set(this._mem, this._valstart + off, len);
    }

    @Override
    protected final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this._valstart = UnsafeUtils.get4(this._mem, 0);
        byte b2 = UnsafeUtils.get1(this._mem, 4);
        this._isAllASCII = b2 != 0;
        this.set_len(this._valstart - 5 >> 2);
    }

    public ChunkVisitor processRows(ChunkVisitor nc, int from, int to) {
        BufferedString bs = new BufferedString();
        for (int i2 = from; i2 < to; ++i2) {
            nc.addValue(this.atStr(bs, i2));
        }
        return nc;
    }

    public ChunkVisitor processRows(ChunkVisitor nc, int ... rows) {
        BufferedString bs = new BufferedString();
        for (int i2 : rows) {
            nc.addValue(this.atStr(bs, i2));
        }
        return nc;
    }

    public NewChunk asciiToLower(NewChunk nc) {
        nc = this.extractRows(nc, 0, this._len);
        for (int i2 = 0; i2 < nc._sslen; ++i2) {
            if (nc._ss[i2] <= 64 || nc._ss[i2] >= 91) continue;
            int n2 = i2;
            nc._ss[n2] = (byte)(nc._ss[n2] + 32);
        }
        return nc;
    }

    public NewChunk asciiToUpper(NewChunk nc) {
        nc = this.extractRows(nc, 0, this._len);
        for (int i2 = 0; i2 < nc._sslen; ++i2) {
            if (nc._ss[i2] <= 96 || nc._ss[i2] >= 123) continue;
            int n2 = i2;
            nc._ss[n2] = (byte)(nc._ss[n2] - 32);
        }
        return nc;
    }

    public NewChunk asciiTrim(NewChunk nc) {
        nc = this.extractRows(nc, 0, this._len);
        for (int i2 = 0; i2 < this._len; ++i2) {
            int j2 = 0;
            int off = UnsafeUtils.get4(this._mem, this.idx(i2));
            if (off == -1) continue;
            while (this._mem[this._valstart + off + j2] > 0 && this._mem[this._valstart + off + j2] < 33) {
                ++j2;
            }
            if (j2 > 0) {
                nc.set_is(i2, off + j2);
            }
            while (this._mem[this._valstart + off + j2] != 0) {
                ++j2;
            }
            --j2;
            while (this._mem[this._valstart + off + j2] > 0 && this._mem[this._valstart + off + j2] < 33) {
                nc._ss[off + j2] = 0;
                --j2;
            }
        }
        return nc;
    }

    public NewChunk asciiSubstring(NewChunk nc, int startIndex, int endIndex) {
        nc = this.extractRows(nc, 0, this._len);
        for (int i2 = 0; i2 < this._len; ++i2) {
            int off = UnsafeUtils.get4(this._mem, this.idx(i2));
            if (off == -1) continue;
            int len = 0;
            while (this._mem[this._valstart + off + len] != 0) {
                ++len;
            }
            nc.set_is(i2, startIndex < len ? off + startIndex : off + len);
            while (len > endIndex - 1) {
                nc._ss[off + len] = 0;
                --len;
            }
        }
        return nc;
    }

    public NewChunk asciiLength(NewChunk nc) {
        nc.alloc_mantissa(this._len);
        nc.alloc_exponent(this._len);
        for (int i2 = 0; i2 < this._len; ++i2) {
            int off = UnsafeUtils.get4(this._mem, this.idx(i2));
            int len = 0;
            if (off != -1) {
                while (this._mem[this._valstart + off + len] != 0) {
                    ++len;
                }
                nc.addNum(len, 0);
                continue;
            }
            nc.addNA();
        }
        return nc;
    }

    public NewChunk asciiEntropy(NewChunk nc) {
        nc.alloc_doubles(this._len);
        for (int i2 = 0; i2 < this._len; ++i2) {
            double entropy = this.entropyAt(i2);
            if (Double.isNaN(entropy)) {
                nc.addNA();
                continue;
            }
            nc.addNum(entropy);
        }
        return nc;
    }

    double entropyAt(int i2) {
        int off = this.intAt(i2);
        if (off == -1) {
            return Double.NaN;
        }
        int[] frq = new int[256];
        int len = this.lengthAtOffset(off);
        for (int j2 = 0; j2 < len; ++j2) {
            int n2 = 0xFF & this.byteAt(off + j2);
            frq[n2] = frq[n2] + 1;
        }
        double sum = 0.0;
        for (int b2 = 0; b2 < 256; ++b2) {
            int f2 = frq[b2];
            if (f2 <= 0) continue;
            double x2 = (double)f2 / (double)len;
            sum += x2 * Math.log(x2);
        }
        return -sum / Math.log(2.0);
    }

    public NewChunk asciiLStrip(NewChunk nc, String chars) {
        SetOfBytes set = new SetOfBytes(chars);
        for (int i2 = 0; i2 < this._len; ++i2) {
            int off = this.intAt(i2);
            if (off != -1) {
                while (set.contains(this.byteAt(off))) {
                    ++off;
                }
                int len = this.lengthAtOffset(off);
                nc.addStr(new BufferedString(this._mem, this._valstart + off, len));
                continue;
            }
            nc.addNA();
        }
        return nc;
    }

    public NewChunk asciiRStrip(NewChunk nc, String chars) {
        SetOfBytes set = new SetOfBytes(chars);
        for (int i2 = 0; i2 < this._len; ++i2) {
            int off = this.intAt(i2);
            if (off != -1) {
                int pos = off + this.lengthAtOffset(off);
                while (pos-- > off && set.contains(this.byteAt(pos))) {
                }
                nc.addStr(new BufferedString(this._mem, this._valstart + off, pos - off + 1));
                continue;
            }
            nc.addNA();
        }
        return nc;
    }
}

