/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.util.UnsafeUtils;

public class C8DChunk
extends Chunk {
    C8DChunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length >> 3);
    }

    @Override
    protected final long at8_impl(int i2) {
        double res = UnsafeUtils.get8d(this._mem, i2 << 3);
        if (Double.isNaN(res)) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return (long)res;
    }

    @Override
    protected final double atd_impl(int i2) {
        return UnsafeUtils.get8d(this._mem, i2 << 3);
    }

    @Override
    protected final boolean isNA_impl(int i2) {
        return Double.isNaN(UnsafeUtils.get8d(this._mem, i2 << 3));
    }

    @Override
    boolean set_impl(int idx, long l2) {
        return false;
    }

    public void set8D(int i2, double d2) {
        UnsafeUtils.set8d(this._mem, i2 << 3, d2);
    }

    public double get8D(int i2) {
        return UnsafeUtils.get8d(this._mem, i2 << 3);
    }

    @Override
    boolean set_impl(int i2, double d2) {
        UnsafeUtils.set8d(this._mem, i2 << 3, d2);
        return true;
    }

    @Override
    boolean set_impl(int i2, float f2) {
        UnsafeUtils.set8d(this._mem, i2 << 3, f2);
        return true;
    }

    @Override
    boolean setNA_impl(int idx) {
        UnsafeUtils.set8d(this._mem, idx << 3, Double.NaN);
        return true;
    }

    @Override
    public final void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length >> 3);
        assert (this._mem.length == this._len << 3);
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            v2.addValue(UnsafeUtils.get8d(this._mem, 8 * i2));
        }
        return v2;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int[] ids) {
        for (int i2 : ids) {
            v2.addValue(UnsafeUtils.get8d(this._mem, 8 * i2));
        }
        return v2;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA2) {
        for (int i2 = from; i2 < to; ++i2) {
            double d2 = UnsafeUtils.get8d(this._mem, 8 * i2);
            vals[i2 - from] = Double.isNaN(d2) ? NA2 : d2;
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int k2 = 0;
        for (int i2 : ids) {
            vals[k2++] = UnsafeUtils.get8d(this._mem, 8 * i2);
        }
        return vals;
    }
}

