/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.CSChunk;
import water.fvec.ChunkVisitor;
import water.util.PrettyPrint;
import water.util.UnsafeUtils;

public class C2SChunk
extends CSChunk {
    C2SChunk(byte[] bs, long bias, int scale) {
        super(bs, bias, scale, 1);
        if (scale < 0) {
            double div = PrettyPrint.pow10(1L, -scale);
            for (int i2 = 0; i2 < this._len; ++i2) {
                int x2 = this.getMantissa(i2);
                if (x2 == Short.MIN_VALUE || this.getD(x2, Short.MIN_VALUE, Double.NaN) == (double)((long)x2 + bias) / div) continue;
                this.setDecimal();
                break;
            }
        }
    }

    @Override
    protected final long at8_impl(int i2) {
        int x2 = this.getMantissa(i2);
        if (x2 == Short.MIN_VALUE) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return this.get8(x2);
    }

    private int getMantissa(int i2) {
        return UnsafeUtils.get2(this._mem, 16 + 2 * i2);
    }

    private void setMantissa(int i2, short s2) {
        UnsafeUtils.set2(this._mem, i2 * 2 + 16, s2);
    }

    @Override
    protected final double atd_impl(int i2) {
        return this.getD(this.getMantissa(i2), Short.MIN_VALUE);
    }

    @Override
    protected final boolean isNA_impl(int i2) {
        return this.getMantissa(i2) == Short.MIN_VALUE;
    }

    @Override
    boolean set_impl(int i2, double x2) {
        if (Double.isNaN(x2)) {
            return this.setNA_impl(i2);
        }
        int y2 = this.getScaledValue(x2, Short.MIN_VALUE);
        short s2 = (short)y2;
        if (this.getD(s2, Short.MIN_VALUE, Double.NaN) != x2) {
            return false;
        }
        this.setMantissa(i2, s2);
        assert (!this.isNA_impl(i2));
        return true;
    }

    @Override
    boolean setNA_impl(int idx) {
        this.setMantissa(idx, (short)Short.MIN_VALUE);
        return true;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA2) {
        for (int i2 = from; i2 < to; ++i2) {
            vals[i2 - from] = this.getD(this.getMantissa(i2), Short.MIN_VALUE, NA2);
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int k2 = 0;
        for (int i2 : ids) {
            vals[k2++] = this.getD(this.getMantissa(i2), Short.MIN_VALUE);
        }
        return vals;
    }

    private <T extends ChunkVisitor> void processRow(T v2, int i2, long bias, int exp) {
        long x2 = this.getMantissa(i2);
        if (x2 == -32768L) {
            v2.addNAs(1);
        } else {
            v2.addValue(x2 + bias, exp);
        }
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v2, int from, int to, long bias, int exp) {
        for (int i2 = from; i2 < to; ++i2) {
            this.processRow(v2, i2, bias, exp);
        }
        return v2;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v2, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            v2.addValue(this.getD(this.getMantissa(i2), Short.MIN_VALUE));
        }
        return v2;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v2, int[] ids, long bias, int exp) {
        for (int i2 : ids) {
            this.processRow(v2, i2, bias, exp);
        }
        return v2;
    }

    @Override
    protected <T extends ChunkVisitor> T processRows2(T v2, int[] ids) {
        for (int i2 : ids) {
            v2.addValue(this.getD(this.getMantissa(i2), Short.MIN_VALUE));
        }
        return v2;
    }
}

