/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.fvec.Chunk;
import water.fvec.ChunkVisitor;

public class C1Chunk
extends Chunk {
    protected static final int _OFF = 0;
    protected static final int _NA = 255;

    C1Chunk(byte[] bs) {
        this._mem = bs;
        this._start = -1L;
        this.set_len(this._mem.length);
    }

    @Override
    protected final long at8_impl(int i2) {
        long res = 0xFF & this._mem[i2 + 0];
        if (res == 255L) {
            throw new IllegalArgumentException("at8_abs but value is missing");
        }
        return res;
    }

    @Override
    protected final double atd_impl(int i2) {
        long res = 0xFF & this._mem[i2 + 0];
        return res == 255L ? Double.NaN : (double)res;
    }

    @Override
    protected final boolean isNA_impl(int i2) {
        return (0xFF & this._mem[i2 + 0]) == 255;
    }

    @Override
    boolean set_impl(int i2, long l2) {
        if (0L > l2 || l2 >= 255L) {
            return false;
        }
        this._mem[i2 + 0] = (byte)l2;
        return true;
    }

    @Override
    boolean set_impl(int i2, double d2) {
        return false;
    }

    @Override
    boolean set_impl(int i2, float f2) {
        return false;
    }

    @Override
    boolean setNA_impl(int idx) {
        this._mem[idx + 0] = -1;
        return true;
    }

    @Override
    public void initFromBytes() {
        this._start = -1L;
        this._cidx = -1;
        this.set_len(this._mem.length);
    }

    private final void processRow(int r2, ChunkVisitor v2) {
        int i2 = 0xFF & this._mem[r2 + 0];
        if (i2 == 255) {
            v2.addNAs(1);
        } else {
            v2.addValue(i2);
        }
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int from, int to) {
        for (int i2 = from; i2 < to; ++i2) {
            this.processRow(i2, v2);
        }
        return v2;
    }

    @Override
    public <T extends ChunkVisitor> T processRows(T v2, int[] ids) {
        for (int i2 : ids) {
            this.processRow(i2, v2);
        }
        return v2;
    }

    @Override
    public int[] getIntegers(int[] vals, int from, int to, int NA2) {
        for (int i2 = from; i2 < to; ++i2) {
            int x2 = 0xFF & this._mem[i2];
            vals[i2 - from] = x2 == 255 ? NA2 : x2;
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int from, int to, double NA2) {
        for (int i2 = from; i2 < to; ++i2) {
            int x2 = 0xFF & this._mem[i2];
            vals[i2 - from] = x2 == 255 ? NA2 : (double)x2;
        }
        return vals;
    }

    @Override
    public double[] getDoubles(double[] vals, int[] ids) {
        int k2 = 0;
        for (int i2 : ids) {
            int x2 = 0xFF & this._mem[i2];
            vals[k2++] = x2 == 255 ? Double.NaN : (double)x2;
        }
        return vals;
    }

    @Override
    public boolean hasFloat() {
        return false;
    }
}

