/*
 * Decompiled with CFR 0.152.
 */
package water.exceptions;

import water.H2OError;
import water.exceptions.H2OAbstractRuntimeException;

public class H2OAutoMLException
extends H2OAbstractRuntimeException {
    private final Throwable _rootCause;
    private final int _httpResponse;

    public H2OAutoMLException(String msg) {
        this(msg, (Throwable)null);
    }

    public H2OAutoMLException(String msg, Throwable rootException) {
        this(msg, rootException, 0);
    }

    public H2OAutoMLException(String msg, Throwable rootException, int httpResponse) {
        super(msg, msg);
        this._rootCause = rootException;
        this._httpResponse = httpResponse > 0 ? httpResponse : super.HTTP_RESPONSE_CODE();
    }

    @Override
    protected int HTTP_RESPONSE_CODE() {
        return this._httpResponse;
    }

    @Override
    public H2OError toH2OError(String error_url) {
        String rootMessage = this._rootCause == null ? null : this._rootCause.getMessage().trim();
        H2OError err = this._rootCause instanceof H2OAbstractRuntimeException ? ((H2OAbstractRuntimeException)this._rootCause).toH2OError(error_url) : new H2OError(this.timestamp, error_url, this.getMessage(), this.dev_message, this.HTTP_RESPONSE_CODE(), this.values, this._rootCause);
        StringBuilder msg = new StringBuilder(this.getMessage().trim());
        if (msg.charAt(msg.length() - 1) != '.') {
            msg.append('.');
        }
        if (rootMessage != null) {
            msg.append(' ');
            msg.append("Root cause: ");
            msg.append(rootMessage);
            err._exception_msg = msg.toString();
        }
        return err;
    }
}

