/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.TimeLine;
import water.UDP;
import water.api.API;
import water.api.TimelineHandler;
import water.api.schemas3.RequestSchemaV3;
import water.api.schemas3.SchemaV3;
import water.init.TimelineSnapshot;

public class TimelineV3
extends RequestSchemaV3<TimelineHandler.Timeline, TimelineV3> {
    @API(help="Current time in millis.", direction=API.Direction.OUTPUT)
    public long now;
    @API(help="This node", direction=API.Direction.OUTPUT)
    public String self;
    @API(help="recorded timeline events", direction=API.Direction.OUTPUT)
    public EventV3[] events;

    @Override
    public TimelineV3 fillFromImpl(TimelineHandler.Timeline timeline) {
        ArrayList<EventV3> outputEvents = new ArrayList<EventV3>();
        ArrayList<TimelineSnapshot.Event> heartbeats = new ArrayList<TimelineSnapshot.Event>();
        H2O cloud = TimeLine.getCLOUD();
        if (null != timeline.snapshot) {
            for (TimelineSnapshot.Event event : timeline.snapshot) {
                String to;
                String from;
                H2ONode h2o = cloud.members()[event._nodeId];
                UDP.udp msgType = event.udpType();
                if (msgType == UDP.udp.heartbeat) {
                    heartbeats.add(event);
                    continue;
                }
                if (!heartbeats.isEmpty()) {
                    long firstMs = ((TimelineSnapshot.Event)heartbeats.get(0)).ms();
                    long lastMs = ((TimelineSnapshot.Event)heartbeats.get(heartbeats.size() - 1)).ms();
                    int totalSends = 0;
                    int totalRecvs = 0;
                    int totalDrops = 0;
                    int[] sends = new int[cloud.size()];
                    int[] recvs = new int[cloud.size()];
                    for (TimelineSnapshot.Event h2 : heartbeats) {
                        if (h2.isSend()) {
                            ++totalSends;
                            int n2 = h2._nodeId;
                            sends[n2] = sends[n2] + 1;
                            continue;
                        }
                        if (h2.isDropped()) {
                            ++totalDrops;
                            continue;
                        }
                        ++totalRecvs;
                        int n3 = h2._nodeId;
                        recvs[n3] = recvs[n3] + 1;
                    }
                    heartbeats.clear();
                    outputEvents.add(new HeartBeatEvent(totalSends, totalRecvs, firstMs, lastMs));
                }
                long ms = event.ms();
                long ns = event.ns();
                if (msgType == UDP.udp.i_o) {
                    outputEvents.add(new IOEvent(ms, ns, event.recoH2O().toString(), event.ioflavor(), UDP.printx16(event.dataLo(), event.dataHi())));
                    continue;
                }
                if (event.isSend()) {
                    from = h2o.toString();
                    to = event.packH2O() == null ? "multicast" : event.packH2O().toString();
                } else {
                    from = event.packH2O().toString();
                    to = h2o.toString();
                }
                outputEvents.add(new NetworkEvent(ms, ns, event.isSend(), event.isTCP() ? "TCP" : "UDP", msgType.toString(), from, to, UDP.printx16(event.dataLo(), event.dataHi())));
            }
        }
        this.events = outputEvents.toArray(new EventV3[null == outputEvents ? 0 : outputEvents.size()]);
        return this;
    }

    public static class IOEvent
    extends EventV3<Iced, IOEvent> {
        @API(help="flavor of the recorded io (ice/hdfs/...)")
        public final String io_flavor;
        @API(help="node where this io event happened")
        public final String node;
        @API(help="data info")
        public final String data;

        public IOEvent() {
            this(-1L, -1L, "unknown", "unknown", "unknown");
        }

        private IOEvent(long ms, long ns, String node, String io_flavor, String data) {
            super(EventV3.EventType.io, ms, ns);
            this.io_flavor = io_flavor;
            this.node = node;
            this.data = data;
        }

        @Override
        protected String who() {
            return this.node;
        }

        @Override
        protected String ioType() {
            return this.io_flavor;
        }

        @Override
        protected String event() {
            return "i_o";
        }

        @Override
        public String bytes() {
            return this.data;
        }

        public String toString() {
            return "I_O('" + this.io_flavor + "')";
        }
    }

    public static class NetworkEvent
    extends EventV3<Iced, NetworkEvent> {
        @API(help="Boolean flag distinguishing between sends (true) and receives(false)")
        public final boolean is_send;
        @API(help="network protocol (UDP/TCP)")
        public final String protocol;
        @API(help="UDP type (exec,ack, ackack,...")
        public final String msg_type;
        @API(help="Sending node")
        public final String from;
        @API(help="Receiving node")
        public final String to;
        @API(help="Pretty print of the first few bytes of the msg payload. Contains class name for tasks.")
        public final String data;

        public NetworkEvent() {
            this.is_send = false;
            this.protocol = "unknown";
            this.msg_type = "unknown";
            this.from = "unknown";
            this.to = "unknown";
            this.data = "unknown";
        }

        private NetworkEvent(long ms, long ns, boolean is_send, String protocol, String msg_type, String from, String to, String data) {
            super(EventV3.EventType.network_msg, ms, ns);
            this.is_send = is_send;
            this.protocol = protocol;
            this.msg_type = msg_type;
            this.from = from;
            this.to = to;
            this.data = data;
        }

        @Override
        protected String who() {
            return this.from + " -> " + this.to;
        }

        @Override
        protected String ioType() {
            return this.protocol;
        }

        @Override
        protected String event() {
            return this.msg_type;
        }

        @Override
        public String bytes() {
            return this.data;
        }

        public String toString() {
            return "NetworkMsg(" + this.from + " -> " + this.to + ", protocol = '" + this.protocol + "', data = '" + this.data + "')";
        }
    }

    public static class HeartBeatEvent
    extends EventV3<Iced, HeartBeatEvent> {
        @API(help="number of sent heartbeats")
        final int sends;
        @API(help="number of received heartbeats")
        final int recvs;

        public HeartBeatEvent() {
            this.sends = -1;
            this.recvs = -1;
        }

        private HeartBeatEvent(int sends, int recvs, long lastMs, long lastNs) {
            super(EventV3.EventType.heartbeat, lastMs, lastNs);
            this.sends = sends;
            this.recvs = recvs;
        }

        @Override
        protected String who() {
            return "many -> many";
        }

        @Override
        protected String ioType() {
            return "UDP";
        }

        @Override
        protected String event() {
            return "heartbeat";
        }

        @Override
        public String bytes() {
            return this.sends + " sent , " + this.recvs + " received";
        }

        public String toString() {
            return "HeartBeat(" + this.sends + " sends, " + this.recvs + " receives)";
        }
    }

    public static class EventV3<I, S extends EventV3<I, S>>
    extends SchemaV3<Iced, S> {
        @API(help="Time when the event was recorded. Format is hh:mm:ss:ms")
        public final String date;
        @API(help="Time in nanos")
        public final long nanos;
        @API(help="type of recorded event", values={"unknown", "heartbeat", "network_msg", "io"})
        public final EventType type;

        public EventV3() {
            this.date = null;
            this.nanos = -1L;
            this.type = EventType.unknown;
        }

        private EventV3(EventType type, long millis, long nanos) {
            this.type = type;
            this.date = new SimpleDateFormat("HH:mm:ss:SSS").format(new Date(millis));
            this.nanos = nanos;
        }

        protected String who() {
            throw H2O.unimpl();
        }

        protected String ioType() {
            throw H2O.unimpl();
        }

        protected String event() {
            throw H2O.unimpl();
        }

        public String bytes() {
            throw H2O.unimpl();
        }

        static enum EventType {
            unknown,
            heartbeat,
            network_msg,
            io;

        }
    }
}

