/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.Model;
import water.api.API;
import water.api.ModelExportAware;
import water.api.ModelsHandler;
import water.api.SchemaServer;
import water.api.schemas3.FrameV3;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelSchemaBaseV3;
import water.api.schemas3.ModelSchemaV3;
import water.api.schemas3.ModelSynopsisV3;
import water.api.schemas3.RequestSchemaV3;

public class ModelsV3
extends RequestSchemaV3<ModelsHandler.Models, ModelsV3>
implements ModelExportAware {
    @API(help="Name of Model of interest", json=false)
    public KeyV3.ModelKeyV3 model_id;
    @API(help="Return potentially abridged model suitable for viewing in a browser", json=false, required=false, direction=API.Direction.INPUT)
    public boolean preview = false;
    @API(help="Find and return compatible frames?", json=false, direction=API.Direction.INPUT)
    public boolean find_compatible_frames = false;
    @API(help="Models", direction=API.Direction.OUTPUT)
    public ModelSchemaBaseV3[] models;
    @API(help="Compatible frames", direction=API.Direction.OUTPUT)
    public FrameV3[] compatible_frames;
    @API(direction=API.Direction.INPUT, help="Flag indicating whether the exported model artifact should also include CV Holdout Frame predictions", level=API.Level.secondary)
    public boolean export_cross_validation_predictions;

    @Override
    public ModelsHandler.Models fillImpl(ModelsHandler.Models m4) {
        super.fillImpl(m4);
        if (null != this.models) {
            m4.models = new Model[this.models.length];
            int i2 = 0;
            for (ModelSchemaBaseV3 model : this.models) {
                m4.models[i2++] = (Model)model.createImpl();
            }
        }
        return m4;
    }

    @Override
    public ModelsV3 fillFromImpl(ModelsHandler.Models m4) {
        this.model_id = new KeyV3.ModelKeyV3(m4.model_id);
        this.find_compatible_frames = m4.find_compatible_frames;
        if (null != m4.models) {
            this.models = new ModelSchemaBaseV3[m4.models.length];
            int i2 = 0;
            for (Model model : m4.models) {
                this.models[i2++] = (ModelSchemaV3)SchemaServer.schema(this.getSchemaVersion(), model).fillFromImpl(model);
            }
        }
        return this;
    }

    public ModelsV3 fillFromImplWithSynopsis(ModelsHandler.Models m4) {
        this.model_id = new KeyV3.ModelKeyV3(m4.model_id);
        if (null != m4.models) {
            this.models = new ModelSchemaBaseV3[m4.models.length];
            int i2 = 0;
            for (Model model : m4.models) {
                this.models[i2++] = new ModelSynopsisV3<Model>(model);
            }
        }
        return this;
    }

    @Override
    public boolean isExportCVPredictionsEnabled() {
        return this.export_cross_validation_predictions;
    }
}

