/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.AUUC;
import hex.ModelMetricsBinomialUplift;
import java.util.Arrays;
import water.api.API;
import water.api.schemas3.ModelMetricsBaseV3;
import water.api.schemas3.TwoDimTableV3;
import water.util.ArrayUtils;
import water.util.EnumUtils;
import water.util.TwoDimTable;

public class ModelMetricsBinomialUpliftV3<I extends ModelMetricsBinomialUplift, S extends ModelMetricsBinomialUpliftV3<I, S>>
extends ModelMetricsBaseV3<I, S> {
    @API(help="The default AUUC for this scoring run.", direction=API.Direction.OUTPUT)
    public double AUUC;
    @API(help="The default normalized AUUC for this scoring run.", direction=API.Direction.OUTPUT)
    public double auuc_normalized;
    @API(help="The Qini value for this scoring run.", direction=API.Direction.OUTPUT)
    public double qini;
    @API(help="The class labels of the response.", direction=API.Direction.OUTPUT)
    public String[] domain;
    @API(help="The metrics for various thresholds.", direction=API.Direction.OUTPUT, level=API.Level.expert)
    public TwoDimTableV3 thresholds_and_metric_scores;
    @API(help="Table of all types of AUUC.", direction=API.Direction.OUTPUT, level=API.Level.secondary)
    public TwoDimTableV3 auuc_table;
    @API(help="Table of all types of AECU values.", direction=API.Direction.OUTPUT, level=API.Level.secondary)
    public TwoDimTableV3 aecu_table;

    @Override
    public S fillFromImpl(ModelMetricsBinomialUplift modelMetrics) {
        super.fillFromImpl(modelMetrics);
        AUUC auuc = modelMetrics._auuc;
        if (null != auuc) {
            int i2;
            this.AUUC = auuc.auuc();
            this.auuc_normalized = auuc.auucNormalized();
            this.qini = auuc.qini();
            String[] thresholds = new String[auuc._nBins];
            AUUC.AUUCType[] metrics = AUUC.AUUCType.VALUES;
            metrics = ArrayUtils.remove(metrics, Arrays.asList(metrics).indexOf((Object)AUUC.AUUCType.AUTO));
            int metricsLength = metrics.length;
            long[] n2 = new long[auuc._nBins];
            double[][] uplift = new double[metricsLength][];
            double[][] upliftNormalized = new double[metricsLength][];
            double[][] upliftRandom = new double[metricsLength][];
            for (int i3 = 0; i3 < auuc._nBins; ++i3) {
                thresholds[i3] = Double.toString(auuc._ths[i3]);
                n2[i3] = auuc._frequencyCumsum[i3];
            }
            String[] colHeaders = new String[3 * metricsLength + 3];
            String[] types = new String[3 * metricsLength + 3];
            String[] formats = new String[3 * metricsLength + 3];
            colHeaders[0] = "thresholds";
            types[0] = "double";
            formats[0] = "%f";
            for (i2 = 0; i2 < metricsLength; ++i2) {
                colHeaders[i2 + 1] = metrics[i2].toString();
                colHeaders[i2 + 1 + metricsLength] = metrics[i2].toString() + "_normalized";
                colHeaders[i2 + 1 + 2 * metricsLength] = metrics[i2].toString() + "_random";
                uplift[i2] = auuc.upliftByType(metrics[i2]);
                upliftNormalized[i2] = auuc.upliftNormalizedByType(metrics[i2]);
                upliftRandom[i2] = auuc.upliftRandomByType(metrics[i2]);
                types[i2 + 1] = "double";
                formats[i2 + 1] = "%f";
                types[i2 + 1 + metricsLength] = "double";
                formats[i2 + 1 + metricsLength] = "%f";
                types[i2 + 1 + 2 * metricsLength] = "double";
                formats[i2 + 1 + 2 * metricsLength] = "%f";
            }
            colHeaders[i2 + 1 + 2 * metricsLength] = "n";
            types[i2 + 1 + 2 * metricsLength] = "int";
            formats[i2 + 1 + 2 * metricsLength] = "%d";
            colHeaders[i2 + 2 + 2 * metricsLength] = "idx";
            types[i2 + 2 + 2 * metricsLength] = "int";
            formats[i2 + 2 + 2 * metricsLength] = "%d";
            TwoDimTable thresholdsByMetrics = new TwoDimTable("Metrics for Thresholds", "Cumulative Uplift metrics for a given percentile", new String[auuc._nBins], colHeaders, types, formats, null);
            for (i2 = 0; i2 < auuc._nBins; ++i2) {
                int j2 = 0;
                thresholdsByMetrics.set(i2, j2, Double.valueOf(thresholds[i2]));
                for (j2 = 0; j2 < metricsLength; ++j2) {
                    thresholdsByMetrics.set(i2, 1 + j2, uplift[j2][i2]);
                    thresholdsByMetrics.set(i2, 1 + j2 + metricsLength, upliftNormalized[j2][i2]);
                    thresholdsByMetrics.set(i2, 1 + j2 + 2 * metricsLength, upliftRandom[j2][i2]);
                }
                thresholdsByMetrics.set(i2, 1 + j2 + 2 * metricsLength, n2[i2]);
                thresholdsByMetrics.set(i2, 2 + j2 + 2 * metricsLength, i2);
            }
            this.thresholds_and_metric_scores = new TwoDimTableV3().fillFromImpl(thresholdsByMetrics);
            String[] rowHeaders = new String[]{"AUUC value", "AUUC normalized", "AUUC random value"};
            String[] metricNames = EnumUtils.getNames(AUUC.AUUCType.class);
            colHeaders = ArrayUtils.remove(metricNames, Arrays.asList(metricNames).indexOf("AUTO"));
            types = new String[metricsLength];
            formats = new String[metricsLength];
            for (i2 = 0; i2 < metricsLength; ++i2) {
                types[i2] = "double";
                formats[i2] = "%f";
            }
            TwoDimTable auucs = new TwoDimTable("AUUC table (number of bins: " + auuc._nBins + ")", "All types of AUUC value", rowHeaders, colHeaders, types, formats, "Uplift type");
            for (i2 = 0; i2 < metricsLength; ++i2) {
                auucs.set(0, i2, auuc.auucByType(metrics[i2]));
                auucs.set(1, i2, auuc.auucNormalizedByType(metrics[i2]));
                auucs.set(2, i2, auuc.auucRandomByType(metrics[i2]));
            }
            this.auuc_table = new TwoDimTableV3().fillFromImpl(auucs);
            rowHeaders = new String[]{"AECU value"};
            TwoDimTable qinis = new TwoDimTable("AECU values table", "All types of AECU value", rowHeaders, colHeaders, types, formats, "Uplift type");
            for (i2 = 0; i2 < metricsLength; ++i2) {
                qinis.set(0, i2, auuc.aecuByType(metrics[i2]));
            }
            this.aecu_table = new TwoDimTableV3().fillFromImpl(qinis);
        }
        return (S)this;
    }
}

