/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.ModelBuilder;
import hex.schemas.ModelBuilderSchema;
import water.api.API;
import water.api.SchemaServer;
import water.api.schemas3.ModelParametersSchemaV3;
import water.api.schemas3.SchemaV3;
import water.api.schemas3.ValidationMessageV3;

public class ModelBuilderV3<J extends ModelBuilder, S extends ModelBuilderV3<J, S>>
extends SchemaV3<J, S> {
    @API(help="Model builder parameters.", direction=API.Direction.OUTPUT)
    public ModelParametersSchemaV3 parameters;
    @API(help="Info, warning and error messages; NOTE: can be appended to while the Job is running", direction=API.Direction.OUTPUT)
    public ValidationMessageV3[] messages;
    @API(help="Count of error messages", direction=API.Direction.OUTPUT)
    public int error_count;

    @Override
    public S fillFromImpl(J builder) {
        super.fillFromImpl(builder);
        ModelBuilder.ValidationMessage[] vms = ((ModelBuilder)builder)._messages;
        this.messages = new ValidationMessageV3[vms.length];
        for (int i2 = 0; i2 < vms.length; ++i2) {
            this.messages[i2] = new ValidationMessageV3().fillFromImpl(vms[i2]);
        }
        ValidationMessageV3.mapValidationMessageFieldNames(this.messages, new String[]{"_train", "_valid"}, new String[]{"training_frame", "validation_frame"});
        this.error_count = ((ModelBuilder)builder).error_count();
        ModelBuilderSchema s2 = (ModelBuilderSchema)SchemaServer.schema(this.getSchemaVersion(), builder).fillFromImpl(builder);
        this.parameters = s2.parameters;
        return (S)this;
    }
}

