/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.Model;
import hex.PartialDependence;
import hex.grid.Grid;
import hex.segments.SegmentModels;
import java.lang.reflect.Constructor;
import water.DKV;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.Value;
import water.api.API;
import water.api.schemas3.SchemaV3;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.DecryptionTool;
import water.rapids.Assembly;
import water.util.ReflectionUtils;

public class KeyV3<I extends Iced, S extends KeyV3<I, S, K>, K extends Keyed>
extends SchemaV3<I, KeyV3<I, S, K>> {
    @API(help="Name (string representation) for this Key.", direction=API.Direction.INOUT)
    public String name;
    @API(help="Name (string representation) for the type of Keyed this Key points to.", direction=API.Direction.INOUT)
    public String type;
    @API(help="URL for the resource that this Key points to, if one exists.", direction=API.Direction.INOUT)
    public String URL;

    public KeyV3() {
        String newType;
        this.__meta.schema_type = newType = "Key<" + this.getKeyedClassType() + ">";
        this.setSchemaType_doNotCall(newType);
    }

    public KeyV3(Key key) {
        this();
        if (null != key) {
            Class<Keyed> clz = this.getKeyedClass();
            Value v2 = DKV.get(key);
            if (null != v2) {
                if (Job.class.isAssignableFrom(clz) && !v2.isJob()) {
                    throw new H2OIllegalArgumentException("For Key: " + key + " expected a value of type Job; found a: " + v2.theFreezableClass(), "For Key: " + key + " expected a value of type Job; found a: " + v2.theFreezableClass() + " (" + clz + ")");
                }
                if (Frame.class.isAssignableFrom(clz) && !v2.isFrame() && !v2.isVec()) {
                    throw new H2OIllegalArgumentException("For Key: " + key + " expected a value of type Frame; found a: " + v2.theFreezableClass(), "For Key: " + key + " expected a value of type Frame; found a: " + v2.theFreezableClass() + " (" + clz + ")");
                }
                if (Model.class.isAssignableFrom(clz) && !v2.isModel()) {
                    throw new H2OIllegalArgumentException("For Key: " + key + " expected a value of type Model; found a: " + v2.theFreezableClass(), "For Key: " + key + " expected a value of type Model; found a: " + v2.theFreezableClass() + " (" + clz + ")");
                }
                if (Vec.class.isAssignableFrom(clz) && !v2.isVec()) {
                    throw new H2OIllegalArgumentException("For Key: " + key + " expected a value of type Vec; found a: " + v2.theFreezableClass(), "For Key: " + key + " expected a value of type Vec; found a: " + v2.theFreezableClass() + " (" + clz + ")");
                }
            }
            this.fillFromImpl(key);
        }
    }

    public static KeyV3 make(Class<? extends KeyV3> clz, Key key) {
        try {
            Constructor<? extends KeyV3> c2 = clz.getConstructor(Key.class);
            return c2.newInstance(key);
        }
        catch (Exception e2) {
            throw new H2OIllegalArgumentException("Caught exception trying to instantiate KeyV3 for class: " + clz.toString() + ": cause: " + e2.getCause());
        }
    }

    public static KeyV3 make(Key key) {
        return KeyV3.make(KeyV3.class, key);
    }

    @Override
    public S fillFromImpl(Iced i2) {
        Class<Keyed> keyed_class;
        String vc;
        if (!(i2 instanceof Key)) {
            throw new H2OIllegalArgumentException("fillFromImpl", "key", i2);
        }
        Key key = (Key)i2;
        if (null == key) {
            return (S)this;
        }
        this.name = key.toString();
        this.type = "Key<" + this.getKeyedClassType() + ">";
        if ("Keyed".equals(this.type) && null != (vc = key.valueClassSimple())) {
            this.type = "Key<" + vc + ">";
        }
        this.URL = Job.class.isAssignableFrom(keyed_class = this.getKeyedClass()) ? "/3/Jobs/" + key.toString() : (Frame.class.isAssignableFrom(keyed_class) ? "/3/Frames/" + key.toString() : (Model.class.isAssignableFrom(keyed_class) ? "/3/Models/" + key.toString() : (PartialDependence.class.isAssignableFrom(keyed_class) ? "/3/PartialDependence/" + key.toString() : (Vec.class.isAssignableFrom(keyed_class) ? null : null))));
        return (S)this;
    }

    public static Class<? extends Keyed> getKeyedClass(Class<? extends KeyV3> clz) {
        if (clz == KeyV3.class) {
            return Keyed.class;
        }
        return ReflectionUtils.findActualClassParameter(clz, 2);
    }

    public Class<? extends Keyed> getKeyedClass() {
        return KeyV3.getKeyedClass(this.getClass());
    }

    public static String getKeyedClassType(Class<? extends KeyV3> clz) {
        Class<Keyed> keyed_class = KeyV3.getKeyedClass(clz);
        return keyed_class.getSimpleName();
    }

    public String getKeyedClassType() {
        return KeyV3.getKeyedClassType(this.getClass());
    }

    public Key<K> key() {
        if (null == this.name) {
            return null;
        }
        return Key.make(this.name);
    }

    @Override
    public I createImpl() {
        return (I)Key.make(this.name);
    }

    public String toString() {
        return this.type + " " + this.name;
    }

    public static class DecryptionToolKeyV3
    extends KeyV3<Iced, DecryptionToolKeyV3, DecryptionTool> {
        public DecryptionToolKeyV3() {
        }

        public DecryptionToolKeyV3(Key<DecryptionTool> key) {
            super(key);
        }
    }

    public static class PartialDependenceKeyV3
    extends KeyV3<Iced, PartialDependenceKeyV3, PartialDependence> {
        public PartialDependenceKeyV3() {
        }

        public PartialDependenceKeyV3(Key<PartialDependence> key) {
            super(key);
        }
    }

    public static class AssemblyKeyV3
    extends KeyV3<Iced, AssemblyKeyV3, Assembly> {
        public AssemblyKeyV3() {
        }

        public AssemblyKeyV3(Key<Assembly> key) {
            super(key);
        }
    }

    public static class SegmentModelsKeyV3
    extends KeyV3<Iced, SegmentModelsKeyV3, SegmentModels> {
        public SegmentModelsKeyV3() {
        }

        public SegmentModelsKeyV3(Key<SegmentModels> key) {
            super(key);
        }
    }

    public static class GridKeyV3
    extends KeyV3<Iced, GridKeyV3, Grid> {
        public GridKeyV3() {
        }

        public GridKeyV3(Key<Grid> key) {
            super(key);
        }
    }

    public static class ModelKeyV3<T extends Model>
    extends KeyV3<Iced, ModelKeyV3<T>, T> {
        public ModelKeyV3() {
        }

        public ModelKeyV3(Key<T> key) {
            super(key);
        }
    }

    public static class FrameKeyV3
    extends KeyV3<Iced, FrameKeyV3, Frame> {
        public FrameKeyV3() {
        }

        public FrameKeyV3(Key<Frame> key) {
            super(key);
        }
    }

    public static class JobKeyV3
    extends KeyV3<Iced, JobKeyV3, Job> {
        public JobKeyV3() {
        }

        public JobKeyV3(Key<Job> key) {
            super(key);
        }
    }
}

