/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.util.UUID;
import water.H2O;
import water.api.Handler;
import water.api.schemas3.NodePersistentStorageV3;
import water.init.NodePersistentStorage;

public class NodePersistentStorageHandler
extends Handler {
    public NodePersistentStorageV3 configured(int version, NodePersistentStorageV3 s2) {
        NodePersistentStorage nps = H2O.getNPS();
        s2.configured = nps.configured();
        return s2;
    }

    public NodePersistentStorageV3 exists(int version, NodePersistentStorageV3 s2) {
        NodePersistentStorage nps = H2O.getNPS();
        s2.exists = s2.name != null ? nps.exists(s2.category, s2.name) : nps.exists(s2.category);
        return s2;
    }

    public NodePersistentStorageV3 put(int version, NodePersistentStorageV3 s2) {
        NodePersistentStorage nps = H2O.getNPS();
        UUID uuid = UUID.randomUUID();
        s2.name = uuid.toString();
        nps.put(s2.category, s2.name, s2.value);
        return s2;
    }

    public NodePersistentStorageV3 put_with_name(int version, NodePersistentStorageV3 s2) {
        NodePersistentStorage nps = H2O.getNPS();
        nps.put(s2.category, s2.name, s2.value);
        return s2;
    }

    public NodePersistentStorageV3 get_as_string(int version, NodePersistentStorageV3 s2) {
        NodePersistentStorage nps = H2O.getNPS();
        s2.value = nps.get_as_string(s2.category, s2.name);
        return s2;
    }

    public NodePersistentStorageV3 list(int version, NodePersistentStorageV3 s2) {
        NodePersistentStorage nps = H2O.getNPS();
        NodePersistentStorage.NodePersistentStorageEntry[] entries = nps.list(s2.category);
        s2.entries = new NodePersistentStorageV3.NodePersistentStorageEntryV3[entries.length];
        int i2 = 0;
        for (NodePersistentStorage.NodePersistentStorageEntry entry : entries) {
            NodePersistentStorageV3.NodePersistentStorageEntryV3 e2 = new NodePersistentStorageV3.NodePersistentStorageEntryV3();
            e2.category = entry._category;
            e2.name = entry._name;
            e2.size = entry._size;
            e2.timestamp_millis = entry._timestamp_millis;
            s2.entries[i2] = e2;
            ++i2;
        }
        return s2;
    }

    public NodePersistentStorageV3 delete(int version, NodePersistentStorageV3 s2) {
        NodePersistentStorage nps = H2O.getNPS();
        nps.delete(s2.category, s2.name);
        return s2;
    }
}

