/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.AUUC;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsBinomialUplift;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsOrdinal;
import hex.ModelMetricsRegression;
import hex.ModelMetricsSupervised;
import hex.MultinomialAucType;
import hex.genmodel.utils.DistributionFamily;
import org.apache.commons.lang.ArrayUtils;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.KeySnapshot;
import water.Value;
import water.api.API;
import water.api.Handler;
import water.api.Schema;
import water.api.SchemaServer;
import water.api.schemas3.FrameV3;
import water.api.schemas3.JobV3;
import water.api.schemas3.KeyV3;
import water.api.schemas3.ModelMetricsBaseV3;
import water.api.schemas3.ModelMetricsBinomialUpliftV3;
import water.api.schemas3.ModelMetricsBinomialV3;
import water.api.schemas3.ModelMetricsMultinomialV3;
import water.api.schemas3.ModelMetricsOrdinalV3;
import water.api.schemas3.ModelMetricsRegressionV3;
import water.api.schemas3.ModelParamsValuesProviders;
import water.api.schemas3.RequestSchemaV3;
import water.api.schemas3.SchemaV3;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.udf.CFuncRef;
import water.util.Log;

class ModelMetricsHandler
extends Handler {
    ModelMetricsHandler() {
    }

    public static ModelMetrics getFromDKV(Key key) {
        if (null == key) {
            throw new IllegalArgumentException("Got null key.");
        }
        Value v2 = DKV.get(key);
        if (null == v2) {
            throw new IllegalArgumentException("Did not find key: " + key.toString());
        }
        Object ice = v2.get();
        if (!(ice instanceof ModelMetrics)) {
            throw new IllegalArgumentException("Expected a Model for key: " + key.toString() + "; got a: " + ice.getClass());
        }
        return (ModelMetrics)ice;
    }

    public ModelMetricsListSchemaV3 fetch(int version, ModelMetricsListSchemaV3 s2) {
        ModelMetricsList m4 = (ModelMetricsList)s2.createAndFillImpl();
        s2.fillFromImpl(m4.fetch());
        return s2;
    }

    public ModelMetricsListSchemaV3 delete(int version, ModelMetricsListSchemaV3 s2) {
        ModelMetricsList m4 = (ModelMetricsList)s2.createAndFillImpl();
        s2.fillFromImpl(m4.delete());
        return s2;
    }

    public ModelMetricsListSchemaV3 score(int version, ModelMetricsListSchemaV3 s2) {
        if (null == s2.model) {
            throw new H2OIllegalArgumentException("model", "predict", s2.model);
        }
        if (null == DKV.get(s2.model.name)) {
            throw new H2OKeyNotFoundArgumentException("model", "predict", s2.model.name);
        }
        if (null == s2.frame) {
            throw new H2OIllegalArgumentException("frame", "predict", s2.frame);
        }
        if (null == DKV.get(s2.frame.name)) {
            throw new H2OKeyNotFoundArgumentException("frame", "predict", s2.frame.name);
        }
        ModelMetricsList parms = (ModelMetricsList)s2.createAndFillImpl();
        String customMetricFunc = s2.custom_metric_func;
        if (customMetricFunc == null) {
            customMetricFunc = ((Model.Parameters)parms._model._parms)._custom_metric_func;
        }
        MultinomialAucType at = ((Model.Parameters)parms._model._parms)._auc_type;
        if (s2.auc_type != null) {
            ((Model.Parameters)parms._model._parms)._auc_type = MultinomialAucType.valueOf(s2.auc_type.toUpperCase());
        }
        AUUC.AUUCType auucType = ((Model.Parameters)parms._model._parms)._auuc_type;
        int auucNbins = ((Model.Parameters)parms._model._parms)._auuc_nbins;
        if (s2.auuc_type != null) {
            ((Model.Parameters)parms._model._parms)._auuc_type = AUUC.AUUCType.valueOf(s2.auuc_type);
            ((Model.Parameters)parms._model._parms)._auuc_nbins = s2.auuc_nbins;
        }
        parms._model.score(parms._frame, parms._predictions_name, null, true, CFuncRef.from(customMetricFunc)).remove();
        ModelMetricsListSchemaV3 mm4 = this.fetch(version, s2);
        if (null == mm4) {
            mm4 = new ModelMetricsListSchemaV3();
        }
        if (null == mm4.model_metrics || 0 == mm4.model_metrics.length) {
            Log.warn("Score() did not return a ModelMetrics for model: " + s2.model + " on frame: " + s2.frame);
        }
        ((Model.Parameters)parms._model._parms)._auc_type = at;
        ((Model.Parameters)parms._model._parms)._auuc_type = auucType;
        ((Model.Parameters)parms._model._parms)._auuc_nbins = auucNbins;
        return mm4;
    }

    public ModelMetricsMakerSchemaV3 make(int version, ModelMetricsMakerSchemaV3 s2) {
        ModelMetricsSupervised mm4;
        if (null == s2.predictions_frame) {
            throw new H2OIllegalArgumentException("predictions_frame", "make", s2.predictions_frame);
        }
        Frame pred = (Frame)DKV.getGet(s2.predictions_frame);
        if (null == pred) {
            throw new H2OKeyNotFoundArgumentException("predictions_frame", "make", s2.predictions_frame);
        }
        if (null == s2.actuals_frame) {
            throw new H2OIllegalArgumentException("actuals_frame", "make", s2.actuals_frame);
        }
        Frame act = (Frame)DKV.getGet(s2.actuals_frame);
        if (null == act) {
            throw new H2OKeyNotFoundArgumentException("actuals_frame", "make", s2.actuals_frame);
        }
        Vec weights = null;
        if (null != s2.weights_frame) {
            Frame weightsFrame = (Frame)DKV.getGet(s2.weights_frame);
            if (null == weightsFrame) {
                throw new H2OKeyNotFoundArgumentException("weights_frame", "make", s2.weights_frame);
            }
            weights = weightsFrame.anyVec();
        }
        Vec treatment = null;
        if (null != s2.treatment_frame) {
            Frame treatmentFrame = (Frame)DKV.getGet(s2.treatment_frame);
            if (null == treatmentFrame) {
                throw new H2OKeyNotFoundArgumentException("treatment_frame", "make", s2.treatment_frame);
            }
            treatment = treatmentFrame.anyVec();
            if (s2.auuc_type == null) {
                s2.auuc_type = AUUC.AUUCType.AUTO;
            }
            if (s2.auuc_nbins < -1 || s2.auuc_nbins == 0) {
                throw new H2OIllegalArgumentException("auuc_bins", "make", "The value has to be -1 or higher than 0.");
            }
        }
        if (s2.domain == null) {
            if (pred.numCols() != 1) {
                throw new H2OIllegalArgumentException("predictions_frame", "make", "For regression problems (domain=null), the predictions_frame must have exactly 1 column.");
            }
            mm4 = ModelMetricsRegression.make(pred.anyVec(), act.anyVec(), weights, s2.distribution);
            s2.model_metrics = new ModelMetricsRegressionV3().fillFromImpl((ModelMetricsRegression)mm4);
        } else if (s2.domain.length == 2) {
            if (treatment != null) {
                mm4 = ModelMetricsBinomialUplift.make(pred.anyVec(), act.anyVec(), treatment, s2.domain, s2.auuc_type, s2.auuc_nbins);
                s2.model_metrics = new ModelMetricsBinomialUpliftV3().fillFromImpl((ModelMetricsBinomialUplift)mm4);
            } else {
                if (pred.numCols() != 1) {
                    throw new H2OIllegalArgumentException("predictions_frame", "make", "For domains with 2 class labels, the predictions_frame must have exactly one column containing the class-1 probabilities.");
                }
                mm4 = ModelMetricsBinomial.make(pred.anyVec(), act.anyVec(), weights, s2.domain);
                s2.model_metrics = new ModelMetricsBinomialV3().fillFromImpl((ModelMetricsBinomial)mm4);
            }
        } else if (s2.domain.length > 2) {
            if (pred.numCols() != s2.domain.length) {
                throw new H2OIllegalArgumentException("predictions_frame", "make", "For domains with " + s2.domain.length + " class labels, the predictions_frame must have exactly " + s2.domain.length + " columns containing the class-probabilities.");
            }
            if (s2.distribution == DistributionFamily.ordinal) {
                mm4 = ModelMetricsOrdinal.make(pred, act.anyVec(), s2.domain);
                s2.model_metrics = new ModelMetricsOrdinalV3().fillFromImpl((ModelMetricsRegression)mm4);
            } else {
                mm4 = ModelMetricsMultinomial.make(pred, act.anyVec(), weights, s2.domain, s2.auc_type);
                s2.model_metrics = new ModelMetricsMultinomialV3().fillFromImpl((ModelMetricsRegression)mm4);
            }
        } else {
            throw H2O.unimpl();
        }
        return s2;
    }

    public JobV3 predictAsync(int version, final ModelMetricsListSchemaV3 s2) {
        if (null == s2.model) {
            throw new H2OIllegalArgumentException("model", "predict", s2.model);
        }
        if (null == DKV.get(s2.model.name)) {
            throw new H2OKeyNotFoundArgumentException("model", "predict", s2.model.name);
        }
        if (null == s2.frame) {
            throw new H2OIllegalArgumentException("frame", "predict", s2.frame);
        }
        if (null == DKV.get(s2.frame.name)) {
            throw new H2OKeyNotFoundArgumentException("frame", "predict", s2.frame.name);
        }
        if (s2.deviances || null != s2.deviances_frame) {
            throw new H2OIllegalArgumentException("deviances", "not supported for async", s2.deviances_frame);
        }
        final ModelMetricsList parms = (ModelMetricsList)s2.createAndFillImpl();
        long workAmount = parms._frame.anyVec().nChunks();
        if (s2.predict_contributions) {
            workAmount = parms._frame.anyVec().length();
            if (null == parms._predictions_name) {
                parms._predictions_name = "contributions_" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_on_" + parms._frame._key.toString();
            }
        } else if (s2.deep_features_hidden_layer > 0 || s2.deep_features_hidden_layer_name != null) {
            if (null == parms._predictions_name) {
                parms._predictions_name = "deep_features" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_on_" + parms._frame._key.toString();
            }
        } else if (null == parms._predictions_name) {
            parms._predictions_name = "transformation" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_on_" + parms._frame._key.toString();
        }
        final Job j2 = new Job(Key.make(parms._predictions_name), Frame.class.getName(), "transformation");
        H2O.H2OCountedCompleter work = new H2O.H2OCountedCompleter(){

            @Override
            public void compute2() {
                Frame predictions;
                if (s2.predict_contributions) {
                    if (!(parms._model instanceof Model.Contributions)) {
                        throw new H2OIllegalArgumentException("Model type " + ((Model.Parameters)parms._model._parms).algoName() + " doesn't support calculating Feature Contributions.");
                    }
                    Model.Contributions mc = (Model.Contributions)((Object)parms._model);
                    Model.Contributions.ContributionsOutputFormat outputFormat = null == s2.predict_contributions_output_format ? Model.Contributions.ContributionsOutputFormat.Original : s2.predict_contributions_output_format;
                    Model.Contributions.ContributionsOptions options = new Model.Contributions.ContributionsOptions();
                    options.setOutputFormat(outputFormat).setTopN(parms._top_n).setBottomN(parms._bottom_n).setCompareAbs(parms._compare_abs);
                    mc.scoreContributions(parms._frame, Key.make(parms._predictions_name), j2, options);
                } else if (s2.deep_features_hidden_layer < 0 && s2.deep_features_hidden_layer_name == null) {
                    parms._model.score(parms._frame, parms._predictions_name, j2, false, CFuncRef.from(s2.custom_metric_func));
                } else if (s2.deep_features_hidden_layer_name != null) {
                    try {
                        predictions = ((Model.DeepFeatures)((Object)parms._model)).scoreDeepFeatures(parms._frame, s2.deep_features_hidden_layer_name, j2);
                    }
                    catch (IllegalArgumentException e2) {
                        Log.warn(e2.getMessage());
                        throw e2;
                    }
                    if (predictions != null) {
                        predictions = new Frame(Key.make(parms._predictions_name), predictions.names(), predictions.vecs());
                        DKV.put(predictions._key, predictions);
                    }
                } else {
                    predictions = ((Model.DeepFeatures)((Object)parms._model)).scoreDeepFeatures(parms._frame, s2.deep_features_hidden_layer, j2);
                    predictions = new Frame(Key.make(parms._predictions_name), predictions.names(), predictions.vecs());
                    DKV.put(predictions._key, predictions);
                }
                if (parms._model._warningsP != null && parms._model._warningsP.length > 0) {
                    String[] allWarnings = (String[])ArrayUtils.addAll((Object[])j2.warns(), (Object[])parms._model._warningsP);
                    j2.setWarnings(allWarnings);
                }
                this.tryComplete();
            }
        };
        j2.start(work, workAmount);
        return new JobV3().fillFromImpl(j2);
    }

    public ModelMetricsListSchemaV3 predict(int version, ModelMetricsListSchemaV3 s2) {
        Frame predictions;
        if (s2.model == null) {
            throw new H2OIllegalArgumentException("model", "predict", null);
        }
        if (DKV.get(s2.model.name) == null) {
            throw new H2OKeyNotFoundArgumentException("model", "predict", s2.model.name);
        }
        if (s2.exemplar_index < 0) {
            if (s2.frame == null) {
                throw new H2OIllegalArgumentException("frame", "predict", null);
            }
            if (DKV.get(s2.frame.name) == null) {
                throw new H2OKeyNotFoundArgumentException("frame", "predict", s2.frame.name);
            }
        }
        ModelMetricsList parms = (ModelMetricsList)s2.createAndFillImpl();
        Frame deviances = null;
        if (!(s2.reconstruction_error || s2.reconstruction_error_per_feature || s2.deep_features_hidden_layer >= 0 || s2.project_archetypes || s2.reconstruct_train || s2.leaf_node_assignment || s2.predict_staged_proba || s2.predict_contributions || s2.feature_frequencies || s2.exemplar_index >= 0)) {
            String customMetricFunc;
            if (null == parms._predictions_name) {
                parms._predictions_name = "predictions" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_on_" + parms._frame._key.toString();
            }
            if ((customMetricFunc = s2.custom_metric_func) == null) {
                customMetricFunc = ((Model.Parameters)parms._model._parms)._custom_metric_func;
            }
            predictions = parms._model.score(parms._frame, parms._predictions_name, null, true, CFuncRef.from(customMetricFunc));
            if (s2.deviances) {
                if (!parms._model.isSupervised()) {
                    throw new H2OIllegalArgumentException("Deviances can only be computed for supervised models.");
                }
                if (null == parms._deviances_name) {
                    parms._deviances_name = "deviances" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_on_" + parms._frame._key.toString();
                }
                deviances = parms._model.computeDeviances(parms._frame, predictions, parms._deviances_name);
            }
        } else {
            if (s2.deviances) {
                throw new H2OIllegalArgumentException("Cannot compute deviances in combination with other special predictions.");
            }
            if (Model.DeepFeatures.class.isAssignableFrom(parms._model.getClass())) {
                if (s2.reconstruction_error || s2.reconstruction_error_per_feature) {
                    if (s2.deep_features_hidden_layer >= 0) {
                        throw new H2OIllegalArgumentException("Can only compute either reconstruction error OR deep features.", "");
                    }
                    if (null == parms._predictions_name) {
                        parms._predictions_name = "reconstruction_error" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_on_" + parms._frame._key.toString();
                    }
                    predictions = ((Model.DeepFeatures)((Object)parms._model)).scoreAutoEncoder(parms._frame, Key.make(parms._predictions_name), parms._reconstruction_error_per_feature);
                } else {
                    if (s2.deep_features_hidden_layer < 0) {
                        throw new H2OIllegalArgumentException("Deep features hidden layer index must be >= 0.", "");
                    }
                    if (null == parms._predictions_name) {
                        parms._predictions_name = "deep_features" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_on_" + parms._frame._key.toString();
                    }
                    predictions = ((Model.DeepFeatures)((Object)parms._model)).scoreDeepFeatures(parms._frame, s2.deep_features_hidden_layer);
                }
                predictions = new Frame(Key.make(parms._predictions_name), predictions.names(), predictions.vecs());
                DKV.put(predictions._key, predictions);
            } else if (Model.GLRMArchetypes.class.isAssignableFrom(parms._model.getClass())) {
                if (s2.project_archetypes) {
                    if (parms._predictions_name == null) {
                        parms._predictions_name = "reconstructed_archetypes_" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_of_" + parms._frame._key.toString();
                    }
                    predictions = ((Model.GLRMArchetypes)((Object)parms._model)).scoreArchetypes(parms._frame, Key.make(parms._predictions_name), s2.reverse_transform);
                } else {
                    assert (s2.reconstruct_train);
                    if (parms._predictions_name == null) {
                        parms._predictions_name = "reconstruction_" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_of_" + parms._frame._key.toString();
                    }
                    predictions = ((Model.GLRMArchetypes)((Object)parms._model)).scoreReconstruction(parms._frame, Key.make(parms._predictions_name), s2.reverse_transform);
                }
            } else if (s2.leaf_node_assignment) {
                assert (Model.LeafNodeAssignment.class.isAssignableFrom(parms._model.getClass()));
                if (null == parms._predictions_name) {
                    parms._predictions_name = "leaf_node_assignment" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_on_" + parms._frame._key.toString();
                }
                Model.LeafNodeAssignment.LeafNodeAssignmentType type = null == s2.leaf_node_assignment_type ? Model.LeafNodeAssignment.LeafNodeAssignmentType.Path : s2.leaf_node_assignment_type;
                predictions = ((Model.LeafNodeAssignment)((Object)parms._model)).scoreLeafNodeAssignment(parms._frame, type, Key.make(parms._predictions_name));
            } else if (s2.feature_frequencies) {
                assert (Model.FeatureFrequencies.class.isAssignableFrom(parms._model.getClass()));
                if (null == parms._predictions_name) {
                    parms._predictions_name = "feature_frequencies" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_on_" + parms._frame._key.toString();
                }
                predictions = ((Model.FeatureFrequencies)((Object)parms._model)).scoreFeatureFrequencies(parms._frame, Key.make(parms._predictions_name));
            } else if (s2.predict_staged_proba) {
                if (!(parms._model instanceof Model.StagedPredictions)) {
                    throw new H2OIllegalArgumentException("Model type " + ((Model.Parameters)parms._model._parms).algoName() + " doesn't support Staged Predictions.");
                }
                if (null == parms._predictions_name) {
                    parms._predictions_name = "staged_proba_" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_on_" + parms._frame._key.toString();
                }
                predictions = ((Model.StagedPredictions)((Object)parms._model)).scoreStagedPredictions(parms._frame, Key.make(parms._predictions_name));
            } else if (s2.predict_contributions) {
                if (!(parms._model instanceof Model.Contributions)) {
                    throw new H2OIllegalArgumentException("Model type " + ((Model.Parameters)parms._model._parms).algoName() + " doesn't support calculating Feature Contributions.");
                }
                Model.Contributions mc = (Model.Contributions)((Object)parms._model);
                if (null == parms._predictions_name) {
                    parms._predictions_name = "contributions_" + Key.make().toString().substring(0, 5) + "_" + parms._model._key.toString() + "_on_" + parms._frame._key.toString();
                }
                Model.Contributions.ContributionsOutputFormat outputFormat = null == s2.predict_contributions_output_format ? Model.Contributions.ContributionsOutputFormat.Original : s2.predict_contributions_output_format;
                Model.Contributions.ContributionsOptions options = new Model.Contributions.ContributionsOptions().setOutputFormat(outputFormat);
                predictions = mc.scoreContributions(parms._frame, Key.make(parms._predictions_name), null, options);
            } else if (s2.exemplar_index >= 0) {
                assert (Model.ExemplarMembers.class.isAssignableFrom(parms._model.getClass()));
                if (null == parms._predictions_name) {
                    parms._predictions_name = "members_" + parms._model._key.toString() + "_for_exemplar_" + parms._exemplar_index;
                }
                predictions = ((Model.ExemplarMembers)((Object)parms._model)).scoreExemplarMembers(Key.make(parms._predictions_name), parms._exemplar_index);
            } else {
                throw new H2OIllegalArgumentException("Requires a Deep Learning, GLRM, DRF or GBM model.", "Model must implement specific methods.");
            }
        }
        ModelMetricsListSchemaV3 mm4 = this.fetch(version, s2);
        if (null == mm4) {
            mm4 = new ModelMetricsListSchemaV3();
        }
        mm4.predictions_frame = new KeyV3.FrameKeyV3((Key<Frame>)predictions._key);
        if (parms._leaf_node_assignment) {
            mm4.model_metrics = null;
        }
        if (deviances != null) {
            mm4.deviances_frame = new KeyV3.FrameKeyV3((Key<Frame>)deviances._key);
        }
        if (null != mm4.model_metrics && 0 != mm4.model_metrics.length) {
            mm4.model_metrics[0].predictions = new FrameV3(predictions, 0L, 100);
        }
        return mm4;
    }

    public static final class ModelMetricsMakerSchemaV3
    extends SchemaV3<ModelMetricsMaker, ModelMetricsMakerSchemaV3> {
        @API(help="Predictions Frame.", direction=API.Direction.INOUT)
        public String predictions_frame;
        @API(help="Actuals Frame.", direction=API.Direction.INOUT)
        public String actuals_frame;
        @API(help="Weights Frame.", direction=API.Direction.INOUT)
        public String weights_frame;
        @API(help="Treatment Frame.", direction=API.Direction.INOUT)
        public String treatment_frame;
        @API(help="Domain (for classification).", direction=API.Direction.INOUT)
        public String[] domain;
        @API(help="Distribution (for regression).", direction=API.Direction.INOUT, values={"gaussian", "poisson", "gamma", "laplace"})
        public DistributionFamily distribution;
        @API(help="Default AUC type (for multinomial classification).", valuesProvider=ModelParamsValuesProviders.MultinomialAucTypeSchemeValuesProvider.class, level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
        public MultinomialAucType auc_type;
        @API(help="Default AUUC type (for uplift binomial classification).", valuesProvider=ModelParamsValuesProviders.UpliftAuucTypeSchemeValuesProvider.class, level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
        public AUUC.AUUCType auuc_type;
        @API(help="Number of bins to calculate AUUC (for uplift binomial classification).", level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
        public int auuc_nbins;
        @API(help="Model Metrics.", direction=API.Direction.OUTPUT)
        public ModelMetricsBaseV3 model_metrics;
    }

    public static final class ModelMetricsMaker
    extends Iced {
        public String _predictions_frame;
        public String _actuals_frame;
        public String[] _domain;
        public DistributionFamily _distribution;
        public MultinomialAucType _auc_type;
        public AUUC.AUUCType _auuc_type;
        public int _auuc_nbins;
        public ModelMetrics _model_metrics;
    }

    public static final class ModelMetricsListSchemaV3
    extends RequestSchemaV3<ModelMetricsList, ModelMetricsListSchemaV3> {
        @API(help="Key of Model of interest (optional)")
        public KeyV3.ModelKeyV3<Model> model;
        @API(help="Key of Frame of interest (optional)")
        public KeyV3.FrameKeyV3 frame;
        @API(help="Key of predictions frame, if predictions are requested (optional)", direction=API.Direction.INOUT)
        public KeyV3.FrameKeyV3 predictions_frame;
        @API(help="Key for the frame containing per-observation deviances (optional)", direction=API.Direction.INOUT)
        public KeyV3.FrameKeyV3 deviances_frame;
        @API(help="Compute reconstruction error (optional, only for Deep Learning AutoEncoder models)", json=false)
        public boolean reconstruction_error;
        @API(help="Compute reconstruction error per feature (optional, only for Deep Learning AutoEncoder models)", json=false)
        public boolean reconstruction_error_per_feature;
        @API(help="Extract Deep Features for given hidden layer (optional, only for Deep Learning models)", json=false)
        public int deep_features_hidden_layer;
        @API(help="Extract Deep Features for given hidden layer by name (optional, only for Deep Water models)", json=false)
        public String deep_features_hidden_layer_name;
        @API(help="Reconstruct original training frame (optional, only for GLRM models)", json=false)
        public boolean reconstruct_train;
        @API(help="Project GLRM archetypes back into original feature space (optional, only for GLRM models)", json=false)
        public boolean project_archetypes;
        @API(help="Reverse transformation applied during training to model output (optional, only for GLRM models)", json=false)
        public boolean reverse_transform;
        @API(help="Return the leaf node assignment (optional, only for DRF/GBM models)", json=false)
        public boolean leaf_node_assignment;
        @API(help="Type of the leaf node assignment (optional, only for DRF/GBM models)", values={"Path", "Node_ID"}, json=false)
        public Model.LeafNodeAssignment.LeafNodeAssignmentType leaf_node_assignment_type;
        @API(help="Predict the class probabilities at each stage (optional, only for GBM models)", json=false)
        public boolean predict_staged_proba;
        @API(help="Predict the feature contributions - Shapley values (optional, only for DRF, GBM and XGBoost models)", json=false)
        public boolean predict_contributions;
        @API(help="Specify how to output feature contributions in XGBoost - XGBoost by default outputs contributions for 1-hot encoded features, specifying a Compact output format will produce a per-feature contribution", values={"Original", "Compact"}, json=false)
        public Model.Contributions.ContributionsOutputFormat predict_contributions_output_format;
        @API(help="Only for predict_contributions function - sort Shapley values and return top_n highest (optional)", json=false)
        public int top_n;
        @API(help="Only for predict_contributions function - sort Shapley values and return bottom_n lowest (optional)", json=false)
        public int bottom_n;
        @API(help="Only for predict_contributions function - sort absolute Shapley values (optional)", json=false)
        public boolean compare_abs;
        @API(help="Retrieve the feature frequencies on paths in trees in tree-based models (optional, only for GBM, DRF and Isolation Forest)", json=false)
        public boolean feature_frequencies;
        @API(help="Retrieve all members for a given exemplar (optional, only for Aggregator models)", json=false)
        public int exemplar_index;
        @API(help="Compute the deviances per row (optional, only for classification or regression models)", json=false)
        public boolean deviances;
        @API(help="Reference to custom evaluation function, format: `language:keyName=funcName`", json=false)
        public String custom_metric_func;
        @API(help="Set default multinomial AUC type. Must be one of: \"AUTO\", \"NONE\", \"MACRO_OVR\", \"WEIGHTED_OVR\", \"MACRO_OVO\", \"WEIGHTED_OVO\". Default is \"NONE\" (optional, only for multinomial classification).", json=false, direction=API.Direction.INPUT)
        public String auc_type;
        @API(help="Set default AUUC type for uplift binomial classification. Must be one of: \"AUTO\", \"qini\", \"lift\", \"gain\". Default is \"AUTO\" (optional, only for uplift binomial classification).", json=false, direction=API.Direction.INPUT)
        public String auuc_type;
        @API(help="Set number of bins to calculate AUUC. Must be -1 or higher than 0. Default is -1 which means 1000 (optional, only for uplift binomial classification).", json=false, direction=API.Direction.INPUT)
        public int auuc_nbins;
        @API(help="ModelMetrics", direction=API.Direction.OUTPUT)
        public ModelMetricsBaseV3[] model_metrics;

        @Override
        public ModelMetricsList fillImpl(ModelMetricsList mml) {
            mml._model = this.model == null || this.model.key() == null ? null : (Model)this.model.key().get();
            mml._frame = this.frame == null || this.frame.key() == null ? null : (Frame)this.frame.key().get();
            mml._predictions_name = null == this.predictions_frame || null == this.predictions_frame.key() ? null : this.predictions_frame.key().toString();
            mml._reconstruction_error = this.reconstruction_error;
            mml._reconstruction_error_per_feature = this.reconstruction_error_per_feature;
            mml._deep_features_hidden_layer = this.deep_features_hidden_layer;
            mml._deep_features_hidden_layer_name = this.deep_features_hidden_layer_name;
            mml._reconstruct_train = this.reconstruct_train;
            mml._project_archetypes = this.project_archetypes;
            mml._reverse_transform = this.reverse_transform;
            mml._leaf_node_assignment = this.leaf_node_assignment;
            mml._exemplar_index = this.exemplar_index;
            mml._deviances = this.deviances;
            mml._auc_type = this.auc_type;
            mml._top_n = this.top_n;
            mml._bottom_n = this.bottom_n;
            mml._compare_abs = this.compare_abs;
            mml._auuc_type = this.auuc_type;
            mml._auuc_nbins = this.auuc_nbins;
            if (this.model_metrics != null) {
                mml._model_metrics = new ModelMetrics[this.model_metrics.length];
                for (int i2 = 0; i2 < this.model_metrics.length; ++i2) {
                    mml._model_metrics[i2++] = (ModelMetrics)this.model_metrics[i2].createImpl();
                }
            }
            return mml;
        }

        @Override
        public ModelMetricsListSchemaV3 fillFromImpl(ModelMetricsList mml) {
            this.model = mml._model == null ? null : new KeyV3.ModelKeyV3(mml._model._key);
            this.frame = mml._frame == null ? null : new KeyV3.FrameKeyV3((Key<Frame>)mml._frame._key);
            this.predictions_frame = mml._predictions_name == null ? null : new KeyV3.FrameKeyV3(Key.make(mml._predictions_name));
            this.deviances_frame = mml._deviances_name == null ? null : new KeyV3.FrameKeyV3(Key.make(mml._deviances_name));
            this.reconstruction_error = mml._reconstruction_error;
            this.reconstruction_error_per_feature = mml._reconstruction_error_per_feature;
            this.deep_features_hidden_layer = mml._deep_features_hidden_layer;
            this.deep_features_hidden_layer_name = mml._deep_features_hidden_layer_name;
            this.reconstruct_train = mml._reconstruct_train;
            this.project_archetypes = mml._project_archetypes;
            this.reverse_transform = mml._reverse_transform;
            this.leaf_node_assignment = mml._leaf_node_assignment;
            this.exemplar_index = mml._exemplar_index;
            this.deviances = mml._deviances;
            this.auc_type = mml._auc_type;
            this.top_n = mml._top_n;
            this.bottom_n = mml._bottom_n;
            this.compare_abs = mml._compare_abs;
            this.auuc_type = mml._auuc_type;
            this.auuc_nbins = mml._auuc_nbins;
            if (null != mml._model_metrics) {
                this.model_metrics = new ModelMetricsBaseV3[mml._model_metrics.length];
                for (int i2 = 0; i2 < this.model_metrics.length; ++i2) {
                    ModelMetrics mm4 = mml._model_metrics[i2];
                    this.model_metrics[i2] = (ModelMetricsBaseV3)SchemaServer.schema(3, mm4.getClass()).fillFromImpl(mm4);
                }
            } else {
                this.model_metrics = new ModelMetricsBaseV3[0];
            }
            return this;
        }
    }

    public static final class ModelMetricsList
    extends Iced {
        public Model _model;
        public Frame _frame;
        public ModelMetrics[] _model_metrics;
        public String _predictions_name;
        public String _deviances_name;
        public boolean _deviances;
        public boolean _reconstruction_error;
        public boolean _reconstruction_error_per_feature;
        public int _deep_features_hidden_layer = -1;
        public String _deep_features_hidden_layer_name = null;
        public boolean _reconstruct_train;
        public boolean _project_archetypes;
        public boolean _reverse_transform;
        public boolean _leaf_node_assignment;
        public int _exemplar_index = -1;
        public String _custom_metric_func;
        public String _auc_type;
        public int _top_n;
        public int _bottom_n;
        public boolean _compare_abs;
        public String _auuc_type;
        public int _auuc_nbins;

        ModelMetricsList fetch() {
            Key[] modelMetricsKeys = KeySnapshot.globalSnapshot().filter(new KeySnapshot.KVFilter(){

                @Override
                public boolean filter(KeySnapshot.KeyInfo k2) {
                    try {
                        if (!Value.isSubclassOf(k2._type, ModelMetrics.class)) {
                            return false;
                        }
                        ModelMetrics mm4 = (ModelMetrics)DKV.getGet(k2._key);
                        if (_model != null && !mm4.isForModel((Model)DKV.getGet(_model._key))) {
                            return false;
                        }
                        if (_frame != null && !mm4.isForFrame((Frame)DKV.getGet(_frame._key))) {
                            return false;
                        }
                    }
                    catch (ClassCastException | NullPointerException ex) {
                        return false;
                    }
                    return true;
                }
            }).keys();
            this._model_metrics = new ModelMetrics[modelMetricsKeys.length];
            for (int i2 = 0; i2 < modelMetricsKeys.length; ++i2) {
                this._model_metrics[i2] = (ModelMetrics)DKV.getGet(modelMetricsKeys[i2]);
            }
            return this;
        }

        ModelMetricsList delete() {
            ModelMetricsList matches = this.fetch();
            for (ModelMetrics mm4 : matches._model_metrics) {
                DKV.remove(mm4._key);
            }
            return matches;
        }

        public Schema list(int version, ModelMetricsList m4) {
            return this.schema(version).fillFromImpl(m4.fetch());
        }

        protected ModelMetricsListSchemaV3 schema(int version) {
            switch (version) {
                case 3: {
                    return new ModelMetricsListSchemaV3();
                }
            }
            throw H2O.fail("Bad version for ModelMetrics schema: " + version);
        }
    }
}

