/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.ModelBuilder;
import java.net.MalformedURLException;
import java.util.Map;
import water.Iced;
import water.TypeMap;
import water.api.GridSearchHandler;
import water.api.Handler;
import water.api.ModelBuilderHandler;
import water.api.RequestServer;
import water.api.RequestUri;
import water.api.Route;
import water.api.Schema;
import water.api.SchemaMetadata;
import water.api.SchemaServer;
import water.api.schemas3.MetadataV3;
import water.api.schemas3.RouteV3;
import water.api.schemas3.SchemaMetadataV3;
import water.api.schemas4.EndpointV4;
import water.api.schemas4.EndpointsListV4;
import water.api.schemas4.ListRequestV4;
import water.util.MarkdownBuilder;

public class MetadataHandler
extends Handler {
    public MetadataV3 listRoutes(int version, MetadataV3 docs) {
        MarkdownBuilder builder = new MarkdownBuilder();
        builder.comment("Preview with http://jbt.github.io/markdown-editor");
        builder.heading1("REST API Routes Table of Contents");
        builder.hline();
        builder.tableHeader("HTTP method", "URI pattern", "Input schema", "Output schema", "Summary");
        docs.routes = new RouteV3[RequestServer.numRoutes()];
        int i2 = 0;
        for (Route route : RequestServer.routes()) {
            RouteV3 schema;
            docs.routes[i2] = schema = new RouteV3(route);
            MetadataV3 look = new MetadataV3();
            look.routes = new RouteV3[1];
            look.routes[0] = schema;
            look.path = route._url;
            look.http_method = route._http_method;
            this.fetchRoute(version, look);
            schema.input_schema = look.routes[0].input_schema;
            schema.output_schema = look.routes[0].output_schema;
            builder.tableRow(route._http_method, route._url, Handler.getHandlerMethodInputSchema(route._handler_method).getSimpleName(), Handler.getHandlerMethodOutputSchema(route._handler_method).getSimpleName(), route._summary);
            ++i2;
        }
        docs.markdown = builder.toString();
        return docs;
    }

    public EndpointsListV4 listRoutes4(int version, ListRequestV4 inp) {
        EndpointsListV4 res = new EndpointsListV4();
        res.endpoints = new EndpointV4[RequestServer.numRoutes(4)];
        int i2 = 0;
        for (Route route : RequestServer.routes()) {
            if (route.getVersion() != version) continue;
            EndpointV4 routeSchema = Schema.newInstance(EndpointV4.class).fillFromImpl(route);
            res.endpoints[i2++] = routeSchema;
        }
        return res;
    }

    public MetadataV3 fetchRoute(int version, MetadataV3 docs) {
        Schema soutput;
        Schema sinput;
        Route route = null;
        if (docs.path != null && docs.http_method != null) {
            try {
                route = RequestServer.lookupRoute(new RequestUri(docs.http_method, docs.path));
            }
            catch (MalformedURLException e2) {
                route = null;
            }
        } else {
            if (docs.path != null) {
                try {
                    docs.num = Integer.parseInt(docs.path);
                }
                catch (NumberFormatException e2) {
                    // empty catch block
                }
            }
            if (docs.num >= 0 && docs.num < RequestServer.numRoutes()) {
                route = RequestServer.routes().get(docs.num);
            }
            docs.routes = new RouteV3[]{new RouteV3(route)};
        }
        if (route == null) {
            return null;
        }
        if (route._handler_class.equals(ModelBuilderHandler.class) || route._handler_class.equals(GridSearchHandler.class)) {
            String[] ss = route._url.split("/");
            String algoURLName = ss[3];
            String algoName = ModelBuilder.algoName(algoURLName);
            String schemaDir = ModelBuilder.schemaDirectory(algoURLName);
            int version2 = Integer.valueOf(ss[1]);
            try {
                String inputSchemaName = schemaDir + algoName + "V" + version2;
                sinput = (Schema)TypeMap.getTheFreezableOrThrow(TypeMap.onIce(inputSchemaName));
            }
            catch (ClassNotFoundException e3) {
                sinput = (Schema)TypeMap.theFreezable(TypeMap.onIce(schemaDir + algoName + "V3"));
            }
            sinput.init_meta();
            soutput = sinput;
        } else {
            sinput = Schema.newInstance(Handler.getHandlerMethodInputSchema(route._handler_method));
            soutput = Schema.newInstance(Handler.getHandlerMethodOutputSchema(route._handler_method));
        }
        docs.routes[0].input_schema = sinput.getClass().getSimpleName();
        docs.routes[0].output_schema = soutput.getClass().getSimpleName();
        docs.routes[0].markdown = route.markdown(sinput, soutput).toString();
        return docs;
    }

    @Deprecated
    public MetadataV3 fetchSchemaMetadataByClass(int version, MetadataV3 docs) {
        SchemaMetadataV3 meta;
        docs.schemas = new SchemaMetadataV3[1];
        docs.schemas[0] = meta = new SchemaMetadataV3(SchemaMetadata.createSchemaMetadata(docs.classname));
        return docs;
    }

    public MetadataV3 fetchSchemaMetadata(int version, MetadataV3 docs) {
        SchemaMetadataV3 meta;
        if ("void".equals(docs.schemaname)) {
            docs.schemas = new SchemaMetadataV3[0];
            return docs;
        }
        docs.schemas = new SchemaMetadataV3[1];
        Schema schema = Schema.newInstance(docs.schemaname);
        try {
            Iced impl = (Iced)schema.getImplClass().newInstance();
            schema.fillFromImpl(impl);
        }
        catch (Exception impl) {
            // empty catch block
        }
        docs.schemas[0] = meta = new SchemaMetadataV3(new SchemaMetadata(schema));
        return docs;
    }

    public MetadataV3 listSchemas(int version, MetadataV3 docs) {
        Map<String, Class<? extends Schema>> ss = SchemaServer.schemas();
        docs.schemas = new SchemaMetadataV3[ss.size()];
        int i2 = 0;
        for (Class<? extends Schema> schema_class : ss.values()) {
            Schema schema = Schema.newInstance(schema_class);
            try {
                Iced impl = (Iced)schema.getImplClass().newInstance();
                schema.fillFromImpl(impl);
            }
            catch (Exception exception) {
                // empty catch block
            }
            docs.schemas[i2++] = new SchemaMetadataV3(new SchemaMetadata(schema));
        }
        return docs;
    }
}

