/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import water.DTask;
import water.H2O;
import water.H2ONode;
import water.RPC;
import water.api.Handler;
import water.api.NanoResponse;
import water.api.schemas3.LogsV3;
import water.util.GetLogsFromNode;
import water.util.LinuxProcFileReader;
import water.util.Log;
import water.util.LogArchiveContainer;
import water.util.LogArchiveWriter;
import water.util.StringUtils;

public class LogsHandler
extends Handler {
    private static H2ONode getH2ONode(String nodeIdx) {
        try {
            int numNodeIdx = Integer.parseInt(nodeIdx);
            if (numNodeIdx < -1 || numNodeIdx >= H2O.CLOUD.size()) {
                throw new IllegalArgumentException("H2O node with the specified index does not exist!");
            }
            if (numNodeIdx == -1) {
                return H2O.SELF;
            }
            return H2O.CLOUD._memary[numNodeIdx];
        }
        catch (NumberFormatException nfe) {
            if (nodeIdx.equals("self")) {
                return H2O.SELF;
            }
            H2ONode node = H2O.CLOUD.getNodeByIpPort(nodeIdx);
            if (node != null) {
                return node;
            }
            H2ONode client = H2O.getClientByIPPort(nodeIdx);
            if (client != null) {
                return client;
            }
            throw new IllegalArgumentException("No H2O node running as part of this cloud on " + nodeIdx + " does not exist!");
        }
    }

    public LogsV3 fetch(int version, LogsV3 s2) {
        H2ONode node = LogsHandler.getH2ONode(s2.nodeidx);
        String filename = s2.name;
        if (filename != null && filename.contains(File.separator)) {
            throw new IllegalArgumentException("Filename may not contain File.separator character.");
        }
        GetLogTask t2 = new GetLogTask();
        t2.name = filename;
        if (H2O.SELF.equals(node)) {
            try {
                t2.doIt();
            }
            catch (Exception e2) {
                Log.err(e2);
            }
        } else {
            Log.trace("GetLogTask starting to node  " + node._key + " ...");
            new RPC<GetLogTask>(node, t2).call().get();
            Log.trace("GetLogTask completed to node " + node._key);
        }
        if (!t2.success) {
            throw new RuntimeException("GetLogTask failed");
        }
        s2.log = t2.log;
        return s2;
    }

    public static URI downloadLogs(String destinationDir, LogArchiveContainer logContainer) {
        String outputFileStem = LogsHandler.getOutputLogStem();
        String outputFileName = outputFileStem + "." + logContainer.getFileExtension();
        byte[] logBytes = LogsHandler.downloadLogs(logContainer, outputFileStem);
        File destination = new File(destinationDir, outputFileName);
        try (FileOutputStream fileOutputStream = new FileOutputStream(destination);){
            fileOutputStream.write(logBytes);
        }
        catch (IOException e2) {
            Log.err("Can't write logs to " + destinationDir + ", reason: \n" + e2);
        }
        return destination.toURI();
    }

    static NanoResponse downloadLogsViaRestAPI(LogArchiveContainer logContainer) {
        String outputFileStem = LogsHandler.getOutputLogStem();
        byte[] finalArchiveByteArray = LogsHandler.downloadLogs(logContainer, outputFileStem);
        NanoResponse res = new NanoResponse("200 OK", logContainer.getMimeType(), new ByteArrayInputStream(finalArchiveByteArray));
        res.addHeader("Content-Length", Long.toString(finalArchiveByteArray.length));
        res.addHeader("Content-Disposition", "attachment; filename=" + outputFileStem + "." + logContainer.getFileExtension());
        return res;
    }

    private static byte[] downloadLogs(LogArchiveContainer logContainer, String outputFileStem) {
        Log.info("\nCollecting logs.");
        byte[][] workersLogs = LogsHandler.getWorkersLogs(logContainer);
        byte[] clientLogs = LogsHandler.getClientLogs(logContainer);
        try {
            return LogsHandler.archiveLogs(logContainer, new Date(), workersLogs, clientLogs, outputFileStem);
        }
        catch (Exception e2) {
            return StringUtils.toBytes(e2);
        }
    }

    private static String getOutputLogStem() {
        String pattern = "yyyyMMdd_hhmmss";
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        String now = formatter.format(new Date());
        return "h2ologs_" + now;
    }

    private static byte[][] getWorkersLogs(LogArchiveContainer logContainer) {
        H2ONode[] members = H2O.CLOUD.members();
        byte[][] perNodeArchive = new byte[members.length][];
        for (int i2 = 0; i2 < members.length; ++i2) {
            try {
                if (members[i2].isHealthy()) {
                    GetLogsFromNode g2 = new GetLogsFromNode(i2, logContainer);
                    g2.doIt();
                    perNodeArchive[i2] = g2.bytes;
                    continue;
                }
                perNodeArchive[i2] = StringUtils.bytesOf("Node not healthy");
                continue;
            }
            catch (Exception e2) {
                perNodeArchive[i2] = StringUtils.toBytes(e2);
            }
        }
        return perNodeArchive;
    }

    private static byte[] getClientLogs(LogArchiveContainer logContainer) {
        if (H2O.ARGS.client) {
            try {
                GetLogsFromNode g2 = new GetLogsFromNode(-1, logContainer);
                g2.doIt();
                return g2.bytes;
            }
            catch (Exception e2) {
                return StringUtils.toBytes(e2);
            }
        }
        return null;
    }

    private static byte[] archiveLogs(LogArchiveContainer container, Date now, byte[][] results, byte[] clientResult, String topDir) throws IOException {
        int l2 = 0;
        assert (H2O.CLOUD._memary.length == results.length) : "Unexpected change in the cloud!";
        for (byte[] result : results) {
            l2 += result.length;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(l2);
        try (LogArchiveWriter archive = container.createLogArchiveWriter(baos);){
            LogArchiveWriter.ArchiveEntry entry = new LogArchiveWriter.ArchiveEntry(topDir + File.separator, now);
            archive.putNextEntry(entry);
            for (int i2 = 0; i2 < results.length; ++i2) {
                String filename = topDir + File.separator + "node" + i2 + "_" + H2O.CLOUD._memary[i2].getIpPortString().replace(':', '_').replace('/', '_') + "." + container.getFileExtension();
                LogArchiveWriter.ArchiveEntry ze = new LogArchiveWriter.ArchiveEntry(filename, now);
                archive.putNextEntry(ze);
                archive.write(results[i2]);
                archive.closeEntry();
            }
            if (clientResult != null) {
                String filename = topDir + File.separator + "driver." + container.getFileExtension();
                LogArchiveWriter.ArchiveEntry ze = new LogArchiveWriter.ArchiveEntry(filename, now);
                archive.putNextEntry(ze);
                archive.write(clientResult);
                archive.closeEntry();
            }
            archive.closeEntry();
        }
        return baos.toByteArray();
    }

    private static class GetLogTask
    extends DTask<GetLogTask> {
        public String name;
        public String log = null;
        public boolean success = false;

        public GetLogTask() {
            super((byte)119);
        }

        public void doIt() {
            String logPathFilename = "/undefined";
            try {
                if (this.name == null || this.name.equals("default")) {
                    this.name = "debug";
                }
                switch (this.name) {
                    case "stdout": 
                    case "stderr": {
                        LinuxProcFileReader lpfr = new LinuxProcFileReader();
                        lpfr.read();
                        if (!lpfr.valid()) {
                            this.log = "This option only works for Linux hosts";
                            break;
                        }
                        String pid = lpfr.getProcessID();
                        String fdFileName = "/proc/" + pid + "/fd/" + (this.name.equals("stdout") ? "1" : "2");
                        File f2 = new File(fdFileName);
                        logPathFilename = f2.getCanonicalPath();
                        if (logPathFilename.startsWith("/dev")) {
                            this.log = "Unsupported when writing to console";
                        }
                        if (logPathFilename.startsWith("socket")) {
                            this.log = "Unsupported when writing to a socket";
                        }
                        if (logPathFilename.startsWith("pipe")) {
                            this.log = "Unsupported when writing to a pipe";
                        }
                        if (logPathFilename.equals(fdFileName)) {
                            this.log = "Unsupported when writing to a pipe";
                        }
                        Log.trace("LogPathFilename calculation: " + logPathFilename);
                        break;
                    }
                    case "trace": 
                    case "debug": 
                    case "info": 
                    case "warn": 
                    case "error": 
                    case "fatal": {
                        if (!Log.isLoggingFor(this.name)) {
                            this.log = "Logging for " + this.name.toUpperCase() + " is not enabled as the log level is set to " + Log.LVLS[Log.getLogLevel()] + ".";
                            break;
                        }
                        try {
                            logPathFilename = Log.getLogFilePath(this.name);
                        }
                        catch (Exception e2) {
                            this.log = "H2O logging not configured.";
                        }
                        break;
                    }
                    case "httpd": {
                        try {
                            logPathFilename = Log.getLogFilePath(this.name);
                        }
                        catch (Exception e3) {
                            this.log = "H2O logging not configured.";
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Illegal log file name requested (try 'default')");
                    }
                }
                if (this.log == null) {
                    File f3 = new File(logPathFilename);
                    if (!f3.exists()) {
                        throw new IllegalArgumentException("File " + f3 + " does not exist");
                    }
                    if (!f3.canRead()) {
                        throw new IllegalArgumentException("File " + f3 + " is not readable");
                    }
                    BufferedReader reader = new BufferedReader(new FileReader(f3));
                    StringBuilder sb = new StringBuilder();
                    String line = reader.readLine();
                    while (line != null) {
                        sb.append(line);
                        sb.append("\n");
                        line = reader.readLine();
                    }
                    reader.close();
                    this.log = sb.toString();
                }
                this.success = true;
            }
            catch (Exception e4) {
                throw new RuntimeException(e4);
            }
        }

        @Override
        public void compute2() {
            this.doIt();
            this.tryComplete();
        }
    }
}

