/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import water.DKV;
import water.Futures;
import water.Iced;
import water.Key;
import water.KeySnapshot;
import water.Value;
import water.api.Handler;
import water.api.SchemaServer;
import water.api.schemas3.FrameLoadV3;
import water.api.schemas3.FrameSaveV3;
import water.api.schemas3.FrameV3;
import water.api.schemas3.FramesListV3;
import water.api.schemas3.FramesV3;
import water.api.schemas3.JobV3;
import water.api.schemas3.ModelSchemaV3;
import water.api.schemas3.SchemaV3;
import water.exceptions.H2OColumnNotFoundArgumentException;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OKeyNotFoundArgumentException;
import water.exceptions.H2OKeyWrongTypeArgumentException;
import water.exceptions.H2OKeysNotFoundArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.fvec.persist.FramePersist;
import water.util.Log;

public class FramesHandler<I extends Frames, S extends SchemaV3<I, S>>
extends Handler {
    public FramesListV3 list(int version, FramesListV3 s2) {
        Frames f2 = (Frames)s2.createAndFillImpl();
        f2.frames = Frame.fetchAll();
        s2.fillFromImplWithSynopsis(f2);
        return s2;
    }

    public FramesV3 columns(int version, FramesV3 s2) {
        return this.fetch(version, s2);
    }

    public static Frame getFromDKV(String param_name, String key_str) {
        return FramesHandler.getFromDKV(param_name, Key.make(key_str));
    }

    public static Frame getFromDKV(String param_name, Key key) {
        if (null == key) {
            throw new H2OIllegalArgumentException(param_name, "Frames.getFromDKV()", null);
        }
        Value v2 = DKV.get(key);
        if (null == v2) {
            throw new H2OKeyNotFoundArgumentException(param_name, key.toString());
        }
        Object ice = v2.get();
        if (ice instanceof Vec) {
            return new Frame((Vec)ice);
        }
        if (!(ice instanceof Frame)) {
            throw new H2OKeyWrongTypeArgumentException(param_name, key.toString(), Frame.class, ice.getClass());
        }
        return (Frame)ice;
    }

    public FramesV3 column(int version, FramesV3 s2) {
        Frame frame = FramesHandler.getFromDKV("key", s2.frame_id.key());
        Vec vec = frame.vec(s2.column);
        if (null == vec) {
            throw new H2OColumnNotFoundArgumentException("column", s2.frame_id.toString(), s2.column);
        }
        Vec[] vecs = new Vec[]{vec};
        String[] names = new String[]{s2.column};
        Frame new_frame = new Frame(names, vecs);
        s2.frames = new FrameV3[1];
        s2.frames[0] = new FrameV3(new_frame);
        s2.frames[0].clearBinsField();
        return s2;
    }

    public FramesV3 columnDomain(int version, FramesV3 s2) {
        Frame frame = FramesHandler.getFromDKV("key", s2.frame_id.key());
        Vec vec = frame.vec(s2.column);
        if (vec == null) {
            throw new H2OColumnNotFoundArgumentException("column", s2.frame_id.toString(), s2.column);
        }
        s2.domain = new String[1][];
        s2.domain[0] = vec.domain();
        return s2;
    }

    public FramesV3 columnSummary(int version, FramesV3 s2) {
        Frame frame = FramesHandler.getFromDKV("key", s2.frame_id.key());
        Vec vec = frame.vec(s2.column);
        if (null == vec) {
            throw new H2OColumnNotFoundArgumentException("column", s2.frame_id.toString(), s2.column);
        }
        vec.bins();
        s2.frames = new FrameV3[1];
        s2.frames[0] = new FrameV3(new Frame(new String[]{s2.column}, new Vec[]{vec}), s2.row_offset, s2.row_count, s2.column_offset, s2.column_count);
        return s2;
    }

    public FramesV3 fetch(int version, FramesV3 s2) {
        FramesV3 frames = this.doFetch(version, s2);
        for (FrameV3 a_frame : frames.frames) {
            a_frame.clearBinsField();
        }
        return frames;
    }

    public FramesV3 fetchLight(int version, FramesV3 s2) {
        FramesV3 frames = this.doFetch(version, s2, false);
        for (FrameV3 a_frame : frames.frames) {
            a_frame.clearBinsField();
        }
        return frames;
    }

    private FramesV3 doFetch(int version, FramesV3 s2) {
        return this.doFetch(version, s2, true);
    }

    private FramesV3 doFetch(int version, FramesV3 s2, boolean expensive) {
        s2.createAndFillImpl();
        Frame frame = FramesHandler.getFromDKV("key", s2.frame_id.key());
        s2.frames = new FrameV3[1];
        s2.frames[0] = new FrameV3(frame, s2.row_offset, s2.row_count, s2.column_offset, s2.column_count, s2.full_column_count, expensive);
        if (s2.find_compatible_models) {
            Model[] compatible = Frames.findCompatibleModels(frame, Model.fetchAll());
            s2.compatible_models = new ModelSchemaV3[compatible.length];
            s2.frames[0].compatible_models = new String[compatible.length];
            int i2 = 0;
            for (Model m4 : compatible) {
                s2.compatible_models[i2] = (ModelSchemaV3)SchemaServer.schema(version, m4).fillFromImpl(m4);
                s2.frames[0].compatible_models[i2] = m4._key.toString();
                ++i2;
            }
        }
        return s2;
    }

    public FramesV3 export(int version, FramesV3 s2) {
        Frame fr = FramesHandler.getFromDKV("key", s2.frame_id.key());
        Log.info("ExportFiles processing (" + s2.path + ")");
        Frame.CSVStreamParams csvParms = new Frame.CSVStreamParams().setSeparator(s2.separator).setHeaders(s2.header).setQuoteColumnNames(s2.quote_header);
        s2.job = new JobV3(Frame.export(fr, s2.path, s2.frame_id.key().toString(), s2.force, s2.num_parts, s2.parallel, s2.compression, csvParms));
        return s2;
    }

    public FrameSaveV3 save(int version, FrameSaveV3 req) {
        Frame fr = FramesHandler.getFromDKV("frame_id", req.frame_id.key());
        FramePersist persist = new FramePersist(fr);
        req.job = new JobV3(persist.saveTo(req.dir, req.force));
        return req;
    }

    public FrameLoadV3 load(int version, FrameLoadV3 req) {
        Value v2 = DKV.get(req.frame_id.key());
        if (v2 != null) {
            if (req.force) {
                ((Frame)v2.get()).remove();
            } else {
                throw new IllegalArgumentException("Frame " + req.frame_id + " already exists.");
            }
        }
        req.job = new JobV3(FramePersist.loadFrom(req.frame_id.key(), req.dir));
        return req;
    }

    public FramesV3 summary(int version, FramesV3 s2) {
        Frame frame = FramesHandler.getFromDKV("key", s2.frame_id.key());
        if (null != frame) {
            Futures fs = new Futures();
            int i2 = 0;
            for (Vec v2 : frame.vecs()) {
                if (null == DKV.get(v2._key)) {
                    Log.warn("For Frame: " + frame._key + ", Vec number: " + i2 + " (" + frame.name(i2) + ") is missing; not returning it.");
                } else {
                    v2.startRollupStats(fs, true);
                }
                ++i2;
            }
            fs.blockForPending();
        }
        return this.doFetch(version, s2);
    }

    public FramesV3 delete(int version, FramesV3 frames) {
        Frame frame = FramesHandler.getFromDKV("key", frames.frame_id.key());
        frame.delete();
        return frames;
    }

    public FramesV3 deleteAll(int version, FramesV3 frames) {
        Key[] keys = KeySnapshot.globalKeysOfClass(Frame.class);
        ArrayList<String> missing = new ArrayList<String>();
        Futures fs = new Futures();
        for (Key key : keys) {
            try {
                FramesHandler.getFromDKV("(none)", key).delete(null, fs, true);
            }
            catch (IllegalArgumentException iae) {
                missing.add(key.toString());
            }
        }
        fs.blockForPending();
        if (missing.size() != 0) {
            throw new H2OKeysNotFoundArgumentException("(none)", missing.toArray(new String[missing.size()]));
        }
        return frames;
    }

    public static final class Frames
    extends Iced {
        public Key<Frame> frame_id;
        public long row_offset;
        public int row_count;
        public Frame[] frames;
        public String column;
        public boolean find_compatible_models = false;

        protected static Map<Model, Set<String>> fetchModelCols(Model[] all_models) {
            HashMap<Model, Set<String>> all_models_cols = new HashMap<Model, Set<String>>();
            for (Model m4 : all_models) {
                all_models_cols.put(m4, new HashSet<String>(Arrays.asList(((Model.Output)m4._output)._names)));
            }
            return all_models_cols;
        }

        private static Model[] findCompatibleModels(Frame frame, Model[] all_models) {
            Map<Model, Set<String>> all_models_cols = Frames.fetchModelCols(all_models);
            ArrayList<Model> compatible_models = new ArrayList<Model>();
            HashSet<String> frame_column_names = new HashSet<String>(Arrays.asList(frame._names));
            for (Map.Entry<Model, Set<String>> entry : all_models_cols.entrySet()) {
                Model model = entry.getKey();
                Set<String> model_cols = entry.getValue();
                if (!frame_column_names.containsAll(model_cols)) continue;
                try {
                    if (model.adaptTestForTrain(new Frame(frame), false, false).length != 0) continue;
                    compatible_models.add(model);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return compatible_models.toArray(new Model[compatible_models.size()]);
        }
    }
}

