/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.util.Date;
import org.joda.time.DateTimeZone;
import water.H2O;
import water.H2ONode;
import water.H2OSecurityManager;
import water.Paxos;
import water.api.Handler;
import water.api.schemas3.CloudV3;
import water.parser.ParseTime;
import water.util.PrettyPrint;

class CloudHandler
extends Handler {
    CloudHandler() {
    }

    public CloudV3 head(int version, CloudV3 cloud) {
        return cloud;
    }

    public CloudV3 status(int version, CloudV3 cloud) {
        cloud.version = H2O.ABV.projectVersion();
        cloud.branch_name = H2O.ABV.branchName();
        cloud.last_commit_hash = H2O.ABV.lastCommitHash();
        cloud.describe = H2O.ABV.describe();
        cloud.compiled_by = H2O.ABV.compiledBy();
        cloud.compiled_on = H2O.ABV.compiledOn();
        cloud.build_number = H2O.ABV.buildNumber();
        cloud.build_age = PrettyPrint.toAge(H2O.ABV.compiledOnDate(), new Date());
        cloud.build_too_old = H2O.ABV.isTooOld();
        cloud.node_idx = H2O.SELF.index();
        cloud.cloud_name = H2O.ARGS.name;
        cloud.is_client = H2O.ARGS.client;
        cloud.cloud_size = H2O.CLOUD.size();
        cloud.cloud_uptime_millis = System.currentTimeMillis() - H2O.START_TIME_MILLIS.get();
        cloud.cloud_internal_timezone = DateTimeZone.getDefault().toString();
        cloud.datafile_parser_timezone = ParseTime.getTimezone().toString();
        cloud.consensus = Paxos._commonKnowledge;
        cloud.locked = Paxos._cloudLocked;
        cloud.internal_security_enabled = H2OSecurityManager.instance().securityEnabled;
        H2ONode leader = H2O.CLOUD.leaderOrNull();
        cloud.leader_idx = leader == null ? -1 : leader.index();
        H2ONode[] members = H2O.CLOUD.members();
        cloud.bad_nodes = 0;
        cloud.cloud_healthy = true;
        cloud.nodes = new CloudV3.NodeV3[members.length];
        for (int i2 = 0; i2 < members.length; ++i2) {
            cloud.nodes[i2] = new CloudV3.NodeV3(members[i2], cloud.skip_ticks);
            if (cloud.nodes[i2].healthy) continue;
            cloud.cloud_healthy = false;
            ++cloud.bad_nodes;
        }
        return cloud;
    }
}

