/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import water.AutoBuffer;
import water.H2O;
import water.TCPReceiverThread;
import water.ThreadHelper;
import water.util.Log;

class MultiReceiverThread
extends Thread {
    MultiReceiverThread() {
        super("Multi-UDP-R");
        ThreadHelper.initCommonThreadProperties(this);
    }

    @Override
    public void run() {
        if (H2O.isFlatfileEnabled()) {
            return;
        }
        Thread.currentThread().setPriority(10);
        MulticastSocket sock = null;
        DatagramSocket errsock = null;
        InetAddress group2 = null;
        InetAddress errgroup = null;
        boolean saw_error = false;
        while (true) {
            try {
                while (true) {
                    if (errsock != null && errgroup != null) {
                        InetAddress tmp = errgroup;
                        errgroup = null;
                        ((MulticastSocket)errsock).leaveGroup(tmp);
                    }
                    if (errsock != null) {
                        DatagramSocket tmp2 = errsock;
                        errsock = null;
                        tmp2.close();
                    }
                    if (saw_error) {
                        Thread.sleep(1000L);
                    }
                    saw_error = false;
                    if (group2 == null) {
                        group2 = H2O.CLOUD_MULTICAST_GROUP;
                    }
                    if (sock == null) {
                        sock = new MulticastSocket(H2O.CLOUD_MULTICAST_PORT);
                        if (H2O.CLOUD_MULTICAST_IF != null) {
                            try {
                                sock.setNetworkInterface(H2O.CLOUD_MULTICAST_IF);
                            }
                            catch (SocketException e2) {
                                Log.err("Exception calling setNetworkInterface, Multicast Interface, Group, Port - " + H2O.CLOUD_MULTICAST_IF + " " + H2O.CLOUD_MULTICAST_GROUP + ":" + H2O.CLOUD_MULTICAST_PORT, e2);
                                throw e2;
                            }
                        }
                        sock.joinGroup(group2);
                    }
                    byte[] buf = new byte[1492];
                    DatagramPacket pack = new DatagramPacket(buf, buf.length);
                    sock.receive(pack);
                    TCPReceiverThread.basic_packet_handling(new AutoBuffer(pack));
                }
            }
            catch (SocketException e3) {
                Log.err("Turning off multicast, which will disable further cloud building");
                throw new RuntimeException(e3);
            }
            catch (Exception e4) {
                Log.err("Exception on Multicast Interface, Group, Port - " + H2O.CLOUD_MULTICAST_IF + " " + H2O.CLOUD_MULTICAST_GROUP + ":" + H2O.CLOUD_MULTICAST_PORT, e4);
                saw_error = true;
                errsock = sock;
                sock = null;
                errgroup = group2;
                group2 = null;
                continue;
            }
            break;
        }
    }
}

