/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import water.H2O;
import water.network.SSLContextException;
import water.network.SSLSocketChannelFactory;
import water.network.WrappingSecurityManager;
import water.util.Log;

public class H2OSecurityManager
implements WrappingSecurityManager {
    private static volatile H2OSecurityManager INSTANCE = null;
    public final boolean securityEnabled;
    private SSLSocketChannelFactory sslSocketChannelFactory;

    private H2OSecurityManager() {
        this.securityEnabled = H2O.ARGS.internal_security_conf != null;
        try {
            if (null != H2O.ARGS.internal_security_conf) {
                this.sslSocketChannelFactory = new SSLSocketChannelFactory();
                Log.info("H2O node running in encrypted mode using config file [" + H2O.ARGS.internal_security_conf + "]");
            } else {
                Log.info("H2O node running in unencrypted mode.");
            }
        }
        catch (SSLContextException e2) {
            Log.err("Node initialized with SSL enabled but failed to create SSLContext. Node initialization aborted.", e2);
            H2O.exit(1);
        }
    }

    @Override
    public boolean isSecurityEnabled() {
        return this.securityEnabled;
    }

    @Override
    public ByteChannel wrapServerChannel(SocketChannel channel) throws IOException {
        return this.sslSocketChannelFactory.wrapServerChannel(channel);
    }

    @Override
    public ByteChannel wrapClientChannel(SocketChannel channel, String host, int port) throws IOException {
        return this.sslSocketChannelFactory.wrapClientChannel(channel, host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static H2OSecurityManager instance() {
        if (null != INSTANCE) return INSTANCE;
        Class<H2OSecurityManager> clazz = H2OSecurityManager.class;
        synchronized (H2OSecurityManager.class) {
            if (null != INSTANCE) return INSTANCE;
            INSTANCE = new H2OSecurityManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }
}

