/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.ArrayList;
import java.util.Arrays;
import water.Iced;
import water.util.HttpResponseStatus;
import water.util.IcedHashMapGeneric;
import water.util.Log;

public class H2OError
extends Iced {
    public long _timestamp;
    public String _error_url = null;
    public String _msg;
    public String _dev_msg;
    public int _http_status;
    public IcedHashMapGeneric.IcedHashMapStringObject _values;
    public String _exception_type;
    public String _exception_msg;
    public String[] _stacktrace;

    public H2OError(String error_url, String msg, String dev_msg, int http_status, IcedHashMapGeneric.IcedHashMapStringObject values, Exception e2) {
        this(System.currentTimeMillis(), error_url, msg, dev_msg, http_status, values, e2);
    }

    public H2OError(long timestamp, String error_url, String msg, String dev_msg, int http_status, IcedHashMapGeneric.IcedHashMapStringObject values, Throwable e2) {
        Log.err(e2);
        this._timestamp = timestamp;
        this._error_url = error_url;
        this._msg = msg;
        this._dev_msg = dev_msg;
        this._http_status = http_status;
        this._values = values;
        if (null == this._msg) {
            if (null != e2) {
                this._msg = "Caught exception: " + e2.getClass().getCanonicalName();
                this._dev_msg = this._msg + " from: " + e2.getStackTrace()[0];
            } else {
                this._dev_msg = this._msg = "Unknown error";
            }
        }
        if (null != e2) {
            String s2;
            StackTraceElement[] trace;
            this._exception_type = e2.getClass().getCanonicalName();
            this._exception_msg = e2.getMessage();
            ArrayList<String> arr = new ArrayList<String>();
            arr.add(e2.toString());
            for (StackTraceElement ste : trace = e2.getStackTrace()) {
                s2 = "    " + ste.toString();
                arr.add(s2);
                if (s2.startsWith("ai.h2o.org.eclipse.jetty")) break;
            }
            block1: while ((e2 = e2.getCause()) != null) {
                arr.add("Caused by:" + e2.toString());
                for (StackTraceElement ste : trace = e2.getStackTrace()) {
                    s2 = "    " + ste.toString();
                    arr.add(s2);
                    if (s2.startsWith("ai.h2o.org.eclipse.jetty")) continue block1;
                }
            }
            this._stacktrace = arr.toArray(new String[0]);
        }
        String prefix = "\n\nERROR MESSAGE:\n\n";
        String postfix = "\n\n";
        this._msg = prefix + this._msg + postfix;
        this._dev_msg = prefix + this._dev_msg + postfix;
        this._exception_msg = prefix + this._exception_msg + postfix;
    }

    public H2OError(Throwable e2, String error_url) {
        this(System.currentTimeMillis(), error_url, e2.getMessage(), e2.getMessage(), HttpResponseStatus.INTERNAL_SERVER_ERROR.getCode(), new IcedHashMapGeneric.IcedHashMapStringObject(), e2);
    }

    public static String httpStatusHeader(int status_code) {
        switch (status_code) {
            case 200: {
                return "200 OK";
            }
            case 201: {
                return "201 Created";
            }
            case 400: {
                return "400 Bad Request";
            }
            case 401: {
                return "401 Unauthorized";
            }
            case 403: {
                return "403 Forbidden";
            }
            case 404: {
                return "404 Not Found";
            }
            case 409: {
                return "409 Conflict";
            }
            case 410: {
                return "410 Gone";
            }
            case 412: {
                return "412 Precondition Failed";
            }
            case 500: {
                return "500 Internal Server Error";
            }
            case 501: {
                return "501 Not Implemented";
            }
            case 503: {
                return "503 Service Unavailable";
            }
        }
        return status_code + " Unimplemented http status code";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._dev_msg != null ? this._dev_msg : this._msg);
        sb.append("; ");
        sb.append("Stacktrace: ").append(Arrays.toString(this._stacktrace));
        if (!this._values.isEmpty()) {
            sb.append("; Values: ");
            sb.append(this._values.toJsonString());
        }
        return sb.toString();
    }
}

