/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.impl;

import java.util.Arrays;
import java.util.List;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.SymbolToken;
import software.amazon.ion.impl.SymbolTokenImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalSymbolTableImports {
    private final SymbolTable[] myImports;
    private final int myMaxId;
    private final int[] myBaseSids;

    LocalSymbolTableImports(List<SymbolTable> importTables) {
        int importTablesSize = importTables.size();
        this.myImports = importTables.toArray(new SymbolTable[importTablesSize]);
        this.myBaseSids = new int[importTablesSize];
        this.myMaxId = LocalSymbolTableImports.prepBaseSids(this.myBaseSids, this.myImports);
    }

    LocalSymbolTableImports(SymbolTable defaultSystemSymtab, SymbolTable ... imports) {
        assert (defaultSystemSymtab.isSystemTable()) : "defaultSystemSymtab isn't a system symtab";
        if (imports != null && imports.length > 0) {
            if (imports[0].isSystemTable()) {
                this.myImports = new SymbolTable[imports.length];
                System.arraycopy(imports, 0, this.myImports, 0, imports.length);
            } else {
                this.myImports = new SymbolTable[imports.length + 1];
                this.myImports[0] = defaultSystemSymtab;
                System.arraycopy(imports, 0, this.myImports, 1, imports.length);
            }
        } else {
            this.myImports = new SymbolTable[]{defaultSystemSymtab};
        }
        this.myBaseSids = new int[this.myImports.length];
        this.myMaxId = LocalSymbolTableImports.prepBaseSids(this.myBaseSids, this.myImports);
    }

    private static int prepBaseSids(int[] baseSids, SymbolTable[] imports) {
        SymbolTable firstImport = imports[0];
        assert (firstImport.isSystemTable()) : "first symtab must be a system symtab";
        baseSids[0] = 0;
        int total = firstImport.getMaxId();
        for (int i2 = 1; i2 < imports.length; ++i2) {
            SymbolTable importedTable = imports[i2];
            if (importedTable.isLocalTable() || importedTable.isSystemTable()) {
                String message = "only non-system shared tables can be imported";
                throw new IllegalArgumentException(message);
            }
            baseSids[i2] = total;
            total += imports[i2].getMaxId();
        }
        return total;
    }

    String findKnownSymbol(int sid) {
        String name = null;
        if (sid <= this.myMaxId) {
            int baseSid;
            int i2;
            int previousBaseSid = 0;
            for (i2 = 1; i2 < this.myImports.length && sid > (baseSid = this.myBaseSids[i2]); ++i2) {
                previousBaseSid = baseSid;
            }
            int importScopedSid = sid - previousBaseSid;
            name = this.myImports[i2 - 1].findKnownSymbol(importScopedSid);
        }
        return name;
    }

    int findSymbol(String name) {
        SymbolToken tok = this.find(name);
        return tok == null ? -1 : tok.getSid();
    }

    SymbolToken find(String text) {
        for (int i2 = 0; i2 < this.myImports.length; ++i2) {
            SymbolTable importedTable = this.myImports[i2];
            SymbolToken tok = importedTable.find(text);
            if (tok == null) continue;
            int sid = tok.getSid() + this.myBaseSids[i2];
            text = tok.getText();
            assert (text != null);
            return new SymbolTokenImpl(text, sid);
        }
        return null;
    }

    int getMaxId() {
        return this.myMaxId;
    }

    SymbolTable getSystemSymbolTable() {
        assert (this.myImports[0].isSystemTable());
        return this.myImports[0];
    }

    SymbolTable[] getImportedTables() {
        int count2 = this.myImports.length - 1;
        SymbolTable[] imports = new SymbolTable[count2];
        if (count2 > 0) {
            System.arraycopy(this.myImports, 1, imports, 0, count2);
        }
        return imports;
    }

    SymbolTable[] getImportedTablesNoCopy() {
        return this.myImports;
    }

    public String toString() {
        return Arrays.toString(this.myImports);
    }

    boolean equalImports(LocalSymbolTableImports other) {
        return Arrays.equals(this.myImports, other.myImports);
    }
}

