/*
 * Decompiled with CFR 0.152.
 */
package pl.edu.icm.jlargearrays;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.math3.util.FastMath;
import pl.edu.icm.jlargearrays.ComplexDoubleLargeArray;
import pl.edu.icm.jlargearrays.ComplexFloatLargeArray;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayType;
import pl.edu.icm.jlargearrays.LargeArrayUtils;

public class LargeArrayArithmetics {
    private LargeArrayArithmetics() {
    }

    public static float[] complexSin(float[] a2) {
        float[] res = new float[]{(float)(FastMath.sin((double)a2[0]) * FastMath.cosh((double)a2[1])), (float)(FastMath.cos((double)a2[0]) * FastMath.sinh((double)a2[1]))};
        return res;
    }

    public static double[] complexSin(double[] a2) {
        double[] res = new double[]{FastMath.sin((double)a2[0]) * FastMath.cosh((double)a2[1]), FastMath.cos((double)a2[0]) * FastMath.sinh((double)a2[1])};
        return res;
    }

    public static float[] complexCos(float[] a2) {
        float[] res = new float[]{(float)(FastMath.cos((double)a2[0]) * FastMath.cosh((double)a2[1])), (float)(-FastMath.sin((double)a2[0]) * FastMath.sinh((double)a2[1]))};
        return res;
    }

    public static double[] complexCos(double[] a2) {
        double[] res = new double[]{FastMath.cos((double)a2[0]) * FastMath.cosh((double)a2[1]), -FastMath.sin((double)a2[0]) * FastMath.sinh((double)a2[1])};
        return res;
    }

    public static float[] complexTan(float[] a2) {
        float[] s2 = LargeArrayArithmetics.complexSin(a2);
        float[] c2 = LargeArrayArithmetics.complexCos(a2);
        return LargeArrayArithmetics.complexDiv(s2, c2);
    }

    public static double[] complexTan(double[] a2) {
        double[] s2 = LargeArrayArithmetics.complexSin(a2);
        double[] c2 = LargeArrayArithmetics.complexCos(a2);
        return LargeArrayArithmetics.complexDiv(s2, c2);
    }

    public static float[] complexMult(float[] a2, float[] b2) {
        float[] res = new float[]{a2[0] * b2[0] - a2[1] * b2[1], a2[1] * b2[0] + a2[0] * b2[1]};
        return res;
    }

    public static double[] complexMult(double[] a2, double[] b2) {
        double[] res = new double[]{a2[0] * b2[0] - a2[1] * b2[1], a2[1] * b2[0] + a2[0] * b2[1]};
        return res;
    }

    public static float[] complexDiv(float[] a2, float[] b2) {
        float r2 = b2[0] * b2[0] + b2[1] * b2[1];
        float[] res = new float[]{(a2[0] * b2[0] + a2[1] * b2[1]) / r2, (a2[1] * b2[0] - a2[0] * b2[1]) / r2};
        return res;
    }

    public static double[] complexDiv(double[] a2, double[] b2) {
        double r2 = b2[0] * b2[0] + b2[1] * b2[1];
        double[] res = new double[]{(a2[0] * b2[0] + a2[1] * b2[1]) / r2, (a2[1] * b2[0] - a2[0] * b2[1]) / r2};
        return res;
    }

    public static float[] complexPow(float[] a2, double n2) {
        float[] res = new float[2];
        double mod2 = FastMath.pow((double)FastMath.sqrt((double)(a2[0] * a2[0] + a2[1] * a2[1])), (double)n2);
        double arg = FastMath.atan2((double)a2[1], (double)a2[0]);
        res[0] = (float)(mod2 * FastMath.cos((double)(n2 * arg)));
        res[1] = (float)(mod2 * FastMath.sin((double)(n2 * arg)));
        return res;
    }

    public static double[] complexPow(double[] a2, double n2) {
        double[] res = new double[2];
        double mod2 = FastMath.pow((double)FastMath.sqrt((double)(a2[0] * a2[0] + a2[1] * a2[1])), (double)n2);
        double arg = FastMath.atan2((double)a2[1], (double)a2[0]);
        res[0] = mod2 * FastMath.cos((double)(n2 * arg));
        res[1] = mod2 * FastMath.sin((double)(n2 * arg));
        return res;
    }

    public static float[] complexSqrt(float[] a2) {
        float[] res = new float[2];
        double mod2 = FastMath.sqrt((double)(a2[0] * a2[0] + a2[1] * a2[1]));
        res[0] = (float)FastMath.sqrt((double)(((double)a2[0] + mod2) / 2.0));
        res[1] = (float)((double)FastMath.signum((float)a2[1]) * FastMath.sqrt((double)(((double)(-a2[0]) + mod2) / 2.0)));
        return res;
    }

    public static double[] complexSqrt(double[] a2) {
        double[] res = new double[2];
        double mod2 = FastMath.sqrt((double)(a2[0] * a2[0] + a2[1] * a2[1]));
        res[0] = FastMath.sqrt((double)((a2[0] + mod2) / 2.0));
        res[1] = FastMath.signum((double)a2[1]) * FastMath.sqrt((double)((-a2[0] + mod2) / 2.0));
        return res;
    }

    public static float complexAbs(float[] a2) {
        return (float)FastMath.sqrt((double)(a2[0] * a2[0] + a2[1] * a2[1]));
    }

    public static double complexAbs(double[] a2) {
        return FastMath.sqrt((double)(a2[0] * a2[0] + a2[1] * a2[1]));
    }

    public static float[] complexLog(float[] a2) {
        float[] res = new float[2];
        double mod2 = FastMath.sqrt((double)(a2[0] * a2[0] + a2[1] * a2[1]));
        double arg = FastMath.atan2((double)a2[1], (double)a2[0]);
        res[0] = (float)FastMath.log((double)mod2);
        res[1] = (float)arg;
        return res;
    }

    public static double[] complexLog(double[] a2) {
        double[] res = new double[2];
        double mod2 = FastMath.sqrt((double)(a2[0] * a2[0] + a2[1] * a2[1]));
        double arg = FastMath.atan2((double)a2[1], (double)a2[0]);
        res[0] = FastMath.log((double)mod2);
        res[1] = arg;
        return res;
    }

    public static float[] complexLog10(float[] a2) {
        float[] res = new float[2];
        double scale = FastMath.log((double)10.0);
        double mod2 = FastMath.sqrt((double)(a2[0] * a2[0] + a2[1] * a2[1]));
        double arg = FastMath.atan2((double)a2[1], (double)a2[0]) / scale;
        res[0] = (float)(FastMath.log((double)mod2) / scale);
        res[1] = (float)arg;
        return res;
    }

    public static double[] complexLog10(double[] a2) {
        double[] res = new double[2];
        double scale = FastMath.log((double)10.0);
        double mod2 = FastMath.sqrt((double)(a2[0] * a2[0] + a2[1] * a2[1]));
        double arg = FastMath.atan2((double)a2[1], (double)a2[0]) / scale;
        res[0] = FastMath.log((double)mod2) / scale;
        res[1] = arg;
        return res;
    }

    public static float[] complexExp(float[] a2) {
        float[] res = new float[]{(float)(FastMath.exp((double)a2[0]) * FastMath.cos((double)a2[1])), (float)(FastMath.exp((double)a2[0]) * FastMath.sin((double)a2[1]))};
        return res;
    }

    public static double[] complexExp(double[] a2) {
        double[] res = new double[]{FastMath.exp((double)a2[0]) * FastMath.cos((double)a2[1]), FastMath.exp((double)a2[0]) * FastMath.sin((double)a2[1])};
        return res;
    }

    public static float[] complexAsin(float[] a2) {
        float[] i2 = new float[]{0.0f, 1.0f};
        float[] mi = new float[]{0.0f, -1.0f};
        float[] res = LargeArrayArithmetics.complexMult(a2, a2);
        res[0] = 1.0f - res[0];
        res[1] = 1.0f - res[1];
        res = LargeArrayArithmetics.complexLog(res);
        i2 = LargeArrayArithmetics.complexMult(i2, a2);
        res[0] = res[0] + i2[0];
        res[1] = res[1] + i2[1];
        return LargeArrayArithmetics.complexMult(mi, res);
    }

    public static double[] complexAsin(double[] a2) {
        double[] i2 = new double[]{0.0, 1.0};
        double[] mi = new double[]{0.0, -1.0};
        double[] res = LargeArrayArithmetics.complexMult(a2, a2);
        res[0] = 1.0 - res[0];
        res[1] = 1.0 - res[1];
        res = LargeArrayArithmetics.complexLog(res);
        i2 = LargeArrayArithmetics.complexMult(i2, a2);
        res[0] = res[0] + i2[0];
        res[1] = res[1] + i2[1];
        return LargeArrayArithmetics.complexMult(mi, res);
    }

    public static float[] complexAcos(float[] a2) {
        float[] i2 = new float[]{0.0f, 1.0f};
        float[] mi = new float[]{0.0f, -1.0f};
        float[] res = LargeArrayArithmetics.complexMult(a2, a2);
        res[0] = 1.0f - res[0];
        res[1] = 1.0f - res[1];
        res = LargeArrayArithmetics.complexMult(i2, res);
        res[0] = res[0] + a2[0];
        res[1] = res[1] + a2[1];
        res = LargeArrayArithmetics.complexLog(res);
        return LargeArrayArithmetics.complexMult(mi, res);
    }

    public static double[] complexAcos(double[] a2) {
        double[] i2 = new double[]{0.0, 1.0};
        double[] mi = new double[]{0.0, -1.0};
        double[] res = LargeArrayArithmetics.complexMult(a2, a2);
        res[0] = 1.0 - res[0];
        res[1] = 1.0 - res[1];
        res = LargeArrayArithmetics.complexMult(i2, res);
        res[0] = res[0] + a2[0];
        res[1] = res[1] + a2[1];
        res = LargeArrayArithmetics.complexLog(res);
        return LargeArrayArithmetics.complexMult(mi, res);
    }

    public static float[] complexAtan(float[] a2) {
        float[] res = new float[2];
        float[] tmp = new float[2];
        float[] i2 = new float[]{0.0f, 1.0f};
        res[0] = i2[0] + a2[0];
        res[1] = i2[1] + a2[1];
        tmp[0] = i2[0] - a2[0];
        tmp[1] = i2[1] - a2[1];
        res = LargeArrayArithmetics.complexLog(LargeArrayArithmetics.complexDiv(res, tmp));
        i2[1] = (float)((double)i2[1] / 2.0);
        return LargeArrayArithmetics.complexMult(i2, res);
    }

    public static double[] complexAtan(double[] a2) {
        double[] res = new double[2];
        double[] tmp = new double[2];
        double[] i2 = new double[]{0.0, 1.0};
        res[0] = i2[0] + a2[0];
        res[1] = i2[1] + a2[1];
        tmp[0] = i2[0] - a2[0];
        tmp[1] = i2[1] - a2[1];
        res = LargeArrayArithmetics.complexLog(LargeArrayArithmetics.complexDiv(res, tmp));
        i2[1] = i2[1] / 2.0;
        return LargeArrayArithmetics.complexMult(i2, res);
    }

    public static LargeArray add(LargeArray a2, LargeArray b2) {
        LargeArrayType out_type = a2.getType().compareTo(b2.getType()) >= 0 ? a2.getType() : b2.getType();
        return LargeArrayArithmetics.add(a2, b2, out_type);
    }

    public static LargeArray add(final LargeArray a2, final LargeArray b2, LargeArrayType out_type) {
        LargeArray res;
        if (a2 == null || b2 == null || a2.length() != b2.length() || !a2.isNumeric() || !b2.isNumeric()) {
            throw new IllegalArgumentException("a == null || b == null || a.length() != b.length() || !a.isNumeric() || !b.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant() && b2.isConstant()) {
            if (out_type.isIntegerNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a2.getLong(0L) + b2.getLong(0L));
            }
            if (out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a2.getDouble(0L) + b2.getDouble(0L));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                float[] elem_b = ((ComplexFloatLargeArray)b2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, new float[]{elem_a[0] + elem_b[0], elem_a[1] + elem_b[1]});
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                double[] elem_b = ((ComplexDoubleLargeArray)b2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, new double[]{elem_a[0] + elem_b[0], elem_a[1] + elem_b[1]});
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setLong(i2, a2.getLong(i2) + b2.getLong(i2));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setLong(k2, a2.getLong(k2) + b2.getLong(k2));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setLong(i3, a2.getLong(i3) + b2.getLong(i3));
                    }
                }
            }
        } else if (out_type.isRealNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i4 = 0L; i4 < length; ++i4) {
                    res.setDouble(i4, a2.getDouble(i4) + b2.getDouble(i4));
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, a2.getDouble(k2) + b2.getDouble(k2));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i5 = 0L; i5 < length; ++i5) {
                        res.setDouble(i5, a2.getDouble(i5) + b2.getDouble(i5));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)LargeArrayUtils.convert(a2, out_type);
            final ComplexFloatLargeArray _bc = (ComplexFloatLargeArray)LargeArrayUtils.convert(b2, out_type);
            res = _ac.getType() == a2.getType() && _bc.getType() == b2.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a2.getType() ? _ac : _bc);
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i6 = 0L; i6 < length; ++i6) {
                    float[] elem_a = _ac.getComplexFloat(i6);
                    float[] elem_b = _bc.getComplexFloat(i6);
                    elem_res[0] = elem_a[0] + elem_b[0];
                    elem_res[1] = elem_a[1] + elem_b[1];
                    resc.setComplexFloat(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                float[] elem_b = _bc.getComplexFloat(k2);
                                elem_res[0] = elem_a[0] + elem_b[0];
                                elem_res[1] = elem_a[1] + elem_b[1];
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i7 = 0L; i7 < length; ++i7) {
                        float[] elem_a = _ac.getComplexFloat(i7);
                        float[] elem_b = _bc.getComplexFloat(i7);
                        elem_res[0] = elem_a[0] + elem_b[0];
                        elem_res[1] = elem_a[1] + elem_b[1];
                        resc.setComplexFloat(i7, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)LargeArrayUtils.convert(a2, out_type);
            final ComplexDoubleLargeArray _bc = (ComplexDoubleLargeArray)LargeArrayUtils.convert(b2, out_type);
            res = _ac.getType() == a2.getType() && _bc.getType() == b2.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a2.getType() ? _ac : _bc);
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i8 = 0L; i8 < length; ++i8) {
                    double[] elem_a = _ac.getComplexDouble(i8);
                    double[] elem_b = _bc.getComplexDouble(i8);
                    elem_res[0] = elem_a[0] + elem_b[0];
                    elem_res[1] = elem_a[1] + elem_b[1];
                    resc.setComplexDouble(i8, elem_res);
                }
            } else {
                long k5 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j5 = 0; j5 < nthreads; ++j5) {
                    final long firstIdx = (long)j5 * k5;
                    final long lastIdx = j5 == nthreads - 1 ? length : firstIdx + k5;
                    threads[j5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                double[] elem_b = _bc.getComplexDouble(k2);
                                elem_res[0] = elem_a[0] + elem_b[0];
                                elem_res[1] = elem_a[1] + elem_b[1];
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i9 = 0L; i9 < length; ++i9) {
                        double[] elem_a = _ac.getComplexDouble(i9);
                        double[] elem_b = _bc.getComplexDouble(i9);
                        elem_res[0] = elem_a[0] + elem_b[0];
                        elem_res[1] = elem_a[1] + elem_b[1];
                        resc.setComplexDouble(i9, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray diff(LargeArray a2, LargeArray b2) {
        LargeArrayType out_type = a2.getType().compareTo(b2.getType()) >= 0 ? a2.getType() : b2.getType();
        return LargeArrayArithmetics.diff(a2, b2, out_type);
    }

    public static LargeArray diff(final LargeArray a2, final LargeArray b2, LargeArrayType out_type) {
        LargeArray res;
        if (a2 == null || b2 == null || a2.length() != b2.length() || !a2.isNumeric() || !b2.isNumeric()) {
            throw new IllegalArgumentException("a == null || b == null || a.length() != b.length() || !a.isNumeric() || !b.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant() && b2.isConstant()) {
            if (out_type.isIntegerNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a2.getLong(0L) - b2.getLong(0L));
            }
            if (out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a2.getDouble(0L) - b2.getDouble(0L));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                float[] elem_b = ((ComplexFloatLargeArray)b2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, new float[]{elem_a[0] - elem_b[0], elem_a[1] - elem_b[1]});
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                double[] elem_b = ((ComplexDoubleLargeArray)b2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, new double[]{elem_a[0] - elem_b[0], elem_a[1] - elem_b[1]});
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setLong(i2, a2.getLong(i2) - b2.getLong(i2));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setLong(k2, a2.getLong(k2) - b2.getLong(k2));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setLong(i3, a2.getLong(i3) - b2.getLong(i3));
                    }
                }
            }
        } else if (out_type.isRealNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i4 = 0L; i4 < length; ++i4) {
                    res.setDouble(i4, a2.getDouble(i4) - b2.getDouble(i4));
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, a2.getDouble(k2) - b2.getDouble(k2));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i5 = 0L; i5 < length; ++i5) {
                        res.setDouble(i5, a2.getDouble(i5) - b2.getDouble(i5));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)LargeArrayUtils.convert(a2, out_type);
            final ComplexFloatLargeArray _bc = (ComplexFloatLargeArray)LargeArrayUtils.convert(b2, out_type);
            res = _ac.getType() == a2.getType() && _bc.getType() == b2.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a2.getType() ? _ac : _bc);
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i6 = 0L; i6 < length; ++i6) {
                    float[] elem_a = _ac.getComplexFloat(i6);
                    float[] elem_b = _bc.getComplexFloat(i6);
                    elem_res[0] = elem_a[0] - elem_b[0];
                    elem_res[1] = elem_a[1] - elem_b[1];
                    resc.setComplexFloat(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                float[] elem_b = _bc.getComplexFloat(k2);
                                elem_res[0] = elem_a[0] - elem_b[0];
                                elem_res[1] = elem_a[1] - elem_b[1];
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i7 = 0L; i7 < length; ++i7) {
                        float[] elem_a = _ac.getComplexFloat(i7);
                        float[] elem_b = _bc.getComplexFloat(i7);
                        elem_res[0] = elem_a[0] - elem_b[0];
                        elem_res[1] = elem_a[1] - elem_b[1];
                        resc.setComplexFloat(i7, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)LargeArrayUtils.convert(a2, out_type);
            final ComplexDoubleLargeArray _bc = (ComplexDoubleLargeArray)LargeArrayUtils.convert(b2, out_type);
            res = _ac.getType() == a2.getType() && _bc.getType() == b2.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a2.getType() ? _ac : _bc);
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i8 = 0L; i8 < length; ++i8) {
                    double[] elem_a = _ac.getComplexDouble(i8);
                    double[] elem_b = _bc.getComplexDouble(i8);
                    elem_res[0] = elem_a[0] - elem_b[0];
                    elem_res[1] = elem_a[1] - elem_b[1];
                    resc.setComplexDouble(i8, elem_res);
                }
            } else {
                long k5 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j5 = 0; j5 < nthreads; ++j5) {
                    final long firstIdx = (long)j5 * k5;
                    final long lastIdx = j5 == nthreads - 1 ? length : firstIdx + k5;
                    threads[j5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                double[] elem_b = _bc.getComplexDouble(k2);
                                elem_res[0] = elem_a[0] - elem_b[0];
                                elem_res[1] = elem_a[1] - elem_b[1];
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i9 = 0L; i9 < length; ++i9) {
                        double[] elem_a = _ac.getComplexDouble(i9);
                        double[] elem_b = _bc.getComplexDouble(i9);
                        elem_res[0] = elem_a[0] - elem_b[0];
                        elem_res[1] = elem_a[1] - elem_b[1];
                        resc.setComplexDouble(i9, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray mult(LargeArray a2, LargeArray b2) {
        LargeArrayType out_type = a2.getType().compareTo(b2.getType()) >= 0 ? a2.getType() : b2.getType();
        return LargeArrayArithmetics.mult(a2, b2, out_type);
    }

    public static LargeArray mult(final LargeArray a2, final LargeArray b2, LargeArrayType out_type) {
        LargeArray res;
        if (a2 == null || b2 == null || a2.length() != b2.length() || !a2.isNumeric() || !b2.isNumeric()) {
            throw new IllegalArgumentException("a == null || b == null || a.length() != b.length() || !a.isNumeric() || !b.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant() && b2.isConstant()) {
            if (out_type.isIntegerNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a2.getLong(0L) * b2.getLong(0L));
            }
            if (out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a2.getDouble(0L) * b2.getDouble(0L));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                float[] elem_b = ((ComplexFloatLargeArray)b2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexMult(elem_a, elem_b));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                double[] elem_b = ((ComplexDoubleLargeArray)b2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexMult(elem_a, elem_b));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setLong(i2, a2.getLong(i2) * b2.getLong(i2));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setLong(k2, a2.getLong(k2) * b2.getLong(k2));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setLong(i3, a2.getLong(i3) * b2.getLong(i3));
                    }
                }
            }
        } else if (out_type.isRealNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i4 = 0L; i4 < length; ++i4) {
                    res.setDouble(i4, a2.getDouble(i4) * b2.getDouble(i4));
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, a2.getDouble(k2) * b2.getDouble(k2));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i5 = 0L; i5 < length; ++i5) {
                        res.setDouble(i5, a2.getDouble(i5) * b2.getDouble(i5));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)LargeArrayUtils.convert(a2, out_type);
            final ComplexFloatLargeArray _bc = (ComplexFloatLargeArray)LargeArrayUtils.convert(b2, out_type);
            res = _ac.getType() == a2.getType() && _bc.getType() == b2.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a2.getType() ? _ac : _bc);
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i6 = 0L; i6 < length; ++i6) {
                    float[] elem_a = _ac.getComplexFloat(i6);
                    float[] elem_b = _bc.getComplexFloat(i6);
                    elem_res[0] = elem_a[0] * elem_b[0] - elem_a[1] * elem_b[1];
                    elem_res[1] = elem_a[1] * elem_b[0] + elem_a[0] * elem_b[1];
                    resc.setComplexFloat(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                float[] elem_b = _bc.getComplexFloat(k2);
                                elem_res[0] = elem_a[0] * elem_b[0] - elem_a[1] * elem_b[1];
                                elem_res[1] = elem_a[1] * elem_b[0] + elem_a[0] * elem_b[1];
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i7 = 0L; i7 < length; ++i7) {
                        float[] elem_a = _ac.getComplexFloat(i7);
                        float[] elem_b = _bc.getComplexFloat(i7);
                        elem_res[0] = elem_a[0] * elem_b[0] - elem_a[1] * elem_b[1];
                        elem_res[1] = elem_a[1] * elem_b[0] + elem_a[0] * elem_b[1];
                        resc.setComplexFloat(i7, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)LargeArrayUtils.convert(a2, out_type);
            final ComplexDoubleLargeArray _bc = (ComplexDoubleLargeArray)LargeArrayUtils.convert(b2, out_type);
            res = _ac.getType() == a2.getType() && _bc.getType() == b2.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a2.getType() ? _ac : _bc);
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i8 = 0L; i8 < length; ++i8) {
                    double[] elem_a = _ac.getComplexDouble(i8);
                    double[] elem_b = _bc.getComplexDouble(i8);
                    elem_res[0] = elem_a[0] * elem_b[0] - elem_a[1] * elem_b[1];
                    elem_res[1] = elem_a[1] * elem_b[0] + elem_a[0] * elem_b[1];
                    resc.setComplexDouble(i8, elem_res);
                }
            } else {
                long k5 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j5 = 0; j5 < nthreads; ++j5) {
                    final long firstIdx = (long)j5 * k5;
                    final long lastIdx = j5 == nthreads - 1 ? length : firstIdx + k5;
                    threads[j5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                double[] elem_b = _bc.getComplexDouble(k2);
                                elem_res[0] = elem_a[0] * elem_b[0] - elem_a[1] * elem_b[1];
                                elem_res[1] = elem_a[1] * elem_b[0] + elem_a[0] * elem_b[1];
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i9 = 0L; i9 < length; ++i9) {
                        double[] elem_a = _ac.getComplexDouble(i9);
                        double[] elem_b = _bc.getComplexDouble(i9);
                        elem_res[0] = elem_a[0] * elem_b[0] - elem_a[1] * elem_b[1];
                        elem_res[1] = elem_a[1] * elem_b[0] + elem_a[0] * elem_b[1];
                        resc.setComplexDouble(i9, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray div(LargeArray a2, LargeArray b2) {
        LargeArrayType out_type = a2.getType().compareTo(b2.getType()) >= 0 ? a2.getType() : b2.getType();
        return LargeArrayArithmetics.div(a2, b2, out_type);
    }

    public static LargeArray div(final LargeArray a2, final LargeArray b2, LargeArrayType out_type) {
        LargeArray res;
        if (a2 == null || b2 == null || a2.length() != b2.length() || !a2.isNumeric() || !b2.isNumeric()) {
            throw new IllegalArgumentException("a == null || b == null || a.length() != b.length() || !a.isNumeric() || !b.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant() && b2.isConstant()) {
            if (out_type.isIntegerNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a2.getLong(0L) / b2.getLong(0L));
            }
            if (out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, a2.getDouble(0L) / b2.getDouble(0L));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                float[] elem_b = ((ComplexFloatLargeArray)b2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexDiv(elem_a, elem_b));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                double[] elem_b = ((ComplexDoubleLargeArray)b2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexDiv(elem_a, elem_b));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setLong(i2, a2.getLong(i2) / b2.getLong(i2));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setLong(k2, a2.getLong(k2) / b2.getLong(k2));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setLong(i3, a2.getLong(i3) / b2.getLong(i3));
                    }
                }
            }
        } else if (out_type.isRealNumericType()) {
            res = LargeArrayUtils.create(out_type, length, false);
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i4 = 0L; i4 < length; ++i4) {
                    res.setDouble(i4, a2.getDouble(i4) / b2.getDouble(i4));
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, a2.getDouble(k2) / b2.getDouble(k2));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i5 = 0L; i5 < length; ++i5) {
                        res.setDouble(i5, a2.getDouble(i5) / b2.getDouble(i5));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)LargeArrayUtils.convert(a2, out_type);
            final ComplexFloatLargeArray _bc = (ComplexFloatLargeArray)LargeArrayUtils.convert(b2, out_type);
            res = _ac.getType() == a2.getType() && _bc.getType() == b2.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a2.getType() ? _ac : _bc);
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i6 = 0L; i6 < length; ++i6) {
                    float[] elem_a = _ac.getComplexFloat(i6);
                    float[] elem_b = _bc.getComplexFloat(i6);
                    float r2 = elem_b[0] * elem_b[0] + elem_b[1] * elem_b[1];
                    elem_res[0] = (elem_a[0] * elem_b[0] + elem_a[1] * elem_b[1]) / r2;
                    elem_res[1] = (elem_a[1] * elem_b[0] - elem_a[0] * elem_b[1]) / r2;
                    resc.setComplexFloat(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                float[] elem_b = _bc.getComplexFloat(k2);
                                float r2 = elem_b[0] * elem_b[0] + elem_b[1] * elem_b[1];
                                elem_res[0] = (elem_a[0] * elem_b[0] + elem_a[1] * elem_b[1]) / r2;
                                elem_res[1] = (elem_a[1] * elem_b[0] - elem_a[0] * elem_b[1]) / r2;
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i7 = 0L; i7 < length; ++i7) {
                        float[] elem_a = _ac.getComplexFloat(i7);
                        float[] elem_b = _bc.getComplexFloat(i7);
                        float r3 = elem_b[0] * elem_b[0] + elem_b[1] * elem_b[1];
                        elem_res[0] = (elem_a[0] * elem_b[0] + elem_a[1] * elem_b[1]) / r3;
                        elem_res[1] = (elem_a[1] * elem_b[0] - elem_a[0] * elem_b[1]) / r3;
                        resc.setComplexFloat(i7, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)LargeArrayUtils.convert(a2, out_type);
            final ComplexDoubleLargeArray _bc = (ComplexDoubleLargeArray)LargeArrayUtils.convert(b2, out_type);
            res = _ac.getType() == a2.getType() && _bc.getType() == b2.getType() ? LargeArrayUtils.create(out_type, length, false) : (_ac.getType() != a2.getType() ? _ac : _bc);
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i8 = 0L; i8 < length; ++i8) {
                    double[] elem_a = _ac.getComplexDouble(i8);
                    double[] elem_b = _bc.getComplexDouble(i8);
                    double r4 = elem_b[0] * elem_b[0] + elem_b[1] * elem_b[1];
                    elem_res[0] = (elem_a[0] * elem_b[0] + elem_a[1] * elem_b[1]) / r4;
                    elem_res[1] = (elem_a[1] * elem_b[0] - elem_a[0] * elem_b[1]) / r4;
                    resc.setComplexDouble(i8, elem_res);
                }
            } else {
                long k5 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j5 = 0; j5 < nthreads; ++j5) {
                    final long firstIdx = (long)j5 * k5;
                    final long lastIdx = j5 == nthreads - 1 ? length : firstIdx + k5;
                    threads[j5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                double[] elem_b = _bc.getComplexDouble(k2);
                                double r2 = elem_b[0] * elem_b[0] + elem_b[1] * elem_b[1];
                                elem_res[0] = (elem_a[0] * elem_b[0] + elem_a[1] * elem_b[1]) / r2;
                                elem_res[1] = (elem_a[1] * elem_b[0] - elem_a[0] * elem_b[1]) / r2;
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i9 = 0L; i9 < length; ++i9) {
                        double[] elem_a = _ac.getComplexDouble(i9);
                        double[] elem_b = _bc.getComplexDouble(i9);
                        double r5 = elem_b[0] * elem_b[0] + elem_b[1] * elem_b[1];
                        elem_res[0] = (elem_a[0] * elem_b[0] + elem_a[1] * elem_b[1]) / r5;
                        elem_res[1] = (elem_a[1] * elem_b[0] - elem_a[0] * elem_b[1]) / r5;
                        resc.setComplexDouble(i9, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray pow(LargeArray a2, double n2) {
        LargeArrayType out_type = a2.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a2.getType();
        return LargeArrayArithmetics.pow(a2, n2, out_type);
    }

    public static LargeArray pow(final LargeArray a2, final double n2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.pow((double)a2.getDouble(0L), (double)n2));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexPow(elem_a, n2));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexPow(elem_a, n2));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setDouble(i2, FastMath.pow((double)a2.getDouble(i2), (double)n2));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, FastMath.pow((double)a2.getDouble(k2), (double)n2));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setDouble(i3, FastMath.pow((double)a2.getDouble(i3), (double)n2));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i4 = 0L; i4 < length; ++i4) {
                    float[] elem_a = _ac.getComplexFloat(i4);
                    double mod2 = FastMath.pow((double)FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1])), (double)n2);
                    double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]);
                    elem_res[0] = (float)(mod2 * FastMath.cos((double)(n2 * arg)));
                    elem_res[1] = (float)(mod2 * FastMath.sin((double)(n2 * arg)));
                    resc.setComplexFloat(i4, elem_res);
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                double mod2 = FastMath.pow((double)FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1])), (double)n2);
                                double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]);
                                elem_res[0] = (float)(mod2 * FastMath.cos((double)(n2 * arg)));
                                elem_res[1] = (float)(mod2 * FastMath.sin((double)(n2 * arg)));
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i5 = 0L; i5 < length; ++i5) {
                        float[] elem_a = _ac.getComplexFloat(i5);
                        double mod3 = FastMath.pow((double)FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1])), (double)n2);
                        double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]);
                        elem_res[0] = (float)(mod3 * FastMath.cos((double)(n2 * arg)));
                        elem_res[1] = (float)(mod3 * FastMath.sin((double)(n2 * arg)));
                        resc.setComplexFloat(i5, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i6 = 0L; i6 < length; ++i6) {
                    double[] elem_a = _ac.getComplexDouble(i6);
                    double mod4 = FastMath.pow((double)FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1])), (double)n2);
                    double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]);
                    elem_res[0] = mod4 * FastMath.cos((double)(n2 * arg));
                    elem_res[1] = mod4 * FastMath.sin((double)(n2 * arg));
                    resc.setComplexDouble(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                double mod2 = FastMath.pow((double)FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1])), (double)n2);
                                double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]);
                                elem_res[0] = mod2 * FastMath.cos((double)(n2 * arg));
                                elem_res[1] = mod2 * FastMath.sin((double)(n2 * arg));
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i7 = 0L; i7 < length; ++i7) {
                        double[] elem_a = _ac.getComplexDouble(i7);
                        double mod5 = FastMath.pow((double)FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1])), (double)n2);
                        double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]);
                        elem_res[0] = mod5 * FastMath.cos((double)(n2 * arg));
                        elem_res[1] = mod5 * FastMath.sin((double)(n2 * arg));
                        resc.setComplexDouble(i7, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray neg(LargeArray a2) {
        LargeArrayType out_type = a2.getType();
        return LargeArrayArithmetics.neg(a2, out_type);
    }

    public static LargeArray neg(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, -a2.getLong(0L));
            }
            if (out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, -a2.getDouble(0L));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, new float[]{-elem_a[0], -elem_a[1]});
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, new double[]{-elem_a[0], -elem_a[1]});
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setLong(i2, -a2.getLong(i2));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setLong(k2, -a2.getLong(k2));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setLong(i3, -a2.getLong(i3));
                    }
                }
            }
        } else if (out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i4 = 0L; i4 < length; ++i4) {
                    res.setDouble(i4, -a2.getDouble(i4));
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, -a2.getDouble(k2));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i5 = 0L; i5 < length; ++i5) {
                        res.setDouble(i5, -a2.getDouble(i5));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i6 = 0L; i6 < length; ++i6) {
                    float[] elem_a = _ac.getComplexFloat(i6);
                    elem_res[0] = -elem_a[0];
                    elem_res[1] = -elem_a[1];
                    resc.setComplexFloat(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                elem_res[0] = -elem_a[0];
                                elem_res[1] = -elem_a[1];
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i7 = 0L; i7 < length; ++i7) {
                        float[] elem_a = _ac.getComplexFloat(i7);
                        elem_res[0] = -elem_a[0];
                        elem_res[1] = -elem_a[1];
                        resc.setComplexFloat(i7, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i8 = 0L; i8 < length; ++i8) {
                    double[] elem_a = _ac.getComplexDouble(i8);
                    elem_res[0] = -elem_a[0];
                    elem_res[1] = -elem_a[1];
                    resc.setComplexDouble(i8, elem_res);
                }
            } else {
                long k5 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j5 = 0; j5 < nthreads; ++j5) {
                    final long firstIdx = (long)j5 * k5;
                    final long lastIdx = j5 == nthreads - 1 ? length : firstIdx + k5;
                    threads[j5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                elem_res[0] = -elem_a[0];
                                elem_res[1] = -elem_a[1];
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i9 = 0L; i9 < length; ++i9) {
                        double[] elem_a = _ac.getComplexDouble(i9);
                        elem_res[0] = -elem_a[0];
                        elem_res[1] = -elem_a[1];
                        resc.setComplexDouble(i9, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray sqrt(LargeArray a2) {
        LargeArrayType out_type = a2.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a2.getType();
        return LargeArrayArithmetics.sqrt(a2, out_type);
    }

    public static LargeArray sqrt(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.sqrt((double)a2.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexSqrt(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexSqrt(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setDouble(i2, FastMath.sqrt((double)a2.getDouble(i2)));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, FastMath.sqrt((double)a2.getDouble(k2)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setDouble(i3, FastMath.sqrt((double)a2.getDouble(i3)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i4 = 0L; i4 < length; ++i4) {
                    float[] elem_a = _ac.getComplexFloat(i4);
                    double mod2 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                    elem_res[0] = (float)FastMath.sqrt((double)(((double)elem_a[0] + mod2) / 2.0));
                    elem_res[1] = (float)((double)FastMath.signum((float)elem_a[1]) * FastMath.sqrt((double)(((double)(-elem_a[0]) + mod2) / 2.0)));
                    resc.setComplexFloat(i4, elem_res);
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                double mod2 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                                elem_res[0] = (float)FastMath.sqrt((double)(((double)elem_a[0] + mod2) / 2.0));
                                elem_res[1] = (float)((double)FastMath.signum((float)elem_a[1]) * FastMath.sqrt((double)(((double)(-elem_a[0]) + mod2) / 2.0)));
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i5 = 0L; i5 < length; ++i5) {
                        float[] elem_a = _ac.getComplexFloat(i5);
                        double mod3 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                        elem_res[0] = (float)FastMath.sqrt((double)(((double)elem_a[0] + mod3) / 2.0));
                        elem_res[1] = (float)((double)FastMath.signum((float)elem_a[1]) * FastMath.sqrt((double)(((double)(-elem_a[0]) + mod3) / 2.0)));
                        resc.setComplexFloat(i5, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i6 = 0L; i6 < length; ++i6) {
                    double[] elem_a = _ac.getComplexDouble(i6);
                    double mod4 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                    elem_res[0] = FastMath.sqrt((double)((elem_a[0] + mod4) / 2.0));
                    elem_res[1] = FastMath.signum((double)elem_a[1]) * FastMath.sqrt((double)((-elem_a[0] + mod4) / 2.0));
                    resc.setComplexDouble(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                double mod2 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                                elem_res[0] = FastMath.sqrt((double)((elem_a[0] + mod2) / 2.0));
                                elem_res[1] = FastMath.signum((double)elem_a[1]) * FastMath.sqrt((double)((-elem_a[0] + mod2) / 2.0));
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i7 = 0L; i7 < length; ++i7) {
                        double[] elem_a = _ac.getComplexDouble(i7);
                        double mod5 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                        elem_res[0] = FastMath.sqrt((double)((elem_a[0] + mod5) / 2.0));
                        elem_res[1] = FastMath.signum((double)elem_a[1]) * FastMath.sqrt((double)((-elem_a[0] + mod5) / 2.0));
                        resc.setComplexDouble(i7, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray log(LargeArray a2) {
        LargeArrayType out_type = a2.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a2.getType();
        return LargeArrayArithmetics.log(a2, out_type);
    }

    public static LargeArray log(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.log((double)a2.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexLog(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexLog(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setDouble(i2, FastMath.log((double)a2.getDouble(i2)));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, FastMath.log((double)a2.getDouble(k2)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setDouble(i3, FastMath.log((double)a2.getDouble(i3)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i4 = 0L; i4 < length; ++i4) {
                    float[] elem_a = _ac.getComplexFloat(i4);
                    double mod2 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                    double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]);
                    elem_res[0] = (float)FastMath.log((double)mod2);
                    elem_res[1] = (float)arg;
                    resc.setComplexFloat(i4, elem_res);
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                double mod2 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                                double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]);
                                elem_res[0] = (float)FastMath.log((double)mod2);
                                elem_res[1] = (float)arg;
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i5 = 0L; i5 < length; ++i5) {
                        float[] elem_a = _ac.getComplexFloat(i5);
                        double mod3 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                        double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]);
                        elem_res[0] = (float)FastMath.log((double)mod3);
                        elem_res[1] = (float)arg;
                        resc.setComplexFloat(i5, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i6 = 0L; i6 < length; ++i6) {
                    double[] elem_a = _ac.getComplexDouble(i6);
                    double mod4 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                    double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]);
                    elem_res[0] = FastMath.log((double)mod4);
                    elem_res[1] = arg;
                    resc.setComplexDouble(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                double mod2 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                                double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]);
                                elem_res[0] = FastMath.log((double)mod2);
                                elem_res[1] = arg;
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i7 = 0L; i7 < length; ++i7) {
                        double[] elem_a = _ac.getComplexDouble(i7);
                        double mod5 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                        double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]);
                        elem_res[0] = FastMath.log((double)mod5);
                        elem_res[1] = arg;
                        resc.setComplexDouble(i7, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray log10(LargeArray a2) {
        LargeArrayType out_type = a2.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a2.getType();
        return LargeArrayArithmetics.log10(a2, out_type);
    }

    public static LargeArray log10(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.log10((double)a2.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexLog10(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexLog10(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setDouble(i2, FastMath.log10((double)a2.getDouble(i2)));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, FastMath.log10((double)a2.getDouble(k2)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setDouble(i3, FastMath.log10((double)a2.getDouble(i3)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final double scale = FastMath.log((double)10.0);
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i4 = 0L; i4 < length; ++i4) {
                    float[] elem_a = _ac.getComplexFloat(i4);
                    double mod2 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                    double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]) / scale;
                    elem_res[0] = (float)(FastMath.log((double)mod2) / scale);
                    elem_res[1] = (float)arg;
                    resc.setComplexFloat(i4, elem_res);
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                double mod2 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                                double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]) / scale;
                                elem_res[0] = (float)(FastMath.log((double)mod2) / scale);
                                elem_res[1] = (float)arg;
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i5 = 0L; i5 < length; ++i5) {
                        float[] elem_a = _ac.getComplexFloat(i5);
                        double mod3 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                        double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]) / scale;
                        elem_res[0] = (float)(FastMath.log((double)mod3) / scale);
                        elem_res[1] = (float)arg;
                        resc.setComplexFloat(i5, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final double scale = FastMath.log((double)10.0);
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i6 = 0L; i6 < length; ++i6) {
                    double[] elem_a = _ac.getComplexDouble(i6);
                    double mod4 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                    double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]) / scale;
                    elem_res[0] = FastMath.log((double)mod4) / scale;
                    elem_res[1] = arg;
                    resc.setComplexDouble(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                double mod2 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                                double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]) / scale;
                                elem_res[0] = FastMath.log((double)mod2) / scale;
                                elem_res[1] = arg;
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i7 = 0L; i7 < length; ++i7) {
                        double[] elem_a = _ac.getComplexDouble(i7);
                        double mod5 = FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1]));
                        double arg = FastMath.atan2((double)elem_a[1], (double)elem_a[0]) / scale;
                        elem_res[0] = FastMath.log((double)mod5) / scale;
                        elem_res[1] = arg;
                        resc.setComplexDouble(i7, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray exp(LargeArray a2) {
        LargeArrayType out_type = a2.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a2.getType();
        return LargeArrayArithmetics.exp(a2, out_type);
    }

    public static LargeArray exp(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.exp((double)a2.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexExp(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexExp(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setDouble(i2, FastMath.exp((double)a2.getDouble(i2)));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, FastMath.exp((double)a2.getDouble(k2)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setDouble(i3, FastMath.exp((double)a2.getDouble(i3)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i4 = 0L; i4 < length; ++i4) {
                    float[] elem_a = _ac.getComplexFloat(i4);
                    elem_res[0] = (float)(FastMath.exp((double)elem_a[0]) * FastMath.cos((double)elem_a[1]));
                    elem_res[1] = (float)(FastMath.exp((double)elem_a[0]) * FastMath.sin((double)elem_a[1]));
                    resc.setComplexFloat(i4, elem_res);
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                elem_res[0] = (float)(FastMath.exp((double)elem_a[0]) * FastMath.cos((double)elem_a[1]));
                                elem_res[1] = (float)(FastMath.exp((double)elem_a[0]) * FastMath.sin((double)elem_a[1]));
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i5 = 0L; i5 < length; ++i5) {
                        float[] elem_a = _ac.getComplexFloat(i5);
                        elem_res[0] = (float)(FastMath.exp((double)elem_a[0]) * FastMath.cos((double)elem_a[1]));
                        elem_res[1] = (float)(FastMath.exp((double)elem_a[0]) * FastMath.sin((double)elem_a[1]));
                        resc.setComplexFloat(i5, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i6 = 0L; i6 < length; ++i6) {
                    double[] elem_a = _ac.getComplexDouble(i6);
                    elem_res[0] = FastMath.exp((double)elem_a[0]) * FastMath.cos((double)elem_a[1]);
                    elem_res[1] = FastMath.exp((double)elem_a[0]) * FastMath.sin((double)elem_a[1]);
                    resc.setComplexDouble(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                elem_res[0] = FastMath.exp((double)elem_a[0]) * FastMath.cos((double)elem_a[1]);
                                elem_res[1] = FastMath.exp((double)elem_a[0]) * FastMath.sin((double)elem_a[1]);
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i7 = 0L; i7 < length; ++i7) {
                        double[] elem_a = _ac.getComplexDouble(i7);
                        elem_res[0] = FastMath.exp((double)elem_a[0]) * FastMath.cos((double)elem_a[1]);
                        elem_res[1] = FastMath.exp((double)elem_a[0]) * FastMath.sin((double)elem_a[1]);
                        resc.setComplexDouble(i7, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray abs(LargeArray a2) {
        LargeArrayType out_type = a2.getType() == LargeArrayType.COMPLEX_FLOAT ? LargeArrayType.FLOAT : (a2.getType() == LargeArrayType.COMPLEX_DOUBLE ? LargeArrayType.DOUBLE : a2.getType());
        return LargeArrayArithmetics.abs(a2, out_type);
    }

    public static LargeArray abs(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.abs((long)a2.getLong(0L)));
            }
            if (out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.abs((double)a2.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, Float.valueOf(LargeArrayArithmetics.complexAbs(elem_a)));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAbs(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (a2.getType().isIntegerNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setDouble(i2, FastMath.abs((double)a2.getDouble(i2)));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setLong(k2, FastMath.abs((long)a2.getLong(k2)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setDouble(i3, FastMath.abs((double)a2.getDouble(i3)));
                    }
                }
            }
        } else if (a2.getType().isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i4 = 0L; i4 < length; ++i4) {
                    res.setDouble(i4, FastMath.abs((double)a2.getDouble(i4)));
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, FastMath.abs((double)a2.getDouble(k2)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i5 = 0L; i5 < length; ++i5) {
                        res.setDouble(i5, FastMath.abs((double)a2.getDouble(i5)));
                    }
                }
            }
        } else if (a2.getType() == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i6 = 0L; i6 < length; ++i6) {
                    float[] elem_a = _ac.getComplexFloat(i6);
                    res.setFloat(i6, (float)FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1])));
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                res.setFloat(k2, (float)FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1])));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i7 = 0L; i7 < length; ++i7) {
                        float[] elem_a = _ac.getComplexFloat(i7);
                        res.setFloat(i7, (float)FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1])));
                    }
                }
            }
        } else if (a2.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i8 = 0L; i8 < length; ++i8) {
                    double[] elem_a = _ac.getComplexDouble(i8);
                    res.setDouble(i8, FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1])));
                }
            } else {
                long k5 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j5 = 0; j5 < nthreads; ++j5) {
                    final long firstIdx = (long)j5 * k5;
                    final long lastIdx = j5 == nthreads - 1 ? length : firstIdx + k5;
                    threads[j5] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                res.setDouble(k2, FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1])));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i9 = 0L; i9 < length; ++i9) {
                        double[] elem_a = _ac.getComplexDouble(i9);
                        res.setDouble(i9, FastMath.sqrt((double)(elem_a[0] * elem_a[0] + elem_a[1] * elem_a[1])));
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray sin(LargeArray a2) {
        LargeArrayType out_type = a2.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a2.getType();
        return LargeArrayArithmetics.sin(a2, out_type);
    }

    public static LargeArray sin(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.sin((double)a2.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexSin(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexSin(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setDouble(i2, FastMath.sin((double)a2.getDouble(i2)));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, FastMath.sin((double)a2.getDouble(k2)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setDouble(i3, FastMath.sin((double)a2.getDouble(i3)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i4 = 0L; i4 < length; ++i4) {
                    float[] elem_a = _ac.getComplexFloat(i4);
                    elem_res[0] = (float)(FastMath.sin((double)elem_a[0]) * FastMath.cosh((double)elem_a[1]));
                    elem_res[1] = (float)(FastMath.cos((double)elem_a[0]) * FastMath.sinh((double)elem_a[1]));
                    resc.setComplexFloat(i4, elem_res);
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                elem_res[0] = (float)(FastMath.sin((double)elem_a[0]) * FastMath.cosh((double)elem_a[1]));
                                elem_res[1] = (float)(FastMath.cos((double)elem_a[0]) * FastMath.sinh((double)elem_a[1]));
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i5 = 0L; i5 < length; ++i5) {
                        float[] elem_a = _ac.getComplexFloat(i5);
                        elem_res[0] = (float)(FastMath.sin((double)elem_a[0]) * FastMath.cosh((double)elem_a[1]));
                        elem_res[1] = (float)(FastMath.cos((double)elem_a[0]) * FastMath.sinh((double)elem_a[1]));
                        resc.setComplexFloat(i5, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i6 = 0L; i6 < length; ++i6) {
                    double[] elem_a = _ac.getComplexDouble(i6);
                    elem_res[0] = FastMath.sin((double)elem_a[0]) * FastMath.cosh((double)elem_a[1]);
                    elem_res[1] = FastMath.cos((double)elem_a[0]) * FastMath.sinh((double)elem_a[1]);
                    resc.setComplexDouble(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                elem_res[0] = FastMath.sin((double)elem_a[0]) * FastMath.cosh((double)elem_a[1]);
                                elem_res[1] = FastMath.cos((double)elem_a[0]) * FastMath.sinh((double)elem_a[1]);
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i7 = 0L; i7 < length; ++i7) {
                        double[] elem_a = _ac.getComplexDouble(i7);
                        elem_res[0] = FastMath.sin((double)elem_a[0]) * FastMath.cosh((double)elem_a[1]);
                        elem_res[1] = FastMath.cos((double)elem_a[0]) * FastMath.sinh((double)elem_a[1]);
                        resc.setComplexDouble(i7, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray cos(LargeArray a2) {
        LargeArrayType out_type = a2.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a2.getType();
        return LargeArrayArithmetics.cos(a2, out_type);
    }

    public static LargeArray cos(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.cos((double)a2.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexCos(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexCos(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setDouble(i2, FastMath.cos((double)a2.getDouble(i2)));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, FastMath.cos((double)a2.getDouble(k2)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setDouble(i3, FastMath.cos((double)a2.getDouble(i3)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                float[] elem_res = new float[2];
                for (long i4 = 0L; i4 < length; ++i4) {
                    float[] elem_a = _ac.getComplexFloat(i4);
                    elem_res[0] = (float)(FastMath.cos((double)elem_a[0]) * FastMath.cosh((double)elem_a[1]));
                    elem_res[1] = (float)(-FastMath.sin((double)elem_a[0]) * FastMath.sinh((double)elem_a[1]));
                    resc.setComplexFloat(i4, elem_res);
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            float[] elem_res = new float[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                elem_res[0] = (float)(FastMath.cos((double)elem_a[0]) * FastMath.cosh((double)elem_a[1]));
                                elem_res[1] = (float)(-FastMath.sin((double)elem_a[0]) * FastMath.sinh((double)elem_a[1]));
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    float[] elem_res = new float[2];
                    for (long i5 = 0L; i5 < length; ++i5) {
                        float[] elem_a = _ac.getComplexFloat(i5);
                        elem_res[0] = (float)(FastMath.cos((double)elem_a[0]) * FastMath.cosh((double)elem_a[1]));
                        elem_res[1] = (float)(-FastMath.sin((double)elem_a[0]) * FastMath.sinh((double)elem_a[1]));
                        resc.setComplexFloat(i5, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                double[] elem_res = new double[2];
                for (long i6 = 0L; i6 < length; ++i6) {
                    double[] elem_a = _ac.getComplexDouble(i6);
                    elem_res[0] = FastMath.cos((double)elem_a[0]) * FastMath.cosh((double)elem_a[1]);
                    elem_res[1] = -FastMath.sin((double)elem_a[0]) * FastMath.sinh((double)elem_a[1]);
                    resc.setComplexDouble(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            double[] elem_res = new double[2];
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                elem_res[0] = FastMath.cos((double)elem_a[0]) * FastMath.cosh((double)elem_a[1]);
                                elem_res[1] = -FastMath.sin((double)elem_a[0]) * FastMath.sinh((double)elem_a[1]);
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    double[] elem_res = new double[2];
                    for (long i7 = 0L; i7 < length; ++i7) {
                        double[] elem_a = _ac.getComplexDouble(i7);
                        elem_res[0] = FastMath.cos((double)elem_a[0]) * FastMath.cosh((double)elem_a[1]);
                        elem_res[1] = -FastMath.sin((double)elem_a[0]) * FastMath.sinh((double)elem_a[1]);
                        resc.setComplexDouble(i7, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray tan(LargeArray a2) {
        LargeArrayType out_type = a2.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a2.getType();
        return LargeArrayArithmetics.tan(a2, out_type);
    }

    public static LargeArray tan(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.tan((double)a2.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexTan(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexTan(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setDouble(i2, FastMath.tan((double)a2.getDouble(i2)));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, FastMath.tan((double)a2.getDouble(k2)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setDouble(i3, FastMath.tan((double)a2.getDouble(i3)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i4 = 0L; i4 < length; ++i4) {
                    float[] elem_a = _ac.getComplexFloat(i4);
                    float[] s2 = LargeArrayArithmetics.complexSin(elem_a);
                    float[] c2 = LargeArrayArithmetics.complexCos(elem_a);
                    float[] elem_res = LargeArrayArithmetics.complexDiv(s2, c2);
                    resc.setComplexFloat(i4, elem_res);
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                float[] s2 = LargeArrayArithmetics.complexSin(elem_a);
                                float[] c2 = LargeArrayArithmetics.complexCos(elem_a);
                                float[] elem_res = LargeArrayArithmetics.complexDiv(s2, c2);
                                resc.setComplexFloat(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i5 = 0L; i5 < length; ++i5) {
                        float[] elem_a = _ac.getComplexFloat(i5);
                        float[] s3 = LargeArrayArithmetics.complexSin(elem_a);
                        float[] c3 = LargeArrayArithmetics.complexCos(elem_a);
                        float[] elem_res = LargeArrayArithmetics.complexDiv(s3, c3);
                        resc.setComplexFloat(i5, elem_res);
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i6 = 0L; i6 < length; ++i6) {
                    double[] elem_a = _ac.getComplexDouble(i6);
                    double[] s4 = LargeArrayArithmetics.complexSin(elem_a);
                    double[] c4 = LargeArrayArithmetics.complexCos(elem_a);
                    double[] elem_res = LargeArrayArithmetics.complexDiv(s4, c4);
                    resc.setComplexDouble(i6, elem_res);
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                double[] s2 = LargeArrayArithmetics.complexSin(elem_a);
                                double[] c2 = LargeArrayArithmetics.complexCos(elem_a);
                                double[] elem_res = LargeArrayArithmetics.complexDiv(s2, c2);
                                resc.setComplexDouble(k2, elem_res);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i7 = 0L; i7 < length; ++i7) {
                        double[] elem_a = _ac.getComplexDouble(i7);
                        double[] s5 = LargeArrayArithmetics.complexSin(elem_a);
                        double[] c5 = LargeArrayArithmetics.complexCos(elem_a);
                        double[] elem_res = LargeArrayArithmetics.complexDiv(s5, c5);
                        resc.setComplexDouble(i7, elem_res);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray asin(LargeArray a2) {
        LargeArrayType out_type = a2.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a2.getType();
        return LargeArrayArithmetics.asin(a2, out_type);
    }

    public static LargeArray asin(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.asin((double)a2.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAsin(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAsin(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setDouble(i2, FastMath.asin((double)a2.getDouble(i2)));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, FastMath.asin((double)a2.getDouble(k2)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setDouble(i3, FastMath.asin((double)a2.getDouble(i3)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i4 = 0L; i4 < length; ++i4) {
                    float[] elem_a = _ac.getComplexFloat(i4);
                    resc.setComplexFloat(i4, LargeArrayArithmetics.complexAsin(elem_a));
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                resc.setComplexFloat(k2, LargeArrayArithmetics.complexAsin(elem_a));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i5 = 0L; i5 < length; ++i5) {
                        float[] elem_a = _ac.getComplexFloat(i5);
                        resc.setComplexFloat(i5, LargeArrayArithmetics.complexAsin(elem_a));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i6 = 0L; i6 < length; ++i6) {
                    double[] elem_a = _ac.getComplexDouble(i6);
                    resc.setComplexDouble(i6, LargeArrayArithmetics.complexAsin(elem_a));
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                resc.setComplexDouble(k2, LargeArrayArithmetics.complexAsin(elem_a));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i7 = 0L; i7 < length; ++i7) {
                        double[] elem_a = _ac.getComplexDouble(i7);
                        resc.setComplexDouble(i7, LargeArrayArithmetics.complexAsin(elem_a));
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray acos(LargeArray a2) {
        LargeArrayType out_type = a2.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a2.getType();
        return LargeArrayArithmetics.acos(a2, out_type);
    }

    public static LargeArray acos(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.acos((double)a2.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAcos(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAcos(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setDouble(i2, FastMath.acos((double)a2.getDouble(i2)));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, FastMath.acos((double)a2.getDouble(k2)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setDouble(i3, FastMath.acos((double)a2.getDouble(i3)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i4 = 0L; i4 < length; ++i4) {
                    float[] elem_a = _ac.getComplexFloat(i4);
                    resc.setComplexFloat(i4, LargeArrayArithmetics.complexAcos(elem_a));
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                resc.setComplexFloat(k2, LargeArrayArithmetics.complexAcos(elem_a));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i5 = 0L; i5 < length; ++i5) {
                        float[] elem_a = _ac.getComplexFloat(i5);
                        resc.setComplexFloat(i5, LargeArrayArithmetics.complexAcos(elem_a));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i6 = 0L; i6 < length; ++i6) {
                    double[] elem_a = _ac.getComplexDouble(i6);
                    resc.setComplexDouble(i6, LargeArrayArithmetics.complexAcos(elem_a));
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                resc.setComplexDouble(k2, LargeArrayArithmetics.complexAcos(elem_a));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i7 = 0L; i7 < length; ++i7) {
                        double[] elem_a = _ac.getComplexDouble(i7);
                        resc.setComplexDouble(i7, LargeArrayArithmetics.complexAcos(elem_a));
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray atan(LargeArray a2) {
        LargeArrayType out_type = a2.getType().isIntegerNumericType() ? LargeArrayType.FLOAT : a2.getType();
        return LargeArrayArithmetics.atan(a2, out_type);
    }

    public static LargeArray atan(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric()) {
            throw new IllegalArgumentException("a == null || !a.isNumeric()");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
                return LargeArrayUtils.createConstant(out_type, length, FastMath.atan((double)a2.getDouble(0L)));
            }
            if (out_type == LargeArrayType.COMPLEX_FLOAT) {
                float[] elem_a = ((ComplexFloatLargeArray)a2).getComplexFloat(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAtan(elem_a));
            }
            if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
                double[] elem_a = ((ComplexDoubleLargeArray)a2).getComplexDouble(0L);
                return LargeArrayUtils.createConstant(out_type, length, LargeArrayArithmetics.complexAtan(elem_a));
            }
            throw new IllegalArgumentException("Invalid array type.");
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (out_type.isIntegerNumericType() || out_type.isRealNumericType()) {
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i2 = 0L; i2 < length; ++i2) {
                    res.setDouble(i2, FastMath.atan((double)a2.getDouble(i2)));
                }
            } else {
                long k2 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j2 = 0; j2 < nthreads; ++j2) {
                    final long firstIdx = (long)j2 * k2;
                    final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                    threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                res.setDouble(k2, FastMath.atan((double)a2.getDouble(k2)));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i3 = 0L; i3 < length; ++i3) {
                        res.setDouble(i3, FastMath.atan((double)a2.getDouble(i3)));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_FLOAT) {
            final ComplexFloatLargeArray _ac = (ComplexFloatLargeArray)a2;
            final ComplexFloatLargeArray resc = (ComplexFloatLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i4 = 0L; i4 < length; ++i4) {
                    float[] elem_a = _ac.getComplexFloat(i4);
                    resc.setComplexFloat(i4, LargeArrayArithmetics.complexAtan(elem_a));
                }
            } else {
                long k3 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j3 = 0; j3 < nthreads; ++j3) {
                    final long firstIdx = (long)j3 * k3;
                    final long lastIdx = j3 == nthreads - 1 ? length : firstIdx + k3;
                    threads[j3] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                float[] elem_a = _ac.getComplexFloat(k2);
                                resc.setComplexFloat(k2, LargeArrayArithmetics.complexAtan(elem_a));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i5 = 0L; i5 < length; ++i5) {
                        float[] elem_a = _ac.getComplexFloat(i5);
                        resc.setComplexFloat(i5, LargeArrayArithmetics.complexAtan(elem_a));
                    }
                }
            }
        } else if (out_type == LargeArrayType.COMPLEX_DOUBLE) {
            final ComplexDoubleLargeArray _ac = (ComplexDoubleLargeArray)a2;
            final ComplexDoubleLargeArray resc = (ComplexDoubleLargeArray)res;
            if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
                for (long i6 = 0L; i6 < length; ++i6) {
                    double[] elem_a = _ac.getComplexDouble(i6);
                    resc.setComplexDouble(i6, LargeArrayArithmetics.complexAtan(elem_a));
                }
            } else {
                long k4 = length / (long)nthreads;
                Future[] threads = new Future[nthreads];
                for (int j4 = 0; j4 < nthreads; ++j4) {
                    final long firstIdx = (long)j4 * k4;
                    final long lastIdx = j4 == nthreads - 1 ? length : firstIdx + k4;
                    threads[j4] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                                double[] elem_a = _ac.getComplexDouble(k2);
                                resc.setComplexDouble(k2, LargeArrayArithmetics.complexAtan(elem_a));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(threads);
                }
                catch (InterruptedException | ExecutionException ex) {
                    for (long i7 = 0L; i7 < length; ++i7) {
                        double[] elem_a = _ac.getComplexDouble(i7);
                        resc.setComplexDouble(i7, LargeArrayArithmetics.complexAtan(elem_a));
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid array type.");
        }
        return res;
    }

    public static LargeArray signum(LargeArray a2) {
        LargeArrayType out_type = LargeArrayType.BYTE;
        return LargeArrayArithmetics.signum(a2, out_type);
    }

    public static LargeArray signum(final LargeArray a2, LargeArrayType out_type) {
        if (a2 == null || !a2.isNumeric() || a2.getType() == LargeArrayType.COMPLEX_FLOAT || a2.getType() == LargeArrayType.COMPLEX_DOUBLE) {
            throw new IllegalArgumentException("a == null || !a.isNumeric() || a.getType() == LargeArrayType.COMPLEX_FLOAT || a.getType() == LargeArrayType.COMPLEX_DOUBLE");
        }
        if (!out_type.isNumericType()) {
            throw new IllegalArgumentException("Output type must be numeric.");
        }
        long length = a2.length();
        if (a2.isConstant()) {
            return LargeArrayUtils.createConstant(out_type, length, (byte)FastMath.signum((double)a2.getDouble(0L)));
        }
        final LargeArray res = LargeArrayUtils.create(out_type, length, false);
        int nthreads = (int)FastMath.min((long)length, (long)ConcurrencyUtils.getNumberOfThreads());
        if (nthreads < 2 || length < ConcurrencyUtils.getConcurrentThreshold()) {
            for (long i2 = 0L; i2 < length; ++i2) {
                res.setByte(i2, (byte)FastMath.signum((double)a2.getDouble(i2)));
            }
        } else {
            long k2 = length / (long)nthreads;
            Future[] threads = new Future[nthreads];
            for (int j2 = 0; j2 < nthreads; ++j2) {
                final long firstIdx = (long)j2 * k2;
                final long lastIdx = j2 == nthreads - 1 ? length : firstIdx + k2;
                threads[j2] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (long k2 = firstIdx; k2 < lastIdx; ++k2) {
                            res.setByte(k2, (byte)FastMath.signum((double)a2.getDouble(k2)));
                        }
                    }
                });
            }
            try {
                ConcurrencyUtils.waitForCompletion(threads);
            }
            catch (InterruptedException | ExecutionException ex) {
                for (long i3 = 0L; i3 < length; ++i3) {
                    res.setByte(i3, (byte)FastMath.signum((double)a2.getDouble(i3)));
                }
            }
        }
        return res;
    }
}

