/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.ssl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.python.netty.handler.ssl.CipherSuiteFilter;

public final class SupportedCipherSuiteFilter
implements CipherSuiteFilter {
    public static final SupportedCipherSuiteFilter INSTANCE = new SupportedCipherSuiteFilter();

    private SupportedCipherSuiteFilter() {
    }

    @Override
    public String[] filterCipherSuites(Iterable<String> ciphers, List<String> defaultCiphers, Set<String> supportedCiphers) {
        ArrayList<String> newCiphers;
        if (defaultCiphers == null) {
            throw new NullPointerException("defaultCiphers");
        }
        if (supportedCiphers == null) {
            throw new NullPointerException("supportedCiphers");
        }
        if (ciphers == null) {
            newCiphers = new ArrayList<String>(defaultCiphers.size());
            ciphers = defaultCiphers;
        } else {
            newCiphers = new ArrayList(supportedCiphers.size());
        }
        for (String c2 : ciphers) {
            if (c2 == null) break;
            if (!supportedCiphers.contains(c2)) continue;
            newCiphers.add(c2);
        }
        return newCiphers.toArray(new String[newCiphers.size()]);
    }
}

