/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInstance;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.modules.math;

public class cmath {
    public static final PyFloat pi = new PyFloat(Math.PI);
    public static final PyFloat e = new PyFloat(Math.E);
    private static final double ROOT_HALF = 0.7071067811865476;
    private static final double NEARLY_LN_DBL_MAX = 709.4361393;
    private static final double ATLEAST_27LN2 = 18.72;
    private static final double HALF_E2 = 3.6945280494653248;
    private static final double LOG10E = 0.4342944819032518;

    private static PyComplex complexFromPyObject(PyObject obj) {
        if (obj instanceof PyComplex) {
            return (PyComplex)obj;
        }
        PyObject newObj = null;
        if (obj instanceof PyInstance) {
            if (obj.__findattr__("__complex__") != null) {
                newObj = obj.invoke("__complex__");
            }
        } else {
            PyObject complexFunc = obj.getType().lookup("__complex__");
            if (complexFunc != null) {
                newObj = complexFunc.__call__(obj);
            }
        }
        if (newObj != null) {
            if (!(newObj instanceof PyComplex)) {
                throw Py.TypeError("__complex__ should return a complex object");
            }
            return (PyComplex)newObj;
        }
        return new PyComplex(obj.asDouble(), 0.0);
    }

    public static PyComplex acos(PyObject w2) {
        return cmath._acos(cmath.complexFromPyObject(w2));
    }

    private static PyComplex _acos(PyComplex w2) {
        double y2;
        double x2;
        double u2 = w2.real;
        double v2 = w2.imag;
        if (Math.abs(u2) > 1.34217728E8 || Math.abs(v2) > 1.34217728E8) {
            x2 = Math.atan2(Math.abs(v2), u2);
            y2 = Math.copySign(cmath.logHypot(u2, v2) + 0.6931471805599453, -v2);
        } else if (Double.isNaN(v2)) {
            x2 = u2 == 0.0 ? 1.5707963267948966 : v2;
            y2 = v2;
        } else {
            PyComplex a2 = cmath.sqrt(new PyComplex(1.0 - u2, -v2));
            PyComplex b2 = cmath.sqrt(new PyComplex(1.0 + u2, v2));
            x2 = 2.0 * Math.atan2(a2.real, b2.real);
            y2 = math.asinh(a2.imag * b2.real - a2.real * b2.imag);
        }
        return cmath.exceptNaN(new PyComplex(x2, y2), w2);
    }

    public static PyComplex acosh(PyObject w2) {
        return cmath._acosh(cmath.complexFromPyObject(w2));
    }

    private static PyComplex _acosh(PyComplex w2) {
        double y2;
        double x2;
        double u2 = w2.real;
        double v2 = w2.imag;
        if (Math.abs(u2) > 1.34217728E8 || Math.abs(v2) > 1.34217728E8) {
            x2 = cmath.logHypot(u2, v2) + 0.6931471805599453;
            y2 = Math.atan2(v2, u2);
        } else if (v2 == 0.0 && !Double.isNaN(u2)) {
            if (u2 >= 1.0) {
                x2 = math.acosh(u2);
                y2 = v2;
            } else if (u2 < -1.0) {
                x2 = math.acosh(-u2);
                y2 = Math.copySign(Math.PI, v2);
            } else {
                x2 = 0.0;
                y2 = Math.copySign(Math.acos(u2), v2);
            }
        } else {
            PyComplex a2 = cmath.sqrt(new PyComplex(u2 - 1.0, v2));
            PyComplex b2 = cmath.sqrt(new PyComplex(u2 + 1.0, v2));
            x2 = math.asinh(a2.real * b2.real + a2.imag * b2.imag);
            y2 = 2.0 * Math.atan2(a2.imag, b2.real);
        }
        return cmath.exceptNaN(new PyComplex(x2, y2), w2);
    }

    public static PyComplex asin(PyObject w2) {
        return cmath.asinOrAsinh(cmath.complexFromPyObject(w2), false);
    }

    public static PyComplex asinh(PyObject w2) {
        return cmath.asinOrAsinh(cmath.complexFromPyObject(w2), true);
    }

    private static PyComplex asinOrAsinh(PyComplex w2, boolean h2) {
        double y2;
        double x2;
        double v2;
        double u2;
        if (h2) {
            u2 = w2.real;
            v2 = w2.imag;
        } else {
            v2 = w2.real;
            u2 = -w2.imag;
        }
        if (Double.isNaN(u2)) {
            if (v2 == 0.0) {
                x2 = u2;
                y2 = v2;
            } else if (Double.isInfinite(v2)) {
                x2 = Double.POSITIVE_INFINITY;
                y2 = u2;
            } else {
                x2 = y2 = u2;
            }
        } else if (Math.abs(u2) > 1.34217728E8 || Math.abs(v2) > 1.34217728E8) {
            x2 = cmath.logHypot(u2, v2) + 0.6931471805599453;
            if (Math.copySign(1.0, u2) > 0.0) {
                y2 = Math.atan2(v2, u2);
            } else {
                x2 = -x2;
                y2 = Math.atan2(v2, -u2);
            }
        } else {
            PyComplex a2 = cmath.sqrt(new PyComplex(1.0 + v2, -u2));
            PyComplex b2 = cmath.sqrt(new PyComplex(1.0 - v2, u2));
            x2 = math.asinh(a2.real * b2.imag - a2.imag * b2.real);
            y2 = Math.atan2(v2, a2.real * b2.real - a2.imag * b2.imag);
        }
        PyComplex z2 = h2 ? new PyComplex(x2, y2) : new PyComplex(y2, -x2);
        return cmath.exceptNaN(z2, w2);
    }

    public static PyComplex atan(PyObject w2) {
        return cmath.atanOrAtanh(cmath.complexFromPyObject(w2), false);
    }

    public static PyComplex atanh(PyObject w2) {
        return cmath.atanOrAtanh(cmath.complexFromPyObject(w2), true);
    }

    private static PyComplex atanOrAtanh(PyComplex w2, boolean h2) {
        double y2;
        double x2;
        double v2;
        double u2;
        if (h2) {
            u2 = w2.real;
            v2 = w2.imag;
        } else {
            v2 = w2.real;
            u2 = -w2.imag;
        }
        double absu = Math.abs(u2);
        double absv = Math.abs(v2);
        if (absu >= 6.703903964971299E153 || absv >= 6.703903964971299E153) {
            if (Double.isInfinite(absu) || Double.isInfinite(absv)) {
                x2 = Math.copySign(0.0, u2);
            } else {
                int N2 = 520;
                double uu = Math.scalb(u2, -N2);
                double vv = Math.scalb(v2, -N2);
                double mod2w = uu * uu + vv * vv;
                x2 = Math.scalb(uu / mod2w, -N2);
            }
            y2 = Double.isNaN(v2) ? v2 : Math.copySign(1.5707963267948966, v2);
        } else if (absu < (double)1.110223E-16f) {
            if (absv > 7.450580596923828E-9) {
                double v22 = v2 * v2;
                double d2 = 1.0 + v22;
                x2 = Math.copySign(Math.log1p(4.0 * absu / d2), u2) * 0.25;
                y2 = Math.atan2(2.0 * v2, 1.0 - v22) * 0.5;
            } else {
                x2 = u2;
                y2 = v2;
            }
        } else if (absu == 1.0 && absv < 7.450580596923828E-9) {
            x2 = Math.copySign(Math.log(absv) - 0.6931471805599453, u2) * 0.5;
            y2 = v2 == 0.0 ? Double.NaN : Math.copySign(Math.atan2(2.0, absv), v2) * 0.5;
        } else {
            double lmu = 1.0 - absu;
            double lpu = 1.0 + absu;
            double v23 = v2 * v2;
            double d3 = lmu * lmu + v23;
            x2 = Math.copySign(Math.log1p(4.0 * absu / d3), u2) * 0.25;
            y2 = Math.atan2(2.0 * v2, lmu * lpu - v23) * 0.5;
        }
        PyComplex z2 = h2 ? new PyComplex(x2, y2) : new PyComplex(y2, -x2);
        return cmath.exceptNaN(z2, w2);
    }

    public static PyComplex cos(PyObject z2) {
        return cmath.cosOrCosh(cmath.complexFromPyObject(z2), false);
    }

    public static PyComplex cosh(PyObject z2) {
        return cmath.cosOrCosh(cmath.complexFromPyObject(z2), true);
    }

    private static PyComplex cosOrCosh(PyComplex z2, boolean h2) {
        double v2;
        double u2;
        double y2;
        double x2;
        if (h2) {
            x2 = z2.real;
            y2 = z2.imag;
        } else {
            y2 = z2.real;
            x2 = -z2.imag;
        }
        if (y2 == 0.0) {
            u2 = math.cosh(x2);
            v2 = Math.copySign(1.0, x2) * y2;
        } else if (x2 == 0.0) {
            u2 = Math.cos(y2);
            v2 = x2 * Math.copySign(1.0, y2);
        } else {
            double cosy = Math.cos(y2);
            double siny = Math.sin(y2);
            double absx = Math.abs(x2);
            if (absx == Double.POSITIVE_INFINITY) {
                if (!Double.isNaN(cosy)) {
                    u2 = absx * cosy;
                    v2 = x2 * siny;
                } else {
                    u2 = absx;
                    v2 = Double.NaN;
                }
            } else if (absx > 18.72) {
                double r2 = Math.exp(absx - 2.0);
                u2 = r2 * cosy * 3.6945280494653248;
                v2 = Math.copySign(r2, x2) * siny * 3.6945280494653248;
                if (Double.isInfinite(u2) || Double.isInfinite(v2)) {
                    throw math.mathRangeError();
                }
            } else {
                u2 = Math.cosh(x2) * cosy;
                v2 = Math.sinh(x2) * siny;
            }
        }
        PyComplex w2 = new PyComplex(u2, v2);
        return cmath.exceptNaN(w2, z2);
    }

    public static PyComplex exp(PyObject z2) {
        double v2;
        double u2;
        PyComplex zz = cmath.complexFromPyObject(z2);
        double x2 = zz.real;
        double y2 = zz.imag;
        if (y2 == 0.0) {
            u2 = math.exp(x2);
            v2 = y2;
        } else {
            double cosy = Math.cos(y2);
            double siny = Math.sin(y2);
            if (x2 == Double.NEGATIVE_INFINITY) {
                u2 = Math.copySign(0.0, cosy);
                v2 = Math.copySign(0.0, siny);
            } else if (x2 == Double.POSITIVE_INFINITY) {
                if (!Double.isNaN(cosy)) {
                    u2 = Math.copySign(x2, cosy);
                    v2 = Math.copySign(x2, siny);
                } else {
                    u2 = x2;
                    v2 = Double.NaN;
                }
            } else if (x2 > 709.4361393) {
                double r2 = Math.exp(x2 - 1.0);
                u2 = r2 * cosy * Math.E;
                v2 = r2 * siny * Math.E;
                if (Double.isInfinite(u2) || Double.isInfinite(v2)) {
                    throw math.mathRangeError();
                }
            } else {
                double r3 = Math.exp(x2);
                u2 = r3 * cosy;
                v2 = r3 * siny;
            }
        }
        return cmath.exceptNaN(new PyComplex(u2, v2), zz);
    }

    public static double phase(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        return Math.atan2(x2.imag, x2.real);
    }

    public static PyTuple polar(PyObject in) {
        PyComplex z2 = cmath.complexFromPyObject(in);
        double phi = Math.atan2(z2.imag, z2.real);
        double r2 = math.hypot(z2.real, z2.imag);
        return new PyTuple(new PyFloat(r2), new PyFloat(phi));
    }

    public static PyComplex rect(double r2, double phi) {
        double y2;
        double x2;
        if (Double.isInfinite(r2) && (Double.isInfinite(phi) || Double.isNaN(phi))) {
            x2 = Double.POSITIVE_INFINITY;
            y2 = Double.NaN;
        } else if (phi == 0.0) {
            x2 = r2;
            y2 = Double.isNaN(r2) ? phi : (Double.isInfinite(r2) ? phi * Math.copySign(1.0, r2) : phi * r2);
        } else if (r2 == 0.0 && (Double.isInfinite(phi) || Double.isNaN(phi))) {
            y2 = 0.0;
            x2 = 0.0;
        } else {
            x2 = r2 * Math.cos(phi);
            y2 = r2 * Math.sin(phi);
        }
        return cmath.exceptNaN(new PyComplex(x2, y2), r2, phi);
    }

    public static boolean isinf(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        return Double.isInfinite(x2.real) || Double.isInfinite(x2.imag);
    }

    public static boolean isnan(PyObject in) {
        PyComplex x2 = cmath.complexFromPyObject(in);
        return Double.isNaN(x2.real) || Double.isNaN(x2.imag);
    }

    public static PyComplex log(PyObject w2) {
        PyComplex ww = cmath.complexFromPyObject(w2);
        double u2 = ww.real;
        double v2 = ww.imag;
        double lnr = cmath.logHypot(u2, v2);
        double theta = Math.atan2(v2, u2);
        PyComplex z2 = new PyComplex(lnr, theta);
        return cmath.exceptNaN(z2, ww);
    }

    public static PyComplex log10(PyObject w2) {
        PyComplex ww = cmath.complexFromPyObject(w2);
        double u2 = ww.real;
        double v2 = ww.imag;
        double logr = cmath.logHypot(u2, v2) * 0.4342944819032518;
        double theta = Math.atan2(v2, u2) * 0.4342944819032518;
        PyComplex z2 = new PyComplex(logr, theta);
        return cmath.exceptNaN(z2, ww);
    }

    public static PyComplex log(PyObject w2, PyObject b2) {
        PyComplex z2;
        PyComplex ww = cmath.complexFromPyObject(w2);
        PyComplex bb = cmath.complexFromPyObject(b2);
        double u2 = ww.real;
        double v2 = ww.imag;
        double br = bb.real;
        double bi = bb.imag;
        double x2 = cmath.logHypot(u2, v2);
        double y2 = Math.atan2(v2, u2);
        if (bi != 0.0 || br <= 0.0) {
            PyComplex lnb = cmath.log(bb);
            z2 = (PyComplex)new PyComplex(x2, y2).__div__(lnb);
        } else {
            double lnb = Math.log(br);
            z2 = new PyComplex(x2 / lnb, y2 / lnb);
        }
        return cmath.exceptNaN(z2, ww);
    }

    private static double logHypot(double u2, double v2) {
        double lnr;
        if (Double.isInfinite(u2) || Double.isInfinite(v2)) {
            return Double.POSITIVE_INFINITY;
        }
        int scale = 0;
        int ue = Math.getExponent(u2);
        int ve = Math.getExponent(v2);
        if (ue < -511 && ve < -511) {
            scale = 600;
        } else if (ue > 510 || ve > 510) {
            scale = -600;
        }
        if (scale == 0) {
            lnr = 0.5 * Math.log(u2 * u2 + v2 * v2);
        } else {
            double us = Math.scalb(u2, scale);
            double vs = Math.scalb(v2, scale);
            double rs2 = us * us + vs * vs;
            lnr = 0.5 * Math.log(rs2) - (double)scale * 0.6931471805599453;
        }
        if (lnr == Double.NEGATIVE_INFINITY) {
            throw math.mathDomainError();
        }
        return lnr;
    }

    public static PyComplex sin(PyObject z2) {
        return cmath.sinOrSinh(cmath.complexFromPyObject(z2), false);
    }

    public static PyComplex sinh(PyObject z2) {
        return cmath.sinOrSinh(cmath.complexFromPyObject(z2), true);
    }

    private static PyComplex sinOrSinh(PyComplex z2, boolean h2) {
        double v2;
        double u2;
        double y2;
        double x2;
        if (h2) {
            x2 = z2.real;
            y2 = z2.imag;
        } else {
            y2 = z2.real;
            x2 = -z2.imag;
        }
        if (y2 == 0.0) {
            u2 = math.sinh(x2);
            v2 = y2;
        } else if (x2 == 0.0) {
            v2 = Math.sin(y2);
            u2 = x2;
        } else {
            double cosy = Math.cos(y2);
            double siny = Math.sin(y2);
            double absx = Math.abs(x2);
            if (absx == Double.POSITIVE_INFINITY) {
                if (!Double.isNaN(cosy)) {
                    u2 = x2 * cosy;
                    v2 = absx * siny;
                } else {
                    u2 = x2;
                    v2 = Double.NaN;
                }
            } else if (absx > 18.72) {
                double r2 = Math.exp(absx - 2.0);
                v2 = r2 * siny * 3.6945280494653248;
                u2 = Math.copySign(r2, x2) * cosy * 3.6945280494653248;
                if (Double.isInfinite(u2) || Double.isInfinite(v2)) {
                    throw math.mathRangeError();
                }
            } else {
                u2 = Math.sinh(x2) * cosy;
                v2 = Math.cosh(x2) * siny;
            }
        }
        PyComplex w2 = h2 ? new PyComplex(u2, v2) : new PyComplex(v2, -u2);
        return cmath.exceptNaN(w2, z2);
    }

    public static PyComplex sqrt(PyObject w2) {
        double y2;
        double x2;
        PyComplex ww = cmath.complexFromPyObject(w2);
        double u2 = Math.abs(ww.real);
        double v2 = Math.abs(ww.imag);
        if (Double.isInfinite(u2)) {
            x2 = Double.POSITIVE_INFINITY;
            y2 = Double.isNaN(v2) || Double.isInfinite(v2) ? v2 : 0.0;
        } else if (Double.isInfinite(v2)) {
            y2 = Double.POSITIVE_INFINITY;
            x2 = Double.POSITIVE_INFINITY;
        } else if (Double.isNaN(u2)) {
            x2 = y2 = u2;
        } else if (v2 == 0.0) {
            x2 = u2 == 0.0 ? 0.0 : Math.sqrt(u2);
            y2 = 0.0;
        } else if (u2 == 0.0) {
            x2 = y2 = 0.7071067811865476 * Math.sqrt(v2);
        } else {
            int ve;
            int ue = Math.getExponent(u2);
            int diff = ue - (ve = Math.getExponent(v2));
            if (diff > 27) {
                x2 = Math.sqrt(u2);
            } else if (diff < -27) {
                x2 = ve >= 1023 ? Math.sqrt(0.5 * u2 + 0.5 * v2) : Math.sqrt(0.5 * (u2 + v2));
            } else {
                double b2;
                double a2;
                int LARGE = 510;
                int SMALL = -510;
                int SCALE = 600;
                int n2 = 0;
                if (ue > 510 || ve > 510) {
                    a2 = Math.scalb(u2, -601);
                    b2 = Math.scalb(v2, -601);
                    n2 = -600;
                } else if (ue < -510 && ve < -510) {
                    a2 = Math.scalb(u2, 599);
                    b2 = Math.scalb(v2, 599);
                    n2 = 600;
                } else {
                    a2 = 0.5 * u2;
                    b2 = 0.5 * v2;
                }
                double s2 = Math.sqrt(a2 * a2 + b2 * b2);
                x2 = Math.sqrt(s2 + a2);
                if (n2 != 0) {
                    x2 = Math.scalb(x2, -n2 / 2);
                }
            }
            y2 = v2 / (x2 + x2);
        }
        if (ww.real < 0.0) {
            return new PyComplex(y2, Math.copySign(x2, ww.imag));
        }
        return new PyComplex(x2, Math.copySign(y2, ww.imag));
    }

    public static PyComplex tan(PyObject z2) {
        return cmath.tanOrTanh(cmath.complexFromPyObject(z2), false);
    }

    public static PyComplex tanh(PyObject z2) {
        return cmath.tanOrTanh(cmath.complexFromPyObject(z2), true);
    }

    private static PyComplex tanOrTanh(PyComplex z2, boolean h2) {
        double v2;
        double u2;
        double y2;
        double x2;
        if (h2) {
            x2 = z2.real;
            y2 = z2.imag;
        } else {
            y2 = z2.real;
            x2 = -z2.imag;
        }
        if (y2 == 0.0) {
            u2 = Math.tanh(x2);
            v2 = y2;
        } else if (x2 == 0.0 && !Double.isNaN(y2)) {
            v2 = Math.tan(y2);
            u2 = x2;
        } else {
            double cosy = Math.cos(y2);
            double siny = Math.sin(y2);
            double absx = Math.abs(x2);
            if (absx > 18.72) {
                double s2 = 0.25 * Math.exp(2.0 * absx);
                u2 = Math.copySign(1.0, x2);
                v2 = s2 == Double.POSITIVE_INFINITY ? Math.copySign(0.0, siny * cosy) : siny * cosy / s2;
            } else {
                double sinhx = Math.sinh(x2);
                double coshx = Math.cosh(x2);
                double s3 = sinhx * sinhx + cosy * cosy;
                u2 = sinhx * coshx / s3;
                v2 = siny * cosy / s3;
            }
        }
        PyComplex w2 = h2 ? new PyComplex(u2, v2) : new PyComplex(v2, -u2);
        return cmath.exceptNaN(w2, z2);
    }

    private static PyComplex exceptNaN(PyComplex result, PyComplex arg) throws PyException {
        if ((Double.isNaN(result.real) || Double.isNaN(result.imag)) && !Double.isNaN(arg.real) && !Double.isNaN(arg.imag)) {
            throw math.mathDomainError();
        }
        return result;
    }

    private static PyComplex exceptNaN(PyComplex result, double a2, double b2) throws PyException {
        if ((Double.isNaN(result.real) || Double.isNaN(result.imag)) && !Double.isNaN(a2) && !Double.isNaN(b2)) {
            throw math.mathDomainError();
        }
        return result;
    }
}

