/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._weakref;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.python.core.JyAttribute;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.modules._weakref.AbstractReference;
import org.python.modules._weakref.ReferenceBackend;
import org.python.modules._weakref.ReferenceBackendFactory;
import org.python.modules.gc;
import org.python.util.Generic;

public class GlobalRef
extends WeakReference<PyObject>
implements ReferenceBackend {
    public static ReferenceBackendFactory factory = null;
    private int hashCode;
    private int pythonHashCode;
    private boolean havePythonHashCode;
    protected boolean cleared = false;
    private List<WeakReference<AbstractReference>> references = new ArrayList<WeakReference<AbstractReference>>();
    private static ReferenceQueue<PyObject> referenceQueue = new ReferenceQueue();
    private static Thread reaperThread;
    private static ReentrantReadWriteLock reaperLock;
    private static ConcurrentMap<GlobalRef, ReferenceBackend> objects;
    private static List<GlobalRef> delayedCallbacks;

    public GlobalRef(PyObject object) {
        super(object, referenceQueue);
        this.hashCode = System.identityHashCode(object);
    }

    @Override
    public synchronized void add(AbstractReference ref) {
        WeakReference<AbstractReference> r2 = new WeakReference<AbstractReference>(ref);
        this.references.add(r2);
    }

    private final AbstractReference getReferenceAt(int idx) {
        WeakReference<AbstractReference> wref = this.references.get(idx);
        return (AbstractReference)wref.get();
    }

    @Override
    public synchronized AbstractReference find(Class<?> cls) {
        for (int i2 = this.references.size() - 1; i2 >= 0; --i2) {
            AbstractReference r2 = this.getReferenceAt(i2);
            if (r2 == null) {
                this.references.remove(i2);
                continue;
            }
            if (r2.callback != null || r2.getClass() != cls) continue;
            return r2;
        }
        return null;
    }

    synchronized void call() {
        if (!this.cleared) {
            this.cleared = true;
            for (int i2 = this.references.size() - 1; i2 >= 0; --i2) {
                AbstractReference r2 = this.getReferenceAt(i2);
                if (r2 == null) {
                    this.references.remove(i2);
                    continue;
                }
                Thread pendingGet = (Thread)JyAttribute.getAttr(r2, (byte)3);
                if (pendingGet != null) {
                    pendingGet.interrupt();
                }
                r2.call();
            }
            ReferenceBackend ref2 = (ReferenceBackend)objects.get(this);
            if (ref2.isCleared()) {
                objects.remove(this);
            } else if (factory != null && ref2 != this) {
                factory.notifyClear(ref2, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processDelayedCallbacks() {
        if (delayedCallbacks != null) {
            List<GlobalRef> list = delayedCallbacks;
            synchronized (list) {
                for (GlobalRef gref : delayedCallbacks) {
                    gref.call();
                }
                delayedCallbacks.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void delayedCallback(GlobalRef cl) {
        if (delayedCallbacks == null) {
            delayedCallbacks = new ArrayList<GlobalRef>();
        }
        List<GlobalRef> list = delayedCallbacks;
        synchronized (list) {
            delayedCallbacks.add(cl);
        }
    }

    public static boolean hasDelayedCallbacks() {
        return delayedCallbacks != null && !delayedCallbacks.isEmpty();
    }

    @Override
    public boolean isCleared() {
        return this.cleared;
    }

    @Override
    public synchronized int count() {
        for (int i2 = this.references.size() - 1; i2 >= 0; --i2) {
            AbstractReference r2 = this.getReferenceAt(i2);
            if (r2 != null) continue;
            this.references.remove(i2);
        }
        return this.references.size();
    }

    @Override
    public synchronized PyList refs() {
        ArrayList<AbstractReference> list = new ArrayList<AbstractReference>();
        for (int i2 = this.references.size() - 1; i2 >= 0; --i2) {
            AbstractReference r2 = this.getReferenceAt(i2);
            if (r2 == null) {
                this.references.remove(i2);
                continue;
            }
            list.add(r2);
        }
        return new PyList(list);
    }

    protected synchronized ReferenceBackend retryFactory() {
        if (factory == null) {
            return null;
        }
        ReferenceBackend result = factory.makeBackend(this, null);
        if (result != this) {
            objects.put(this, result);
            for (int i2 = this.references.size() - 1; i2 >= 0; --i2) {
                AbstractReference r2 = this.getReferenceAt(i2);
                if (r2 == null) {
                    this.references.remove(i2);
                    continue;
                }
                r2.gref = result;
            }
            PyObject referent = result.get();
            JyAttribute.setAttr(referent, (byte)0, result);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferenceBackend newInstance(PyObject object) {
        GlobalRef.createReaperThreadIfAbsent();
        GlobalRef newRef = new GlobalRef(object);
        ConcurrentMap<GlobalRef, ReferenceBackend> concurrentMap = objects;
        synchronized (concurrentMap) {
            ReferenceBackend ref = (ReferenceBackend)objects.get(newRef);
            if (ref == null) {
                ref = factory == null ? newRef : factory.makeBackend(newRef, object);
                objects.put(newRef, ref);
                JyAttribute.setAttr(object, (byte)0, ref);
            } else {
                newRef.clear();
                newRef.cleared = true;
            }
            return ref;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void restore(PyObject formerReferent) {
        ReferenceBackend formerBackend = (ReferenceBackend)JyAttribute.getAttr(formerReferent, (byte)0);
        ReferenceBackend proxy = (ReferenceBackend)objects.get(this);
        if (formerBackend != this && formerBackend != proxy) {
            throw new IllegalArgumentException("Argument is not former referent of this GlobalRef.");
        }
        if (delayedCallbacks != null) {
            List<GlobalRef> list = delayedCallbacks;
            synchronized (list) {
                delayedCallbacks.remove(this);
            }
        }
        this.clear();
        GlobalRef.createReaperThreadIfAbsent();
        GlobalRef restore = new GlobalRef(formerReferent);
        if (proxy != this && factory != null) {
            factory.updateBackend(proxy, restore);
        } else {
            JyAttribute.setAttr(formerReferent, (byte)0, restore);
        }
        restore.references = this.references;
        objects.remove(this);
        objects.put(restore, proxy == this ? restore : proxy);
        for (int i2 = this.references.size() - 1; i2 >= 0; --i2) {
            Thread pendingGet;
            AbstractReference aref = this.getReferenceAt(i2);
            if (aref == null) {
                this.references.remove(i2);
                continue;
            }
            if (this == proxy) {
                aref.gref = restore;
            }
            if ((pendingGet = (Thread)JyAttribute.getAttr(aref, (byte)3)) == null) continue;
            pendingGet.interrupt();
        }
        this.cleared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createReaperThreadIfAbsent() {
        block6: {
            reaperLock.readLock().lock();
            try {
                if (reaperThread != null && reaperThread.isAlive()) break block6;
                reaperLock.readLock().unlock();
                reaperLock.writeLock().lock();
                if (reaperThread != null && reaperThread.isAlive()) break block6;
                try {
                    GlobalRef.initReaperThread();
                }
                finally {
                    reaperLock.readLock().lock();
                    reaperLock.writeLock().unlock();
                }
            }
            finally {
                reaperLock.readLock().unlock();
            }
        }
    }

    public static int getCount(PyObject object) {
        ReferenceBackend ref = (ReferenceBackend)objects.get(new GlobalRef(object));
        return ref == null ? 0 : ref.count();
    }

    public static PyList getRefs(PyObject object) {
        ReferenceBackend ref = (ReferenceBackend)objects.get(new GlobalRef(object));
        return ref == null ? new PyList() : ref.refs();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof GlobalRef)) {
            return false;
        }
        Object t2 = this.get();
        Object u2 = ((GlobalRef)o2).get();
        if (t2 == null || u2 == null) {
            return false;
        }
        return t2 == u2;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int pythonHashCode() {
        if (this.havePythonHashCode) {
            return this.pythonHashCode;
        }
        Object referent = this.get();
        if (referent == null) {
            throw Py.TypeError("weak object has gone away");
        }
        this.pythonHashCode = referent.hashCode();
        this.havePythonHashCode = true;
        return this.pythonHashCode;
    }

    private static void initReaperThread() {
        RefReaper reaper = new RefReaper();
        PySystemState systemState = Py.getSystemState();
        systemState.registerCloser(reaper);
        reaperThread = new Thread((Runnable)reaper, "weakref reaper");
        reaperThread.setDaemon(true);
        reaperThread.start();
    }

    static {
        reaperLock = new ReentrantReadWriteLock();
        objects = Generic.concurrentMap();
    }

    private static class RefReaper
    implements Runnable,
    Callable<Void> {
        private volatile boolean exit = false;
        private Thread thread;

        private RefReaper() {
        }

        public void collect() throws InterruptedException {
            GlobalRef gr = (GlobalRef)referenceQueue.remove();
            if (!gc.delayedWeakrefCallbacksEnabled()) {
                gr.call();
            } else {
                GlobalRef.delayedCallback(gr);
            }
        }

        @Override
        public void run() {
            this.thread = Thread.currentThread();
            while (true) {
                try {
                    while (true) {
                        this.collect();
                    }
                }
                catch (InterruptedException exc) {
                    if (!this.exit) continue;
                    return;
                }
                break;
            }
        }

        @Override
        public Void call() throws Exception {
            this.exit = true;
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
                this.thread = null;
            }
            return null;
        }
    }
}

