/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.security.MessageDigest;

public class SHA224Digest
extends MessageDigest {
    private static final int BYTE_LENGTH = 64;
    private byte[] xBuf;
    private int xBufOff;
    private long byteCount;
    private static final int DIGEST_LENGTH = 28;
    private int H1;
    private int H2;
    private int H3;
    private int H4;
    private int H5;
    private int H6;
    private int H7;
    private int H8;
    private int[] X = new int[64];
    private int xOff;
    static final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};

    @Override
    public void update(byte in) {
        this.xBuf[this.xBufOff++] = in;
        if (this.xBufOff == this.xBuf.length) {
            this.processWord(this.xBuf, 0);
            this.xBufOff = 0;
        }
        ++this.byteCount;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        while (this.xBufOff != 0 && len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
        while (len > this.xBuf.length) {
            this.processWord(in, inOff);
            inOff += this.xBuf.length;
            len -= this.xBuf.length;
            this.byteCount += (long)this.xBuf.length;
        }
        while (len > 0) {
            this.update(in[inOff]);
            ++inOff;
            --len;
        }
    }

    public void finish() {
        long bitLength = this.byteCount << 3;
        this.update((byte)-128);
        while (this.xBufOff != 0) {
            this.update((byte)0);
        }
        this.processLength(bitLength);
        this.processBlock();
    }

    public int getByteLength() {
        return 64;
    }

    public SHA224Digest() {
        super("SHA-224");
        this.xBuf = new byte[4];
        this.xBufOff = 0;
        this.reset();
    }

    public SHA224Digest(SHA224Digest t2) {
        super("SHA-224");
        this.xBuf = new byte[t2.xBuf.length];
        System.arraycopy(t2.xBuf, 0, this.xBuf, 0, t2.xBuf.length);
        this.xBufOff = t2.xBufOff;
        this.byteCount = t2.byteCount;
        this.H1 = t2.H1;
        this.H2 = t2.H2;
        this.H3 = t2.H3;
        this.H4 = t2.H4;
        this.H5 = t2.H5;
        this.H6 = t2.H6;
        this.H7 = t2.H7;
        this.H8 = t2.H8;
        System.arraycopy(t2.X, 0, this.X, 0, t2.X.length);
        this.xOff = t2.xOff;
    }

    public String getAlgorithmName() {
        return "SHA-224";
    }

    public int getDigestSize() {
        return 28;
    }

    protected void processWord(byte[] in, int inOff) {
        int n2 = in[inOff] << 24;
        n2 |= (in[++inOff] & 0xFF) << 16;
        n2 |= (in[++inOff] & 0xFF) << 8;
        this.X[this.xOff] = n2 |= in[++inOff] & 0xFF;
        if (++this.xOff == 16) {
            this.processBlock();
        }
    }

    protected void processLength(long bitLength) {
        if (this.xOff > 14) {
            this.processBlock();
        }
        this.X[14] = (int)(bitLength >>> 32);
        this.X[15] = (int)(bitLength & 0xFFFFFFFFFFFFFFFFL);
    }

    public int doFinal(byte[] out, int outOff) {
        this.finish();
        SHA224Digest.intToBigEndian(this.H1, out, outOff);
        SHA224Digest.intToBigEndian(this.H2, out, outOff + 4);
        SHA224Digest.intToBigEndian(this.H3, out, outOff + 8);
        SHA224Digest.intToBigEndian(this.H4, out, outOff + 12);
        SHA224Digest.intToBigEndian(this.H5, out, outOff + 16);
        SHA224Digest.intToBigEndian(this.H6, out, outOff + 20);
        SHA224Digest.intToBigEndian(this.H7, out, outOff + 24);
        this.reset();
        return 28;
    }

    @Override
    public void reset() {
        int i2;
        this.byteCount = 0L;
        this.xBufOff = 0;
        for (i2 = 0; i2 < this.xBuf.length; ++i2) {
            this.xBuf[i2] = 0;
        }
        this.H1 = -1056596264;
        this.H2 = 914150663;
        this.H3 = 812702999;
        this.H4 = -150054599;
        this.H5 = -4191439;
        this.H6 = 1750603025;
        this.H7 = 1694076839;
        this.H8 = -1090891868;
        this.xOff = 0;
        for (i2 = 0; i2 != this.X.length; ++i2) {
            this.X[i2] = 0;
        }
    }

    protected void processBlock() {
        int i2;
        for (int t2 = 16; t2 <= 63; ++t2) {
            this.X[t2] = this.Theta1(this.X[t2 - 2]) + this.X[t2 - 7] + this.Theta0(this.X[t2 - 15]) + this.X[t2 - 16];
        }
        int a2 = this.H1;
        int b2 = this.H2;
        int c2 = this.H3;
        int d2 = this.H4;
        int e2 = this.H5;
        int f2 = this.H6;
        int g2 = this.H7;
        int h2 = this.H8;
        int t3 = 0;
        for (i2 = 0; i2 < 8; ++i2) {
            d2 += (h2 += this.Sum1(e2) + this.Ch(e2, f2, g2) + K[t3] + this.X[t3]);
            h2 += this.Sum0(a2) + this.Maj(a2, b2, c2);
            c2 += (g2 += this.Sum1(d2) + this.Ch(d2, e2, f2) + K[++t3] + this.X[t3]);
            g2 += this.Sum0(h2) + this.Maj(h2, a2, b2);
            b2 += (f2 += this.Sum1(c2) + this.Ch(c2, d2, e2) + K[++t3] + this.X[t3]);
            f2 += this.Sum0(g2) + this.Maj(g2, h2, a2);
            a2 += (e2 += this.Sum1(b2) + this.Ch(b2, c2, d2) + K[++t3] + this.X[t3]);
            e2 += this.Sum0(f2) + this.Maj(f2, g2, h2);
            h2 += (d2 += this.Sum1(a2) + this.Ch(a2, b2, c2) + K[++t3] + this.X[t3]);
            d2 += this.Sum0(e2) + this.Maj(e2, f2, g2);
            g2 += (c2 += this.Sum1(h2) + this.Ch(h2, a2, b2) + K[++t3] + this.X[t3]);
            c2 += this.Sum0(d2) + this.Maj(d2, e2, f2);
            f2 += (b2 += this.Sum1(g2) + this.Ch(g2, h2, a2) + K[++t3] + this.X[t3]);
            b2 += this.Sum0(c2) + this.Maj(c2, d2, e2);
            e2 += (a2 += this.Sum1(f2) + this.Ch(f2, g2, h2) + K[++t3] + this.X[t3]);
            a2 += this.Sum0(b2) + this.Maj(b2, c2, d2);
            ++t3;
        }
        this.H1 += a2;
        this.H2 += b2;
        this.H3 += c2;
        this.H4 += d2;
        this.H5 += e2;
        this.H6 += f2;
        this.H7 += g2;
        this.H8 += h2;
        this.xOff = 0;
        for (i2 = 0; i2 < 16; ++i2) {
            this.X[i2] = 0;
        }
    }

    private int Ch(int x2, int y2, int z2) {
        return x2 & y2 ^ ~x2 & z2;
    }

    private int Maj(int x2, int y2, int z2) {
        return x2 & y2 ^ x2 & z2 ^ y2 & z2;
    }

    private int Sum0(int x2) {
        return (x2 >>> 2 | x2 << 30) ^ (x2 >>> 13 | x2 << 19) ^ (x2 >>> 22 | x2 << 10);
    }

    private int Sum1(int x2) {
        return (x2 >>> 6 | x2 << 26) ^ (x2 >>> 11 | x2 << 21) ^ (x2 >>> 25 | x2 << 7);
    }

    private int Theta0(int x2) {
        return (x2 >>> 7 | x2 << 25) ^ (x2 >>> 18 | x2 << 14) ^ x2 >>> 3;
    }

    private int Theta1(int x2) {
        return (x2 >>> 17 | x2 << 15) ^ (x2 >>> 19 | x2 << 13) ^ x2 >>> 10;
    }

    @Override
    protected void engineUpdate(byte input) {
        this.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.update(input, offset, len);
    }

    @Override
    protected byte[] engineDigest() {
        byte[] digestBytes = new byte[this.getDigestSize()];
        this.doFinal(digestBytes, 0);
        return digestBytes;
    }

    @Override
    protected void engineReset() {
        this.reset();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        SHA224Digest d2 = new SHA224Digest(this);
        return d2;
    }

    public static int bigEndianToInt(byte[] bs, int off) {
        int n2 = bs[off] << 24;
        n2 |= (bs[++off] & 0xFF) << 16;
        n2 |= (bs[++off] & 0xFF) << 8;
        return n2 |= bs[++off] & 0xFF;
    }

    public static void intToBigEndian(int n2, byte[] bs, int off) {
        bs[off] = (byte)(n2 >>> 24);
        bs[++off] = (byte)(n2 >>> 16);
        bs[++off] = (byte)(n2 >>> 8);
        bs[++off] = (byte)n2;
    }

    public static long bigEndianToLong(byte[] bs, int off) {
        int hi = SHA224Digest.bigEndianToInt(bs, off);
        int lo = SHA224Digest.bigEndianToInt(bs, off + 4);
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static void longToBigEndian(long n2, byte[] bs, int off) {
        SHA224Digest.intToBigEndian((int)(n2 >>> 32), bs, off);
        SHA224Digest.intToBigEndian((int)(n2 & 0xFFFFFFFFL), bs, off + 4);
    }
}

