/*
 * Decompiled with CFR 0.152.
 */
package org.python.jline;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.python.jline.Terminal2;
import org.python.jline.TerminalSupport;
import org.python.jline.internal.InfoCmp;
import org.python.jline.internal.Log;
import org.python.jline.internal.Preconditions;
import org.python.jline.internal.TerminalLineSettings;

public class UnixTerminal
extends TerminalSupport
implements Terminal2 {
    private final TerminalLineSettings settings;
    private final String type;
    private String intr;
    private String lnext;
    private Set<String> bools = new HashSet<String>();
    private Map<String, Integer> ints = new HashMap<String, Integer>();
    private Map<String, String> strings = new HashMap<String, String>();

    public UnixTerminal() throws Exception {
        this("/dev/tty", null);
    }

    public UnixTerminal(String ttyDevice) throws Exception {
        this(ttyDevice, null);
    }

    public UnixTerminal(String ttyDevice, String type) throws Exception {
        super(true);
        Preconditions.checkNotNull(ttyDevice);
        this.settings = TerminalLineSettings.getSettings(ttyDevice);
        if (type == null) {
            type = System.getenv("TERM");
        }
        this.type = type;
        this.parseInfoCmp();
    }

    public TerminalLineSettings getSettings() {
        return this.settings;
    }

    public void init() throws Exception {
        super.init();
        this.setAnsiSupported(true);
        this.settings.set("-icanon min 1 -icrnl -inlcr -ixon");
        this.settings.undef("dsusp");
        this.setEchoEnabled(false);
        this.parseInfoCmp();
    }

    public void restore() throws Exception {
        this.settings.restore();
        super.restore();
    }

    public int getWidth() {
        int w2 = this.settings.getProperty("columns");
        return w2 < 1 ? 80 : w2;
    }

    public int getHeight() {
        int h2 = this.settings.getProperty("rows");
        return h2 < 1 ? 24 : h2;
    }

    public boolean hasWeirdWrap() {
        return this.getBooleanCapability("auto_right_margin") && this.getBooleanCapability("eat_newline_glitch");
    }

    public synchronized void setEchoEnabled(boolean enabled) {
        try {
            if (enabled) {
                this.settings.set("echo");
            } else {
                this.settings.set("-echo");
            }
            super.setEchoEnabled(enabled);
        }
        catch (Exception e2) {
            if (e2 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to ", enabled ? "enable" : "disable", " echo", e2);
        }
    }

    public void disableInterruptCharacter() {
        try {
            this.intr = this.getSettings().getPropertyAsString("intr");
            if ("<undef>".equals(this.intr)) {
                this.intr = null;
            }
            this.settings.undef("intr");
        }
        catch (Exception e2) {
            if (e2 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to disable interrupt character", e2);
        }
    }

    public void enableInterruptCharacter() {
        try {
            if (this.intr != null) {
                this.settings.set("intr", this.intr);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to enable interrupt character", e2);
        }
    }

    public void disableLitteralNextCharacter() {
        try {
            this.lnext = this.getSettings().getPropertyAsString("lnext");
            if ("<undef>".equals(this.lnext)) {
                this.lnext = null;
            }
            this.settings.undef("lnext");
        }
        catch (Exception e2) {
            if (e2 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to disable litteral next character", e2);
        }
    }

    public void enableLitteralNextCharacter() {
        try {
            if (this.lnext != null) {
                this.settings.set("lnext", this.lnext);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            Log.error("Failed to enable litteral next character", e2);
        }
    }

    public boolean getBooleanCapability(String capability) {
        return this.bools.contains(capability);
    }

    public Integer getNumericCapability(String capability) {
        return this.ints.get(capability);
    }

    public String getStringCapability(String capability) {
        return this.strings.get(capability);
    }

    private void parseInfoCmp() {
        String capabilities = null;
        if (this.type != null) {
            try {
                capabilities = InfoCmp.getInfoCmp(this.type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (capabilities == null) {
            capabilities = InfoCmp.getAnsiCaps();
        }
        InfoCmp.parseInfoCmp(capabilities, this.bools, this.ints, this.strings);
    }
}

